/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PropertiesUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.sun.jna.TypeMapper;
import com.sun.jna.platform.FileUtils;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jpountz.lz4.LZ4Factory;
import org.apache.log4j.Appender;
import org.apache.oro.text.regex.PatternMatcher;
import org.intellij.lang.annotations.Flow;
import org.jdom.Document;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    public static final String PROPERTIES_FILE = "idea.properties.file";
    public static final String PROPERTIES_FILE_NAME = "idea.properties";
    public static final String PROPERTY_HOME_PATH = "idea.home.path";
    public static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    public static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    public static final String PROPERTY_SCRATCH_PATH = "idea.scratch.path";
    public static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    public static final String PROPERTY_LOG_PATH = "idea.log.path";
    public static final String PROPERTY_LOG_CONFIG_FILE = "idea.log.config.file";
    public static final String PROPERTY_PATHS_SELECTOR = "idea.paths.selector";
    public static final String OPTIONS_DIRECTORY = "options";
    public static final String DEFAULT_EXT = ".xml";
    public static final String DEFAULT_OPTIONS_FILE = "other.xml";
    private static final String PROPERTY_HOME = "idea.home";
    private static final String LIB_DIRECTORY = "lib";
    private static final String PLUGINS_DIRECTORY = "plugins";
    private static final String BIN_DIRECTORY = "bin";
    private static final String LOG_DIRECTORY = "log";
    private static final String CONFIG_DIRECTORY = "config";
    private static final String SYSTEM_DIRECTORY = "system";
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static final String IDE_VENDOR_NAME = System.getProperty("idea.vendor.name", "JetBrains");
    private static volatile String ourHomePath;
    private static volatile List<Path> ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourScratchPath;
    private static String ourPluginsPath;
    private static String ourLogPath;

    @NotNull
    public static String getHomePath() {
        String string = PathManager.getHomePath(true);
        if (string == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        String result = ourHomePath;
        if (result != null) {
            return result;
        }
        Class<PathManager> clazz = PathManager.class;
        synchronized (PathManager.class) {
            result = ourHomePath;
            if (result != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
            String explicit = PathManager.getExplicitPath(PROPERTY_HOME_PATH);
            if (explicit == null) {
                explicit = PathManager.getExplicitPath(PROPERTY_HOME);
            }
            if (explicit != null) {
                result = explicit;
                if (!Files.isDirectory(Paths.get(result, new String[0]), new LinkOption[0])) {
                    ourHomePath = result;
                    throw new RuntimeException("Invalid home path '" + result + "'");
                }
            } else if (insideIde && (result = PathManager.getHomePathFor(PathManager.class)) == null) {
                String advice = SystemInfoRt.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
            if (result != null && SystemInfoRt.isWindows) {
                try {
                    result = Paths.get(result, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ourBinDirectories = result == null ? Collections.emptyList() : PathManager.getBinDirectories(Paths.get(result, new String[0]));
            ourHomePath = result;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    private static List<Path> getBinDirectories() {
        List<Path> result = ourBinDirectories;
        if (result == null) {
            PathManager.getHomePath(true);
            result = ourBinDirectories;
        }
        return result;
    }

    public static boolean isUnderHomeDirectory(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(1);
        }
        Path home = Paths.get(PathManager.getHomePath(), new String[0]);
        Path target = Paths.get(path, new String[0]);
        try {
            home = home.toRealPath(new LinkOption[0]);
            target = target.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return target.startsWith(home);
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class<?> aClass) {
        String rootPath;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(2);
        }
        if ((rootPath = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class")) == null) {
            return null;
        }
        Path root = Paths.get(rootPath, new String[0]).toAbsolutePath();
        while ((root = root.getParent()) != null && !PathManager.isIdeaHome(root)) {
        }
        return root != null ? root.toString() : null;
    }

    private static boolean isIdeaHome(Path root) {
        for (Path binDir : PathManager.getBinDirectories(root)) {
            if (!Files.isRegularFile(binDir.resolve(PROPERTIES_FILE_NAME), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static List<Path> getBinDirectories(Path root) {
        ArrayList<Path> binDirs = new ArrayList<Path>();
        String[] subDirs = new String[]{BIN_DIRECTORY, "community/bin", "ultimate/community/bin"};
        String osSuffix = SystemInfoRt.isWindows ? "win" : (SystemInfoRt.isMac ? "mac" : "linux");
        for (String subDir : subDirs) {
            Path dir = root.resolve(subDir);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            dir = dir.resolve(osSuffix);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
        }
        return binDirs;
    }

    @NotNull
    public static String getBinPath() {
        String string = PathManager.getHomePath() + '/' + BIN_DIRECTORY;
        if (string == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static File findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        for (Path binDir : PathManager.getBinDirectories()) {
            Path candidate = binDir.resolve(fileName);
            if (!Files.isRegularFile(candidate, new LinkOption[0])) continue;
            return candidate.toFile();
        }
        return null;
    }

    @NotNull
    public static File findBinFileWithException(@NotNull String fileName) throws FileNotFoundException {
        File file;
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        if ((file = PathManager.findBinFile(fileName)) != null) {
            File file2 = file;
            if (file2 == null) {
                PathManager.$$$reportNull$$$0(6);
            }
            return file2;
        }
        StringBuilder message = new StringBuilder();
        message.append('\'').append(fileName).append("' not found in directories:");
        for (Path directory : PathManager.getBinDirectories()) {
            message.append('\n').append(directory);
        }
        throw new FileNotFoundException(message.toString());
    }

    @NotNull
    public static String getLibPath() {
        String string = PathManager.getHomePath() + '/' + LIB_DIRECTORY;
        if (string == null) {
            PathManager.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string = PathManager.getHomePath() + '/' + PLUGINS_DIRECTORY;
        if (string == null) {
            PathManager.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static String getPathsSelector() {
        return PATHS_SELECTOR;
    }

    @NotNull
    public static Path getConfigDir() {
        Path path = Paths.get(PathManager.getConfigPath(), new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(9);
        }
        return path;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string = ourConfigPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(10);
            }
            return string;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_CONFIG_PATH);
        ourConfigPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + CONFIG_DIRECTORY);
        String string = ourConfigPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String getScratchPath() {
        if (ourScratchPath != null) {
            String string = ourScratchPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(12);
            }
            return string;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_SCRATCH_PATH);
        ourScratchPath = explicit != null ? explicit : PathManager.getConfigPath();
        String string = ourScratchPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(14);
        }
        String string = PathManager.platformPath(selector, "Application Support", "", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
        if (string == null) {
            PathManager.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String getOptionsPath() {
        String string = PathManager.getConfigPath() + '/' + OPTIONS_DIRECTORY;
        if (string == null) {
            PathManager.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static File getOptionsFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(17);
        }
        File file = Paths.get(PathManager.getOptionsPath(), fileName + DEFAULT_EXT).toFile();
        if (file == null) {
            PathManager.$$$reportNull$$$0(18);
        }
        return file;
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            String string = ourPluginsPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(19);
            }
            return string;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_PLUGINS_PATH);
        ourPluginsPath = explicit != null ? explicit : (PATHS_SELECTOR != null && System.getProperty(PROPERTY_CONFIG_PATH) == null ? PathManager.getDefaultPluginPathFor(PATHS_SELECTOR) : PathManager.getConfigPath() + '/' + PLUGINS_DIRECTORY);
        String string = ourPluginsPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String getDefaultPluginPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(21);
        }
        String string = PathManager.platformPath(selector, "Application Support", PLUGINS_DIRECTORY, "APPDATA", PLUGINS_DIRECTORY, "XDG_DATA_HOME", ".local/share", "");
        if (string == null) {
            PathManager.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    public static String getCustomOptionsDirectory() {
        return PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : null;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string = ourSystemPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(23);
            }
            return string;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_SYSTEM_PATH);
        ourSystemPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + SYSTEM_DIRECTORY);
        String string = ourSystemPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(25);
        }
        String string = PathManager.platformPath(selector, "Caches", "", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
        if (string == null) {
            PathManager.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getTempPath() {
        String string = PathManager.getSystemPath() + "/tmp";
        if (string == null) {
            PathManager.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static File getIndexRoot() {
        String indexRootPath = PathManager.getExplicitPath("index_root_path");
        if (indexRootPath == null) {
            indexRootPath = PathManager.getSystemPath() + "/index";
        }
        File file = Paths.get(indexRootPath, new String[0]).toFile();
        if (file == null) {
            PathManager.$$$reportNull$$$0(28);
        }
        return file;
    }

    @NotNull
    public static String getLogPath() {
        if (ourLogPath != null) {
            String string = ourLogPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(29);
            }
            return string;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_LOG_PATH);
        ourLogPath = explicit != null ? explicit : (PATHS_SELECTOR != null && System.getProperty(PROPERTY_SYSTEM_PATH) == null ? PathManager.platformPath(PATHS_SELECTOR, "Logs", "", "LOCALAPPDATA", LOG_DIRECTORY, "XDG_CACHE_HOME", ".cache", LOG_DIRECTORY) : PathManager.getSystemPath() + '/' + LOG_DIRECTORY);
        String string = ourLogPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static String getPluginTempPath() {
        String string = PathManager.getSystemPath() + '/' + PLUGINS_DIRECTORY;
        if (string == null) {
            PathManager.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class<?> context, @NotNull String path) {
        URL url;
        if (context == null) {
            PathManager.$$$reportNull$$$0(32);
        }
        if (path == null) {
            PathManager.$$$reportNull$$$0(33);
        }
        if ((url = context.getResource(path)) == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader cl, @NotNull String resourcePath) {
        URL url;
        if (cl == null) {
            PathManager.$$$reportNull$$$0(34);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(35);
        }
        return (url = cl.getResource(resourcePath)) != null ? PathManager.extractRoot(url, resourcePath) : null;
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (resourcePath.length() == 0 || resourcePath.charAt(0) != '/' && resourcePath.charAt(0) != '\\') {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path = URLUtil.urlToFile(resourceURL).getPath();
            String testPath = path.replace('\\', '/');
            if (StringUtilRt.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            Pair<String, String> paths = URLUtil.splitJarUrl(resourceURL.getFile());
            if (paths != null && paths.first != null) {
                resultPath = (String)paths.first;
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return Paths.get(resultPath, new String[0]).normalize().toString();
    }

    public static void loadProperties() {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        paths.add(System.getProperty(PROPERTIES_FILE));
        paths.add(PathManager.getCustomPropertiesFile());
        paths.add(SystemProperties.getUserHome() + '/' + PROPERTIES_FILE_NAME);
        for (Path binDir : PathManager.getBinDirectories()) {
            paths.add(binDir.resolve(PROPERTIES_FILE_NAME).toString());
        }
        Properties sysProperties = System.getProperties();
        for (String path : paths) {
            Path file = path != null ? Paths.get(path, new String[0]) : null;
            if (file == null || !Files.exists(file, new LinkOption[0])) continue;
            try {
                BufferedReader reader = Files.newBufferedReader(file);
                Throwable throwable = null;
                try {
                    Map<String, String> properties = PropertiesUtil.loadProperties(reader);
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        String key = entry.getKey();
                        if (PROPERTY_HOME_PATH.equals(key) || PROPERTY_HOME.equals(key)) {
                            PathManager.log(path + ": '" + key + "' cannot be redefined");
                            continue;
                        }
                        if (sysProperties.containsKey(key)) continue;
                        sysProperties.setProperty(key, PathManager.substituteVars(entry.getValue()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                PathManager.log("Can't read property file '" + path + "': " + e.getMessage());
            }
        }
    }

    private static String getCustomPropertiesFile() {
        String configPath = PathManager.getCustomOptionsDirectory();
        return configPath != null ? configPath + '/' + PROPERTIES_FILE_NAME : null;
    }

    @Contract(value="null -> null")
    public static String substituteVars(String s) {
        return PathManager.substituteVars(s, PathManager.getHomePath());
    }

    @Contract(value="null, _ -> null")
    public static String substituteVars(String s, @NotNull String ideaHomePath) {
        if (ideaHomePath == null) {
            PathManager.$$$reportNull$$$0(36);
        }
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + '/' + BIN_DIRECTORY + '/' + s;
        }
        Matcher m = Lazy.PROPERTY_REF.matcher(s);
        while (m.find()) {
            String key = m.group(1);
            String value = System.getProperty(key);
            if (value == null) {
                if (PROPERTY_HOME_PATH.equals(key) || PROPERTY_HOME.equals(key)) {
                    value = ideaHomePath;
                } else if (PROPERTY_CONFIG_PATH.equals(key)) {
                    value = PathManager.getConfigPath();
                } else if (PROPERTY_SYSTEM_PATH.equals(key)) {
                    value = PathManager.getSystemPath();
                }
            }
            if (value == null) {
                PathManager.log("Unknown property: " + key);
                value = "";
            }
            s = s.replace(m.group(), value);
            m = Lazy.PROPERTY_REF.matcher(s);
        }
        return s;
    }

    @NotNull
    public static File findFileInLibDirectory(@NotNull String relativePath) {
        Path file;
        if (relativePath == null) {
            PathManager.$$$reportNull$$$0(37);
        }
        if (!Files.exists(file = Paths.get(PathManager.getLibPath(), relativePath), new LinkOption[0])) {
            file = Paths.get(PathManager.getHomePath(), "community/lib/" + relativePath);
        }
        File file2 = file.toFile();
        if (file2 == null) {
            PathManager.$$$reportNull$$$0(38);
        }
        return file2;
    }

    @NotNull
    public static String getCommunityHomePath() {
        String path = PathManager.getHomePath();
        if (Files.isDirectory(Paths.get(path, "community/.idea"), new LinkOption[0])) {
            String string = path + "/community";
            if (string == null) {
                PathManager.$$$reportNull$$$0(39);
            }
            return string;
        }
        if (Files.isDirectory(Paths.get(path, "ultimate/community/.idea"), new LinkOption[0])) {
            String string = path + "/ultimate/community";
            if (string == null) {
                PathManager.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            PathManager.$$$reportNull$$$0(41);
        }
        return string;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        String resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(42);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class")) != null ? Paths.get(resourceRoot, new String[0]).toAbsolutePath().toString() : null;
    }

    @NotNull
    public static Collection<String> getUtilClassPath() {
        Class[] classes;
        HashSet<String> classPath = new HashSet<String>();
        for (Class aClass : classes = new Class[]{PathManager.class, SystemInfoRt.class, UrlClassLoader.class, Flow.class, Document.class, Appender.class, THashSet.class, TypeMapper.class, FileUtils.class, PatternMatcher.class, LZ4Factory.class}) {
            String path = PathManager.getJarPathForClass(aClass);
            if (path == null) continue;
            classPath.add(path);
        }
        String resourceRoot = PathManager.getResourceRoot(PathManager.class, "/messages/CommonBundle.properties");
        if (resourceRoot != null) {
            classPath.add(Paths.get(resourceRoot, new String[0]).toAbsolutePath().toString());
        }
        HashSet<String> hashSet = classPath;
        if (hashSet == null) {
            PathManager.$$$reportNull$$$0(43);
        }
        return hashSet;
    }

    private static void log(String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(44);
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = SystemProperties.getUserHome() + path.substring(1);
        }
        String string = Paths.get(path, new String[0]).toAbsolutePath().normalize().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(45);
        }
        return string;
    }

    @Nullable
    private static String getExplicitPath(String property) {
        String path = System.getProperty(property);
        return path != null ? PathManager.getAbsolutePath(StringUtilRt.unquoteString(path, '\"')) : null;
    }

    private static String platformPath(String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        String userHome = SystemProperties.getUserHome();
        if (SystemInfoRt.isMac) {
            String dir = userHome + "/Library/" + macDir + '/' + IDE_VENDOR_NAME + '/' + selector;
            if (!macSub.isEmpty()) {
                dir = dir + '/' + macSub;
            }
            return dir;
        }
        if (SystemInfoRt.isWindows) {
            String dir = System.getenv(winVar);
            if (dir == null || dir.isEmpty()) {
                dir = userHome + "\\AppData\\" + (winVar.startsWith("LOCAL") ? "Local" : "Roaming");
            }
            dir = dir + '\\' + IDE_VENDOR_NAME + '\\' + selector;
            if (!winSub.isEmpty()) {
                dir = dir + '\\' + winSub;
            }
            return dir;
        }
        if (SystemInfoRt.isUnix) {
            String dir = System.getenv(xdgVar);
            if (dir == null || dir.isEmpty()) {
                dir = userHome + '/' + xdgDfl;
            }
            dir = dir + '/' + IDE_VENDOR_NAME + '/' + selector;
            if (!xdgSub.isEmpty()) {
                dir = dir + '/' + xdgSub;
            }
            return dir;
        }
        throw new UnsupportedOperationException("Unsupported OS: " + SystemInfoRt.OS_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 21: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 21: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: 
            case 33: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 14: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaHomePath";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 21: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDir";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtilClassPath";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "substituteVars";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 21: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Lazy {
        private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");

        private Lazy() {
        }
    }
}

