/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonProcessors {
    private static final Processor<Object> FALSE = __ -> false;
    private static final Processor<Object> TRUE = __ -> true;

    @NotNull
    public static <T> Processor<T> notNullProcessor(@NotNull Processor<? super T> processor) {
        if (processor == null) {
            CommonProcessors.$$$reportNull$$$0(0);
        }
        Processor<Object> processor2 = processor::process;
        if (processor2 == null) {
            CommonProcessors.$$$reportNull$$$0(1);
        }
        return processor2;
    }

    @NotNull
    public static <T> Processor<T> processAll(@NotNull Consumer<? super T> consumer) {
        if (consumer == null) {
            CommonProcessors.$$$reportNull$$$0(2);
        }
        Processor<Object> processor = t -> {
            consumer.consume(t);
            return true;
        };
        if (processor == null) {
            CommonProcessors.$$$reportNull$$$0(3);
        }
        return processor;
    }

    @NotNull
    public static <T> Processor<T> alwaysFalse() {
        Processor<Object> processor = FALSE;
        if (processor == null) {
            CommonProcessors.$$$reportNull$$$0(4);
        }
        return processor;
    }

    @NotNull
    public static <T> Processor<T> alwaysTrue() {
        Processor<Object> processor = TRUE;
        if (processor == null) {
            CommonProcessors.$$$reportNull$$$0(5);
        }
        return processor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/CommonProcessors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/CommonProcessors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processAll";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "alwaysFalse";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "alwaysTrue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "notNullProcessor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FindFirstAndOnlyProcessor<T>
    extends FindFirstProcessor<T> {
        @Override
        public boolean process(T t) {
            boolean firstFound = this.getFoundValue() != null;
            boolean result = super.process(t);
            if (!result) {
                if (firstFound) {
                    this.reset();
                }
                return !firstFound;
            }
            return true;
        }
    }

    public static class FindFirstProcessor<T>
    extends FindProcessor<T> {
        @Override
        protected boolean accept(T t) {
            return true;
        }
    }

    public static abstract class FindProcessor<T>
    implements Processor<T> {
        private T myValue;

        public boolean isFound() {
            return this.myValue != null;
        }

        @Nullable
        public T getFoundValue() {
            return this.myValue;
        }

        @Nullable
        public T reset() {
            T prev = this.myValue;
            this.myValue = null;
            return prev;
        }

        @Override
        public boolean process(T t) {
            if (this.accept(t)) {
                this.myValue = t;
                return false;
            }
            return true;
        }

        protected abstract boolean accept(T var1);
    }

    public static class UniqueProcessor<T>
    implements Processor<T> {
        private final Set<T> processed;
        private final Processor<? super T> myDelegate;

        public UniqueProcessor(@NotNull Processor<? super T> delegate) {
            if (delegate == null) {
                UniqueProcessor.$$$reportNull$$$0(0);
            }
            this(delegate, ContainerUtil.canonicalStrategy());
        }

        public UniqueProcessor(@NotNull Processor<? super T> delegate, @NotNull TObjectHashingStrategy<T> strategy) {
            if (delegate == null) {
                UniqueProcessor.$$$reportNull$$$0(1);
            }
            if (strategy == null) {
                UniqueProcessor.$$$reportNull$$$0(2);
            }
            this.myDelegate = delegate;
            this.processed = new THashSet(strategy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean process(T t) {
            Set<T> set = this.processed;
            synchronized (set) {
                if (this.processed.contains(t)) {
                    return true;
                }
            }
            boolean result = this.myDelegate.process(t);
            Set<T> set2 = this.processed;
            synchronized (set2) {
                this.processed.add(t);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "strategy";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/CommonProcessors$UniqueProcessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CollectUniquesProcessor<T>
    implements Processor<T> {
        private final Set<T> myCollection = new HashSet<T>();

        @Override
        public boolean process(T t) {
            this.myCollection.add(t);
            return true;
        }

        public T @NotNull [] toArray(T @NotNull [] a) {
            if (a == null) {
                CollectUniquesProcessor.$$$reportNull$$$0(0);
            }
            T[] TArray = this.myCollection.toArray(a);
            if (TArray == null) {
                CollectUniquesProcessor.$$$reportNull$$$0(1);
            }
            return TArray;
        }

        @NotNull
        public Collection<T> getResults() {
            Set<T> set = this.myCollection;
            if (set == null) {
                CollectUniquesProcessor.$$$reportNull$$$0(2);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/CommonProcessors$CollectUniquesProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/CommonProcessors$CollectUniquesProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CollectProcessor<T>
    implements Processor<T> {
        private final Collection<T> myCollection;

        public CollectProcessor(@NotNull Collection<T> collection) {
            if (collection == null) {
                CollectProcessor.$$$reportNull$$$0(0);
            }
            this.myCollection = collection;
        }

        public CollectProcessor() {
            this.myCollection = new ArrayList<T>();
        }

        @Override
        public boolean process(T t) {
            if (this.accept(t)) {
                this.myCollection.add(t);
            }
            return true;
        }

        protected boolean accept(T t) {
            return true;
        }

        public T @NotNull [] toArray(T @NotNull [] a) {
            if (a == null) {
                CollectProcessor.$$$reportNull$$$0(1);
            }
            T[] TArray = this.myCollection.toArray(a);
            if (TArray == null) {
                CollectProcessor.$$$reportNull$$$0(2);
            }
            return TArray;
        }

        @NotNull
        public Collection<T> getResults() {
            Collection<T> collection = this.myCollection;
            if (collection == null) {
                CollectProcessor.$$$reportNull$$$0(3);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/CommonProcessors$CollectProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/CommonProcessors$CollectProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

