/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.sh.ShStringUtil;
import com.intellij.sh.ShTypes;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.psi.ShString;
import com.intellij.sh.statistics.ShFeatureUsagesCollector;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShFilePathCompletionContributor
extends CompletionContributor
implements DumbAware {
    @NonNls
    private static final String FEATURE_ACTION_ID = "FilePathCompletionUsed";
    private static final InsertHandler<LookupElement> FILE_INSERT_HANDLER = (context, item) -> {
        boolean needInsertSlash;
        File file = (File)item.getObject();
        Document document = context.getEditor().getDocument();
        int end = context.getSelectionEndOffset();
        boolean endOfFile = document.getTextLength() == end;
        boolean alreadyFollowedBySlash = end < document.getTextLength() && document.getCharsSequence().charAt(end) == '/';
        boolean bl = needInsertSlash = endOfFile || !alreadyFollowedBySlash;
        if (file.isDirectory()) {
            if (needInsertSlash) {
                document.insertString(end, (CharSequence)"/");
            }
            context.getEditor().getCaretModel().moveToOffset(end + 1);
            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
        }
        ShFeatureUsagesCollector.logFeatureUsage(FEATURE_ACTION_ID);
    };

    public void duringCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            ShFilePathCompletionContributor.$$$reportNull$$$0(0);
        }
        super.duringCompletion(context);
        Caret caret = context.getCaret();
        Editor editor = context.getEditor();
        context.setReplacementOffset(ShFilePathCompletionContributor.calcDefaultIdentifierEnd(editor, ShFilePathCompletionContributor.calcSelectionEnd(caret)));
    }

    private static int calcSelectionEnd(@NotNull Caret caret) {
        if (caret == null) {
            ShFilePathCompletionContributor.$$$reportNull$$$0(1);
        }
        return caret.hasSelection() ? caret.getSelectionEnd() : caret.getOffset();
    }

    private static int calcDefaultIdentifierEnd(@NotNull Editor editor, int startFrom) {
        if (editor == null) {
            ShFilePathCompletionContributor.$$$reportNull$$$0(2);
        }
        CharSequence text = editor.getDocument().getCharsSequence();
        int idEnd = startFrom;
        int length = text.length();
        while (idEnd < length) {
            char ch = text.charAt(idEnd);
            if (Character.isJavaIdentifierPart(ch) || ch == '.' || ch == '-' || ch == '@') {
                ++idEnd;
                continue;
            }
            if (idEnd < length - 1 && ch == '\\' && ShStringUtil.ORIGINS_SET.contains(Character.valueOf(text.charAt(idEnd + 1)))) {
                idEnd += 2;
                continue;
            }
            return idEnd;
        }
        return idEnd;
    }

    public ShFilePathCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(ShFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                int lastSlashIndex;
                String originalText;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((originalText = ShFilePathCompletionContributor.getTextWithEnvVarReplacement(parameters)) != null && (lastSlashIndex = originalText.lastIndexOf("/")) >= 0) {
                    String afterSlash = originalText.substring(lastSlashIndex + 1);
                    String beforeSlash = originalText.substring(0, lastSlashIndex);
                    boolean isRoot = beforeSlash.isEmpty();
                    if (beforeSlash.startsWith("/") || isRoot || beforeSlash.startsWith("~")) {
                        Object[] files;
                        File dir;
                        String path = beforeSlash.equals("~") ? "~/" : beforeSlash;
                        String maybeFilePath = FileUtil.expandUserHome((String)ShStringUtil.unquote(path));
                        File file = dir = isRoot ? new File("/") : new File(maybeFilePath);
                        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
                            List collect = ContainerUtil.map((Object[])files, x$0 -> ShFilePathCompletionContributor.createFileLookupElement(x$0));
                            String prefix = afterSlash.endsWith("\\") ? afterSlash.substring(0, afterSlash.length() - 1) : afterSlash;
                            result.withPrefixMatcher(prefix).caseInsensitive().addAllElements((Iterable)collect);
                        }
                        result.stopHere();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sh/completion/ShFilePathCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static LookupElement createFileLookupElement(@NotNull File file) {
        if (file == null) {
            ShFilePathCompletionContributor.$$$reportNull$$$0(3);
        }
        String name = file.getName();
        boolean isDirectory = file.isDirectory();
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)file, (String)ShStringUtil.quote(name)).withIcon(isDirectory ? PlatformIcons.FOLDER_ICON : null).withInsertHandler(FILE_INSERT_HANDLER);
        if (lookupElementBuilder == null) {
            ShFilePathCompletionContributor.$$$reportNull$$$0(4);
        }
        return lookupElementBuilder;
    }

    @Nullable
    private static String getTextWithEnvVarReplacement(@NotNull CompletionParameters parameters) {
        PsiElement original;
        if (parameters == null) {
            ShFilePathCompletionContributor.$$$reportNull$$$0(5);
        }
        if ((original = parameters.getOriginalPosition()) == null) {
            return null;
        }
        int textLength = parameters.getOffset() - parameters.getPosition().getTextRange().getStartOffset();
        String originalText = original.getText().substring(0, textLength);
        int offset = original.getTextOffset() - 1;
        if (offset < 0) {
            return originalText;
        }
        PsiElement var = ShFilePathCompletionContributor.getNearestVarIfExist(parameters.getOriginalFile(), offset);
        if (var == null) {
            return originalText;
        }
        String variable = ShFilePathCompletionContributor.variableText(var);
        String envPath = EnvironmentUtil.getValue((String)variable);
        return envPath != null ? envPath + originalText : originalText;
    }

    @Nullable
    private static PsiElement getNearestVarIfExist(@NotNull PsiFile file, int offset) {
        PsiElement e;
        if (file == null) {
            ShFilePathCompletionContributor.$$$reportNull$$$0(6);
        }
        if (!((e = file.findElementAt(offset)) instanceof LeafPsiElement)) {
            return null;
        }
        LeafPsiElement leaf = (LeafPsiElement)e;
        if (leaf.getElementType() == ShTypes.VAR) {
            return leaf;
        }
        if (ShFilePathCompletionContributor.isStringOfVar(leaf)) {
            return leaf.getPrevSibling();
        }
        return null;
    }

    private static boolean isStringOfVar(@NotNull LeafPsiElement e) {
        if (e == null) {
            ShFilePathCompletionContributor.$$$reportNull$$$0(7);
        }
        if (e.getElementType() != ShTypes.CLOSE_QUOTE) {
            return false;
        }
        PsiElement str = e.getParent();
        if (!(str instanceof ShString)) {
            return false;
        }
        ASTNode[] children = str.getNode().getChildren(null);
        return children.length == 3 && children[0].getElementType() == ShTypes.OPEN_QUOTE && children[1].getElementType() == ShTypes.VARIABLE && children[2].getElementType() == ShTypes.CLOSE_QUOTE;
    }

    @NotNull
    private static String variableText(PsiElement e) {
        String variable = e.getText();
        int index = variable.indexOf("$");
        if (index + 1 <= 0) {
            String string = variable;
            if (string == null) {
                ShFilePathCompletionContributor.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = variable.substring(index + 1);
        if (string == null) {
            ShFilePathCompletionContributor.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/completion/ShFilePathCompletionContributor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/completion/ShFilePathCompletionContributor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileLookupElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "variableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "duringCompletion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calcSelectionEnd";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcDefaultIdentifierEnd";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFileLookupElement";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithEnvVarReplacement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNearestVarIfExist";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isStringOfVar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

