/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.formatter;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.settings.ShSettings;
import com.intellij.sh.statistics.ShFeatureUsagesCollector;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShShfmtFormatterUtil {
    private static final Logger LOG = Logger.getInstance(ShShfmtFormatterUtil.class);
    private static final String FEATURE_ACTION_ID = "ExternalFormatterDownloaded";
    private static final String SHFMT = "shfmt";
    private static final String SHFMT_VERSION = "v2.6.4";
    private static final String DOWNLOAD_PATH = PathManager.getPluginsPath() + File.separator + ShLanguage.INSTANCE.getID();
    private static final String ARCH_i386 = "_386";
    private static final String ARCH_x86_64 = "_amd64";
    private static final String WINDOWS = "_windows";
    private static final String WINDOWS_EXTENSION = ".exe";
    private static final String MAC = "_darwin";
    private static final String LINUX = "_linux";
    private static final String FREE_BSD = "_freebsd";

    public static void download(@Nullable Project project, @NotNull CodeStyleSettings settings, final @NotNull Runnable onSuccess, final @NotNull Runnable onFailure) {
        File formatter;
        File directory;
        if (settings == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(0);
        }
        if (onSuccess == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(1);
        }
        if (onFailure == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(2);
        }
        if (!(directory = new File(DOWNLOAD_PATH)).exists()) {
            directory.mkdirs();
        }
        if ((formatter = new File(DOWNLOAD_PATH + File.separator + SHFMT + (SystemInfo.isWindows ? WINDOWS_EXTENSION : ""))).exists()) {
            try {
                String formatterPath = formatter.getCanonicalPath();
                if (ShSettings.getShfmtPath().equals(formatterPath)) {
                    LOG.debug("Shfmt formatter already downloaded");
                } else {
                    ShSettings.setShfmtPath(formatterPath);
                }
                ApplicationManager.getApplication().invokeLater(onSuccess);
                return;
            }
            catch (IOException e) {
                LOG.debug("Can't evaluate formatter path", (Throwable)e);
                ApplicationManager.getApplication().invokeLater(onFailure);
                return;
            }
        }
        String downloadName = SHFMT + (SystemInfo.isWindows ? WINDOWS_EXTENSION : "");
        DownloadableFileService service = DownloadableFileService.getInstance();
        DownloadableFileDescription description = service.createFileDescription(ShShfmtFormatterUtil.getShfmtDistributionLink(), downloadName);
        final FileDownloader downloader = service.createDownloader(Collections.singletonList(description), downloadName);
        Task.Backgroundable task = new Task.Backgroundable(project, ShBundle.message("sh.label.download.shfmt.formatter", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    File file;
                    List pairs = downloader.download(new File(DOWNLOAD_PATH));
                    Pair first = (Pair)ContainerUtil.getFirstItem((List)pairs);
                    File file2 = file = first != null ? (File)first.first : null;
                    if (file != null) {
                        FileUtil.setExecutable((File)file);
                        ShSettings.setShfmtPath(file.getCanonicalPath());
                        ApplicationManager.getApplication().invokeLater(onSuccess);
                        ShFeatureUsagesCollector.logFeatureUsage(ShShfmtFormatterUtil.FEATURE_ACTION_ID);
                    }
                }
                catch (IOException e) {
                    LOG.warn("Can't download shfmt formatter", (Throwable)e);
                    ApplicationManager.getApplication().invokeLater(onFailure);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/sh/formatter/ShShfmtFormatterUtil$1", "run"));
            }
        };
        BackgroundableProcessIndicator processIndicator = new BackgroundableProcessIndicator(task);
        processIndicator.setIndeterminate(false);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)processIndicator);
    }

    public static boolean isValidPath(@Nullable String path) {
        if (path == null) {
            return false;
        }
        if ("I do mind".equals(path)) {
            return true;
        }
        File file = new File(path);
        if (!file.canExecute()) {
            return false;
        }
        return file.getName().contains(SHFMT);
    }

    @NotNull
    private static String getShfmtDistributionLink() {
        StringBuilder baseUrl = new StringBuilder("https://github.com/mvdan/sh/releases/download/").append(SHFMT_VERSION).append('/').append(SHFMT).append('_').append(SHFMT_VERSION);
        if (SystemInfo.isMac) {
            baseUrl.append(MAC);
        }
        if (SystemInfo.isLinux) {
            baseUrl.append(LINUX);
        }
        if (SystemInfo.isWindows) {
            baseUrl.append(WINDOWS);
        }
        if (SystemInfo.isFreeBSD) {
            baseUrl.append(FREE_BSD);
        }
        if (SystemInfo.is64Bit) {
            baseUrl.append(ARCH_x86_64);
        } else {
            baseUrl.append(ARCH_i386);
        }
        if (SystemInfo.isWindows) {
            baseUrl.append(WINDOWS_EXTENSION);
        }
        String string = baseUrl.toString();
        if (string == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/formatter/ShShfmtFormatterUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/formatter/ShShfmtFormatterUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShfmtDistributionLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

