/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInsight;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import org.gradle.util.GUtil;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public final class UseDistributionWithSourcesNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    public static final Pattern GRADLE_SRC_DISTRIBUTION_PATTERN;
    private static final Logger LOG;
    private static final Key<EditorNotificationPanel> KEY;
    private static final String ALL_ZIP_DISTRIBUTION_URI_SUFFIX = "-all.zip";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            UseDistributionWithSourcesNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            UseDistributionWithSourcesNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            UseDistributionWithSourcesNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            UseDistributionWithSourcesNotificationProvider.$$$reportNull$$$0(3);
        }
        try {
            if ("build.gradle".equals(file.getName()) || "settings.gradle".equals(file.getName())) {
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
                if (module == null) {
                    return null;
                }
                String rootProjectPath = UseDistributionWithSourcesNotificationProvider.getRootProjectPath(module);
                if (rootProjectPath == null) {
                    return null;
                }
                GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance((Project)module.getProject()).getLinkedProjectSettings(rootProjectPath);
                if (settings == null || settings.getDistributionType() != DistributionType.DEFAULT_WRAPPED) {
                    return null;
                }
                if (settings.isDisableWrapperSourceDistributionNotification()) {
                    return null;
                }
                if (!UseDistributionWithSourcesNotificationProvider.showUseDistributionWithSourcesTip(rootProjectPath)) {
                    return null;
                }
                EditorNotificationPanel panel = new EditorNotificationPanel(LightColors.SLIGHTLY_GREEN);
                panel.setText(GradleBundle.message((String)"gradle.notifications.use.distribution.with.sources", (Object[])new Object[0]));
                panel.createActionLabel(GradleBundle.message((String)"gradle.notifications.hide.tip", (Object[])new Object[0]), () -> {
                    settings.setDisableWrapperSourceDistributionNotification(true);
                    EditorNotifications.getInstance((Project)module.getProject()).updateAllNotifications();
                });
                panel.createActionLabel(GradleBundle.message((String)"gradle.notifications.apply.suggestion", (Object[])new Object[0]), () -> {
                    UseDistributionWithSourcesNotificationProvider.updateDefaultWrapperConfiguration(rootProjectPath);
                    EditorNotifications.getInstance((Project)module.getProject()).updateAllNotifications();
                    ExternalSystemUtil.refreshProject((String)settings.getExternalProjectPath(), (ImportSpecBuilder)new ImportSpecBuilder(module.getProject(), GradleConstants.SYSTEM_ID).use(ProgressExecutionMode.START_IN_FOREGROUND_ASYNC));
                });
                return panel;
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException throwable) {
            // empty catch block
        }
        return null;
    }

    private static void updateDefaultWrapperConfiguration(@NotNull String linkedProjectPath) {
        if (linkedProjectPath == null) {
            UseDistributionWithSourcesNotificationProvider.$$$reportNull$$$0(4);
        }
        try {
            File wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile((String)linkedProjectPath);
            if (wrapperPropertiesFile == null) {
                return;
            }
            WrapperConfiguration wrapperConfiguration = GradleUtil.getWrapperConfiguration((String)linkedProjectPath);
            if (wrapperConfiguration == null) {
                return;
            }
            String currentDistributionUri = wrapperConfiguration.getDistribution().toString();
            if (StringUtil.endsWith((CharSequence)currentDistributionUri, (CharSequence)ALL_ZIP_DISTRIBUTION_URI_SUFFIX)) {
                return;
            }
            String distributionUri = currentDistributionUri.substring(0, currentDistributionUri.lastIndexOf(45)) + ALL_ZIP_DISTRIBUTION_URI_SUFFIX;
            wrapperConfiguration.setDistribution(new URI(distributionUri));
            Properties wrapperProperties = new Properties();
            wrapperProperties.setProperty("distributionUrl", wrapperConfiguration.getDistribution().toString());
            wrapperProperties.setProperty("distributionBase", wrapperConfiguration.getDistributionBase());
            wrapperProperties.setProperty("distributionPath", wrapperConfiguration.getDistributionPath());
            wrapperProperties.setProperty("zipStoreBase", wrapperConfiguration.getZipBase());
            wrapperProperties.setProperty("zipStorePath", wrapperConfiguration.getZipPath());
            GUtil.saveProperties((Properties)wrapperProperties, (File)new File(wrapperPropertiesFile.getPath()));
            LocalFileSystem.getInstance().refreshIoFiles(Collections.singletonList(wrapperPropertiesFile));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static boolean showUseDistributionWithSourcesTip(String linkedProjectPath) {
        WrapperConfiguration wrapperConfiguration = GradleUtil.getWrapperConfiguration((String)linkedProjectPath);
        if (wrapperConfiguration == null) {
            return true;
        }
        String distributionUri = wrapperConfiguration.getDistribution().toString();
        try {
            String host = new URI(distributionUri).getHost();
            return host != null && host.endsWith("gradle.org") && !GRADLE_SRC_DISTRIBUTION_PATTERN.matcher(distributionUri).matches();
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    @Nullable
    private static String getRootProjectPath(@NotNull Module module) {
        ExternalSystemModulePropertyManager modulePropertyManager;
        String externalSystemId;
        if (module == null) {
            UseDistributionWithSourcesNotificationProvider.$$$reportNull$$$0(5);
        }
        if ((externalSystemId = (modulePropertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module)).getExternalSystemId()) == null || !GradleConstants.SYSTEM_ID.toString().equals(externalSystemId)) {
            return null;
        }
        String path = modulePropertyManager.getRootProjectPath();
        return StringUtil.isEmpty((String)path) ? null : path;
    }

    static {
        LOG = Logger.getInstance(UseDistributionWithSourcesNotificationProvider.class);
        KEY = Key.create((String)"gradle.notifications.use.distribution.with.sources");
        GRADLE_SRC_DISTRIBUTION_PATTERN = Pattern.compile("https?\\\\?://services\\.gradle\\.org.*-all.zip");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/codeInsight/UseDistributionWithSourcesNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/codeInsight/UseDistributionWithSourcesNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateDefaultWrapperConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRootProjectPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

