/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.PropertyBundleEditorStructureViewElement;
import com.intellij.lang.properties.editor.PropertyStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleFileStructureViewElement
implements StructureViewTreeElement,
ResourceBundleEditorViewElement {
    @NotNull
    private final ResourceBundle myResourceBundle;
    @NotNull
    private final BooleanSupplier myGrouped;
    private volatile boolean myShowOnlyIncomplete;
    private final Map<String, PropertyStructureViewElement> myElements;

    public ResourceBundleFileStructureViewElement(@NotNull ResourceBundle resourceBundle, @NotNull BooleanSupplier grouped) {
        if (resourceBundle == null) {
            ResourceBundleFileStructureViewElement.$$$reportNull$$$0(0);
        }
        if (grouped == null) {
            ResourceBundleFileStructureViewElement.$$$reportNull$$$0(1);
        }
        this.myElements = new LinkedHashMap<String, PropertyStructureViewElement>();
        this.myResourceBundle = resourceBundle;
        this.myGrouped = grouped;
    }

    public void setShowOnlyIncomplete(boolean showOnlyIncomplete) {
        this.myShowOnlyIncomplete = showOnlyIncomplete;
    }

    public boolean isShowOnlyIncomplete() {
        return this.myShowOnlyIncomplete;
    }

    public ResourceBundle getValue() {
        return this.myResourceBundle.isValid() ? this.myResourceBundle : null;
    }

    public synchronized StructureViewTreeElement @NotNull [] getChildren() {
        MultiMap<String, IProperty> propertyNames = ResourceBundleFileStructureViewElement.getPropertiesMap(this.myResourceBundle, this.myShowOnlyIncomplete);
        HashSet<String> remains = new HashSet<String>(this.myElements.keySet());
        for (Map.Entry entry : propertyNames.entrySet()) {
            String propKey = (String)entry.getKey();
            Collection properties = (Collection)entry.getValue();
            PropertyStructureViewElement oldPropertyNode = this.myElements.get(propKey);
            if (oldPropertyNode != null && properties.contains(oldPropertyNode.getProperty())) {
                remains.remove(propKey);
                continue;
            }
            if (this.myElements.containsKey(propKey)) {
                remains.remove(propKey);
            }
            IProperty representative = (IProperty)properties.iterator().next();
            this.myElements.put(propKey, new PropertyBundleEditorStructureViewElement(representative, this.myGrouped));
        }
        for (String remain : remains) {
            this.myElements.remove(remain);
        }
        StructureViewTreeElement[] structureViewTreeElementArray = this.myElements.values().toArray(StructureViewTreeElement.EMPTY_ARRAY);
        if (structureViewTreeElementArray == null) {
            ResourceBundleFileStructureViewElement.$$$reportNull$$$0(2);
        }
        return structureViewTreeElementArray;
    }

    public static MultiMap<String, IProperty> getPropertiesMap(ResourceBundle resourceBundle, boolean onlyIncomplete) {
        MultiMap<String, IProperty> propertyNames;
        if (!resourceBundle.isValid()) {
            return MultiMap.EMPTY;
        }
        List propertiesFiles = resourceBundle.getPropertiesFiles();
        if (onlyIncomplete) {
            propertyNames = ResourceBundleFileStructureViewElement.getChildrenIdShowOnlyIncomplete(resourceBundle);
        } else {
            propertyNames = MultiMap.createLinked();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                List properties = propertiesFile.getProperties();
                for (IProperty property : properties) {
                    String name = property.getKey();
                    propertyNames.putValue((Object)name, (Object)property);
                }
            }
        }
        return propertyNames;
    }

    private static MultiMap<String, IProperty> getChildrenIdShowOnlyIncomplete(ResourceBundle resourceBundle) {
        final MultiMap propertyNames = MultiMap.createLinked();
        TObjectIntHashMap occurrences = new TObjectIntHashMap();
        for (PropertiesFile file : resourceBundle.getPropertiesFiles()) {
            MultiMap currentFilePropertyNames = MultiMap.createLinked();
            for (IProperty property : file.getProperties()) {
                String name = property.getKey();
                currentFilePropertyNames.putValue((Object)name, (Object)property);
            }
            propertyNames.putAllValues(currentFilePropertyNames);
            for (String propertyName : currentFilePropertyNames.keySet()) {
                if (occurrences.contains((Object)propertyName)) {
                    occurrences.adjustValue((Object)propertyName, 1);
                    continue;
                }
                occurrences.put((Object)propertyName, 1);
            }
        }
        final int targetOccurrences = resourceBundle.getPropertiesFiles().size();
        occurrences.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String propertyName, int occurrences) {
                if (occurrences == targetOccurrences) {
                    propertyNames.remove((Object)propertyName);
                }
                return true;
            }
        });
        return propertyNames;
    }

    @Nullable
    public IProperty[] getProperties() {
        return IProperty.EMPTY_ARRAY;
    }

    @Nullable
    public PsiFile[] getFiles() {
        ResourceBundle rb = this.getValue();
        if (rb == null) {
            return null;
        }
        List files = rb.getPropertiesFiles();
        return (PsiFile[])ContainerUtil.map2Array((Collection)files, (Object[])new PsiFile[files.size()], propertiesFile -> propertiesFile.getContainingFile());
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return ResourceBundleFileStructureViewElement.this.myResourceBundle.isValid() ? ResourceBundleFileStructureViewElement.this.myResourceBundle.getBaseName() : null;
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return AllIcons.FileTypes.Properties;
            }
        };
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouped";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/editor/ResourceBundleFileStructureViewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/editor/ResourceBundleFileStructureViewElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

