/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructuralSearchProfile {
    public static final ExtensionPointName<StructuralSearchProfile> EP_NAME = ExtensionPointName.create((String)"com.intellij.structuralsearch.profile");
    @NonNls
    protected static final String PATTERN_PLACEHOLDER = "$$PATTERN_PLACEHOLDER$$";

    public abstract void compile(PsiElement[] var1, @NotNull GlobalCompilingVisitor var2);

    @NotNull
    public abstract PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor var1);

    @NotNull
    public abstract NodeFilter getLexicalNodesFilter();

    @NotNull
    public abstract CompiledPattern createCompiledPattern();

    @NotNull
    public List<MatchPredicate> getCustomPredicates(MatchVariableConstraint constraint, String name, MatchOptions options) {
        List<MatchPredicate> list = Collections.emptyList();
        if (list == null) {
            StructuralSearchProfile.$$$reportNull$$$0(0);
        }
        return list;
    }

    public abstract boolean isMyLanguage(@NotNull Language var1);

    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull LanguageFileType fileType, @NotNull Language language, @Nullable String contextId, @NotNull Project project, boolean physical) {
        if (text == null) {
            StructuralSearchProfile.$$$reportNull$$$0(1);
        }
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(3);
        }
        if (language == null) {
            StructuralSearchProfile.$$$reportNull$$$0(4);
        }
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(5);
        }
        return this.doCreatePatternTree(text, context, fileType, language, project, physical, this.getContext(text, language, contextId));
    }

    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternContextInfo contextInfo, @NotNull LanguageFileType fileType, @NotNull Language language, @NotNull Project project, boolean physical) {
        String contextConstraint;
        if (text == null) {
            StructuralSearchProfile.$$$reportNull$$$0(6);
        }
        if (contextInfo == null) {
            StructuralSearchProfile.$$$reportNull$$$0(7);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(8);
        }
        if (language == null) {
            StructuralSearchProfile.$$$reportNull$$$0(9);
        }
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmpty((String)(contextConstraint = contextInfo.getContextConstraint()))) {
            PatternContext patternContext = contextInfo.getPatternContext();
            String contextId = patternContext != null ? patternContext.getId() : null;
            PsiElement[] psiElementArray = this.createPatternTree(text, contextInfo.getTreeContext(), fileType, language, contextId, project, physical);
            if (psiElementArray == null) {
                StructuralSearchProfile.$$$reportNull$$$0(11);
            }
            return psiElementArray;
        }
        return this.doCreatePatternTree(text, contextInfo.getTreeContext(), fileType, language, project, physical, this.getContextByConstraint(contextConstraint, project));
    }

    @NotNull
    private PsiElement[] doCreatePatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull LanguageFileType fileType, @NotNull Language language, @NotNull Project project, boolean physical, String strContext) {
        if (text == null) {
            StructuralSearchProfile.$$$reportNull$$$0(12);
        }
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(13);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(14);
        }
        if (language == null) {
            StructuralSearchProfile.$$$reportNull$$$0(15);
        }
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(16);
        }
        String placeholderName = this.getPlaceholderVarName();
        String patternInContext = context == PatternTreeContext.File ? text : strContext.replace(placeholderName, text);
        String name = "__dummy." + fileType.getDefaultExtension();
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(name, language, (CharSequence)patternInContext, physical, true);
        if (file == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                StructuralSearchProfile.$$$reportNull$$$0(17);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (context == PatternTreeContext.File) {
            PsiElement[] psiElementArray = new PsiElement[]{file};
            if (psiElementArray == null) {
                StructuralSearchProfile.$$$reportNull$$$0(18);
            }
            return psiElementArray;
        }
        int offset = strContext.indexOf(placeholderName);
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                StructuralSearchProfile.$$$reportNull$$$0(19);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement topElement = element;
        int patternLength = text.length();
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (element.getTextRange().getStartOffset() != offset || element.getTextLength() > patternLength) continue;
            topElement = element;
        }
        if (topElement instanceof PsiFile) {
            PsiElement[] psiElementArray = topElement.getChildren();
            if (psiElementArray == null) {
                StructuralSearchProfile.$$$reportNull$$$0(20);
            }
            return psiElementArray;
        }
        SmartList result = new SmartList();
        result.add(topElement);
        int endOffset = offset + patternLength;
        for (topElement = topElement.getNextSibling(); topElement != null && topElement.getTextRange().getEndOffset() <= endOffset; topElement = topElement.getNextSibling()) {
            result.add(topElement);
        }
        PsiElement[] psiElementArray = result.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            StructuralSearchProfile.$$$reportNull$$$0(21);
        }
        return psiElementArray;
    }

    @NotNull
    public List<PatternContext> getPatternContexts() {
        List<PatternContext> list = Collections.emptyList();
        if (list == null) {
            StructuralSearchProfile.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    protected String getPlaceholderVarName() {
        return PATTERN_PLACEHOLDER;
    }

    @NotNull
    protected String getContext(@NotNull String pattern, @Nullable Language language, @Nullable String contextId) {
        if (pattern == null) {
            StructuralSearchProfile.$$$reportNull$$$0(23);
        }
        String string = this.getPlaceholderVarName();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private String getContextByConstraint(@NotNull String contextConstraint, @NotNull Project project) {
        Configuration configuration;
        if (contextConstraint == null) {
            StructuralSearchProfile.$$$reportNull$$$0(25);
        }
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(26);
        }
        String string = (configuration = ConfigurationManager.getInstance(project).findConfigurationByName(contextConstraint)) != null ? configuration.getMatchOptions().getSearchPattern() : this.getPlaceholderVarName();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Nullable
    public PsiCodeFragment createCodeFragment(Project project, String text, String contextId) {
        return null;
    }

    public String getCodeFragmentText(PsiFile fragment) {
        return fragment.getText();
    }

    @NotNull
    public abstract Class<? extends TemplateContextType> getTemplateContextTypeClass();

    @Nullable
    public LanguageFileType detectFileType(@NotNull PsiElement context) {
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(28);
        }
        return null;
    }

    @Nullable
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project, @NotNull ReplaceOptions replaceOptions) {
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(29);
        }
        if (replaceOptions == null) {
            StructuralSearchProfile.$$$reportNull$$$0(30);
        }
        return null;
    }

    public void checkSearchPattern(CompiledPattern pattern) {
    }

    public void checkReplacementPattern(Project project, ReplaceOptions options) {
        String fileType = StringUtil.toLowerCase((String)options.getMatchOptions().getFileType().getName());
        throw new UnsupportedPatternException(SSRBundle.message("replacement.not.supported.for.filetype", fileType));
    }

    public boolean shouldShowProblem(PsiErrorElement error) {
        return false;
    }

    public boolean canBeVarDelimiter(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchProfile.$$$reportNull$$$0(31);
        }
        return false;
    }

    public String getText(PsiElement match, int start, int end) {
        String matchText = match.getText();
        if (start == 0 && end == -1) {
            return matchText;
        }
        return matchText.substring(start, end == -1 ? matchText.length() : end);
    }

    @NotNull
    public String getTypedVarString(PsiElement element) {
        String name;
        if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
            String string = name;
            if (string == null) {
                StructuralSearchProfile.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(33);
        }
        return string;
    }

    public String getMeaningfulText(PsiElement element) {
        return this.getTypedVarString(element);
    }

    public String getAlternativeText(PsiElement element, String previousText) {
        return null;
    }

    public PsiElement updateCurrentNode(PsiElement node) {
        return node;
    }

    public PsiElement extendMatchedByDownUp(PsiElement node) {
        return node;
    }

    public PsiElement extendMatchOnePsiFile(PsiElement file) {
        return file;
    }

    public LanguageFileType getDefaultFileType(@Nullable LanguageFileType fileType) {
        return fileType;
    }

    public Configuration[] getPredefinedTemplates() {
        return Configuration.EMPTY_ARRAY;
    }

    public void provideAdditionalReplaceOptions(@NotNull PsiElement node, ReplaceOptions options, ReplacementBuilder builder) {
        if (node == null) {
            StructuralSearchProfile.$$$reportNull$$$0(34);
        }
    }

    public void handleSubstitution(ParameterInfo info, MatchResult match, StringBuilder result, ReplacementInfo replacementInfo) {
        if (info.getName().equals(match.getName())) {
            String replacementString;
            boolean removeSemicolon = false;
            if (match.hasChildren() && !match.isScopeMatch()) {
                StringBuilder buf = new StringBuilder();
                for (MatchResult matchResult : match.getChildren()) {
                    PsiElement currentElement = matchResult.getMatch();
                    if (buf.length() > 0) {
                        if (info.isArgumentContext()) {
                            buf.append(',');
                        } else {
                            PsiElement sibling = currentElement.getPrevSibling();
                            buf.append(sibling instanceof PsiWhiteSpace ? sibling.getText() : " ");
                        }
                    }
                    buf.append(matchResult.getMatchImage());
                    removeSemicolon = currentElement instanceof PsiComment;
                }
                replacementString = buf.toString();
            } else {
                if (info.isStatementContext()) {
                    removeSemicolon = match.getMatch() instanceof PsiComment;
                }
                replacementString = match.getMatchImage();
            }
            int offset = Replacer.insertSubstitution(result, 0, info, replacementString);
            if (info.isStatementContext() && (removeSemicolon || StringUtil.endsWithChar((CharSequence)replacementString, (char)';') || StringUtil.endsWithChar((CharSequence)replacementString, (char)'}'))) {
                int start = info.getStartIndex() + offset;
                result.delete(start, start + 1);
            }
        }
    }

    public void handleNoSubstitution(ParameterInfo info, StringBuilder result) {
        if (info.isHasCommaBefore()) {
            result.delete(info.getBeforeDelimiterPos(), info.getBeforeDelimiterPos() + 1);
        } else if (info.isHasCommaAfter()) {
            result.delete(info.getAfterDelimiterPos(), info.getAfterDelimiterPos() + 1);
        }
    }

    @Contract(value="null -> false")
    public boolean isIdentifier(@Nullable PsiElement element) {
        return false;
    }

    @NotNull
    public Collection<String> getReservedWords() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            StructuralSearchProfile.$$$reportNull$$$0(35);
        }
        return set;
    }

    public boolean isDocCommentOwner(PsiElement match) {
        return false;
    }

    @Contract(value="!null -> !null")
    public PsiElement getPresentableElement(PsiElement element) {
        return this.isIdentifier(element) ? element.getParent() : element;
    }

    public boolean isApplicableConstraint(String constraintName, @Nullable PsiElement variableNode, boolean completePattern, boolean target) {
        switch (constraintName) {
            case "MINIMUM ZERO": {
                if (target) {
                    return false;
                }
            }
            case "MAXIMUM UNLIMITED": 
            case "TEXT": 
            case "REFERENCE": {
                return !completePattern;
            }
        }
        return false;
    }

    public final boolean isApplicableConstraint(String constraintName, List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        if (nodes.isEmpty()) {
            return this.isApplicableConstraint(constraintName, (PsiElement)null, completePattern, target);
        }
        boolean result = true;
        for (PsiElement psiElement : nodes) {
            result &= this.isApplicableConstraint(constraintName, psiElement, completePattern, target);
        }
        return result;
    }

    public boolean isApplicableContextConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            StructuralSearchProfile.$$$reportNull$$$0(36);
        }
        return !configuration.isPredefined();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 36: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 36: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchProfile";
                break;
            }
            case 1: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 13: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 10: 
            case 16: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextInfo";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextConstraint";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomPredicates";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreatePatternTree";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternContexts";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextByConstraint";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedWords";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doCreatePatternTree";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getContextByConstraint";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "canBeVarDelimiter";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "provideAdditionalReplaceOptions";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableContextConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 36: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

