/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;

public class MatcherImplUtil {
    public static PsiElement[] createTreeFromText(String text, PatternTreeContext context, LanguageFileType fileType, Project project) {
        return MatcherImplUtil.createTreeFromText(text, new PatternContextInfo(context), fileType, null, project, false);
    }

    public static PsiElement[] createSourceTreeFromText(String text, PatternTreeContext context, LanguageFileType fileType, Project project, boolean physical) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByLanguage(fileType.getLanguage());
        if (profile != null) {
            return profile.createPatternTree(text, context, fileType, fileType.getLanguage(), null, project, physical);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static PsiElement[] createTreeFromText(String text, PatternContextInfo contextInfo, LanguageFileType fileType, Language language, Project project, boolean physical) {
        StructuralSearchProfile profile;
        if (language == null) {
            language = fileType.getLanguage();
        }
        if ((profile = StructuralSearchUtil.getProfileByLanguage(language)) != null) {
            return profile.createPatternTree(text, contextInfo, fileType, language, project, physical);
        }
        return PsiElement.EMPTY_ARRAY;
    }
}

