/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LiteralWithSubstitutionHandler
extends MatchingHandler {
    private final String myRegexp;
    private Matcher myMatcher;
    private final List<? extends SubstitutionHandler> myHandlers;
    private final boolean myCaseSensitive;

    public LiteralWithSubstitutionHandler(String regexp, List<? extends SubstitutionHandler> handlers, boolean caseSensitive) {
        this.myRegexp = regexp;
        this.myHandlers = handlers;
        this.myCaseSensitive = caseSensitive;
    }

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
        String text = matchedNode.getText();
        if (this.myMatcher == null) {
            this.myMatcher = Pattern.compile(this.myRegexp, this.myCaseSensitive ? 0 : 2).matcher(text);
        } else {
            this.myMatcher.reset(text);
        }
        if (!this.myMatcher.matches()) {
            return false;
        }
        for (int i = 0; i < this.myHandlers.size(); ++i) {
            SubstitutionHandler handler = this.myHandlers.get(i);
            if (handler.handle(matchedNode, this.myMatcher.start(i + 1), this.myMatcher.end(i + 1), context)) continue;
            return false;
        }
        return true;
    }
}

