/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection.highlightTemplate;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class SSBasedInspectionOptions {
    final JBList<Configuration> myTemplatesList;
    final List<Configuration> myConfigurations;

    SSBasedInspectionOptions(List<Configuration> configurations) {
        this.myConfigurations = configurations;
        this.myTemplatesList = new JBList((ListModel)new MyListModel());
        this.myTemplatesList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Configuration configuration = SSBasedInspectionOptions.this.myConfigurations.get(index);
                component.setText(configuration.getName());
                return component;
            }
        });
    }

    public void configurationsChanged(Project project) {
        ((MyListModel)this.myTemplatesList.getModel()).fireContentsChanged();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public JPanel getComponent() {
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add(new JLabel(SSRBundle.message("SSRInspection.selected.templates", new Object[0])));
        panel.add(ToolbarDecorator.createDecorator(this.myTemplatesList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AnAction[] children = new AnAction[]{new AddTemplateAction(false), new AddTemplateAction(true)};
                RelativePoint point = button.getPreferredPopupPoint();
                if (point == null) {
                    return;
                }
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(children), DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(point);
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)panel));
                if (project != null) {
                    SSBasedInspectionOptions.this.performEditAction(project);
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)panel));
                if (project == null) {
                    return;
                }
                for (Configuration configuration : SSBasedInspectionOptions.this.myTemplatesList.getSelectedValuesList()) {
                    SSBasedInspectionOptions.this.myConfigurations.remove(configuration);
                }
                SSBasedInspectionOptions.this.configurationsChanged(project);
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SSBasedInspectionOptions.this.performMoveUpDown(false);
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SSBasedInspectionOptions.this.performMoveUpDown(true);
            }
        }).setPreferredSize(new Dimension(-1, 100)).createPanel());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)panel));
                SSBasedInspectionOptions.this.performEditAction(project);
                return true;
            }
        }.installOn(this.myTemplatesList);
        return panel;
    }

    void performMoveUpDown(boolean down) {
        int i;
        int[] indices = this.myTemplatesList.getSelectedIndices();
        if (indices.length == 0) {
            return;
        }
        int delta = down ? 1 : -1;
        this.myTemplatesList.removeSelectionInterval(0, this.myConfigurations.size() - 1);
        int n = i = down ? indices.length - 1 : 0;
        while (down ? i >= 0 : i < indices.length) {
            int index = indices[i];
            Configuration temp = this.myConfigurations.get(index);
            this.myConfigurations.set(index, this.myConfigurations.get(index + delta));
            this.myConfigurations.set(index + delta, temp);
            this.myTemplatesList.addSelectionInterval(index + delta, index + delta);
            i -= delta;
        }
        int index = down ? this.myTemplatesList.getMaxSelectionIndex() : this.myTemplatesList.getMinSelectionIndex();
        Rectangle cellBounds = this.myTemplatesList.getCellBounds(index, index);
        if (cellBounds != null) {
            this.myTemplatesList.scrollRectToVisible(cellBounds);
        }
    }

    void performEditAction(Project project) {
        Configuration configuration = (Configuration)this.myTemplatesList.getSelectedValue();
        if (configuration == null) {
            return;
        }
        SearchContext searchContext = new SearchContext(project);
        StructuralSearchDialog dialog = new StructuralSearchDialog(searchContext, !(configuration instanceof SearchConfiguration), true);
        dialog.loadConfiguration(configuration);
        dialog.setUseLastConfiguration(true);
        if (!dialog.showAndGet()) {
            return;
        }
        Configuration newConfiguration = dialog.getConfiguration();
        int index = this.myConfigurations.indexOf(configuration);
        this.myConfigurations.set(index, newConfiguration);
        this.configurationsChanged(project);
    }

    private class AddTemplateAction
    extends AnAction {
        private final boolean myReplace;

        AddTemplateAction(boolean replace) {
            super(replace ? SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0]) : SSRBundle.message("SSRInspection.add.search.template.button", new Object[0]));
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SearchContext context;
            StructuralSearchDialog dialog;
            if (e == null) {
                AddTemplateAction.$$$reportNull$$$0(0);
            }
            if (!(dialog = new StructuralSearchDialog(context = new SearchContext(e.getDataContext()), this.myReplace, true)).showAndGet()) {
                return;
            }
            this.addTemplate(dialog.getConfiguration(), e.getProject());
        }

        void addTemplate(Configuration configuration, Project project) {
            if (!ConfigurationManager.showSaveTemplateAsDialog(SSBasedInspectionOptions.this.myConfigurations, configuration, project)) {
                return;
            }
            ((MyListModel)SSBasedInspectionOptions.this.myTemplatesList.getModel()).fireContentsChanged();
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspectionOptions$AddTemplateAction", "actionPerformed"));
        }
    }

    private class MyListModel
    extends AbstractListModel<Configuration> {
        private MyListModel() {
        }

        @Override
        public int getSize() {
            return SSBasedInspectionOptions.this.myConfigurations.size();
        }

        @Override
        public Configuration getElementAt(int index) {
            return index < SSBasedInspectionOptions.this.myConfigurations.size() ? SSBasedInspectionOptions.this.myConfigurations.get(index) : null;
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(SSBasedInspectionOptions.this.myTemplatesList, -1, -1);
        }
    }
}

