/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection.highlightTemplate;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.StructuralSearchProfileActionProvider;
import com.intellij.structuralsearch.inspection.highlightTemplate.SSBasedInspection;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationCellRenderer;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.SmartList;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchFakeInspection
extends LocalInspectionTool {
    @NotNull
    private Configuration myConfiguration;
    private final boolean myEnabled;
    private InspectionProfileImpl myProfile;

    public StructuralSearchFakeInspection(@NotNull Configuration configuration, boolean enabled) {
        if (configuration == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(0);
        }
        this.myProfile = null;
        this.myConfiguration = configuration;
        this.myEnabled = enabled;
    }

    public StructuralSearchFakeInspection(StructuralSearchFakeInspection copy) {
        this.myProfile = null;
        this.myConfiguration = copy.myConfiguration;
        this.myProfile = copy.myProfile;
        this.myEnabled = copy.myEnabled;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getDisplayName() {
        String string = this.myConfiguration.getName();
        if (string == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = this.myConfiguration.getUuid().toString();
        if (string == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return this.myEnabled;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        String suppressId = this.myConfiguration.getSuppressId();
        if (!StringUtil.isEmpty((String)suppressId)) {
            String string = suppressId;
            if (string == null) {
                StructuralSearchFakeInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "SSBasedInspection";
    }

    @Nullable
    public String getAlternativeID() {
        return "SSBasedInspection";
    }

    @Nullable
    public String getMainToolId() {
        return "SSBasedInspection";
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getGroupDisplayName() {
        String string = SSRBundle.message("structural.search.group.name", new Object[0]);
        if (string == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String getStaticDescription() {
        String description = this.myConfiguration.getDescription();
        if (StringUtil.isEmpty((String)description)) {
            return SSRBundle.message("no.description.message", new Object[0]);
        }
        return description;
    }

    public void setProfile(InspectionProfileImpl profile) {
        this.myProfile = profile;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JButton button = new JButton(SSRBundle.message("edit.metadata.button", new Object[0]));
        button.addActionListener(e -> {
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)button));
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
            if (StructuralSearchProfileActionProvider.saveInspection(project, this.getStructuralSearchInspection(), this.myConfiguration)) {
                this.myProfile.getProfileManager().fireProfileChanged(this.myProfile);
            }
        });
        JBList list = new JBList((ListModel)new MyListModel());
        list.setCellRenderer(new ConfigurationCellRenderer());
        JPanel listPanel = ToolbarDecorator.createDecorator((JList)list).setAddAction(arg_0 -> this.lambda$createOptionsPanel$1((JList)list, arg_0)).setAddActionName(SSRBundle.message("add.pattern.action", new Object[0])).setRemoveAction(arg_0 -> this.lambda$createOptionsPanel$2((JList)list, arg_0)).setRemoveActionUpdater(arg_0 -> StructuralSearchFakeInspection.lambda$createOptionsPanel$3((JList)list, arg_0)).setEditAction(arg_0 -> this.lambda$createOptionsPanel$4((JList)list, arg_0)).setMoveUpAction(arg_0 -> StructuralSearchFakeInspection.lambda$createOptionsPanel$5((JList)list, arg_0)).setMoveDownAction(arg_0 -> StructuralSearchFakeInspection.lambda$createOptionsPanel$6((JList)list, arg_0)).createPanel();
        new DoubleClickListener((JList)list){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            protected boolean onDoubleClick(MouseEvent e) {
                StructuralSearchFakeInspection.this.performEdit(this.val$list);
                return true;
            }
        }.installOn((Component)list);
        JPanel panel = new FormBuilder().addComponent((JComponent)button).addLabeledComponentFillVertically(SSRBundle.message("templates.title", new Object[0]), (JComponent)listPanel).getPanel();
        panel.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        return panel;
    }

    private static void performMove(JList<Configuration> list, boolean up) {
        MyListModel model = (MyListModel)list.getModel();
        List<Configuration> values = list.getSelectedValuesList();
        Comparator<Configuration> c = Comparator.comparingInt(Configuration::getOrder);
        Collections.sort(values, up ? c : c.reversed());
        int[] indices = new int[values.size()];
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Configuration value = values.get(i);
            int order = value.getOrder();
            model.swap(order, order + (up ? -1 : 1));
            indices[i] = value.getOrder();
        }
        list.setSelectedIndices(indices);
        model.fireContentsChanged(list);
    }

    private void performAdd(JList<Configuration> list, AnActionButton b) {
        AnAction[] children = new AnAction[]{new AddTemplateAction(list, false), new AddTemplateAction(list, true)};
        RelativePoint point = b.getPreferredPopupPoint();
        if (point == null) {
            return;
        }
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(children), DataManager.getInstance().getDataContext((Component)b.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(point);
    }

    private void performRemove(JList<Configuration> list) {
        SSBasedInspection inspection = this.getStructuralSearchInspection();
        boolean metaData = false;
        for (Configuration configuration : list.getSelectedValuesList()) {
            if (configuration.getOrder() == 0) {
                metaData = true;
            }
            inspection.removeConfiguration(configuration);
        }
        MyListModel model = (MyListModel)list.getModel();
        model.clearCache();
        if (metaData) {
            Configuration first = model.getElementAt(0);
            first.setDescription(this.myConfiguration.getDescription());
            first.setSuppressId(this.myConfiguration.getNewSuppressId());
            first.setProblemDescriptor(this.myConfiguration.getProblemDescriptor());
            this.myConfiguration = first;
        }
        int max = model.getSize();
        for (int i = 0; i < max; ++i) {
            model.getElementAt(i).setOrder(i);
        }
        model.fireContentsChanged(list);
    }

    private void performEdit(JList<Configuration> list) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(list));
        if (project == null) {
            return;
        }
        Configuration configuration = list.getSelectedValue();
        if (configuration == null) {
            return;
        }
        SearchContext searchContext = new SearchContext(project);
        StructuralSearchDialog dialog = new StructuralSearchDialog(searchContext, !(configuration instanceof SearchConfiguration), true);
        dialog.loadConfiguration(configuration);
        dialog.setUseLastConfiguration(true);
        if (!dialog.showAndGet()) {
            return;
        }
        Configuration newConfiguration = dialog.getConfiguration();
        SSBasedInspection inspection = this.getStructuralSearchInspection();
        if (configuration.getOrder() == 0) {
            this.myConfiguration = newConfiguration;
        }
        inspection.removeConfiguration(configuration);
        inspection.addConfiguration(newConfiguration);
        MyListModel model = (MyListModel)list.getModel();
        model.clearCache();
        model.fireContentsChanged(list);
    }

    private SSBasedInspection getStructuralSearchInspection() {
        InspectionToolWrapper wrapper = this.myProfile.getInspectionTool("SSBasedInspection", (Project)null);
        assert (wrapper != null);
        return (SSBasedInspection)wrapper.getTool();
    }

    private static /* synthetic */ void lambda$createOptionsPanel$6(JList list, AnActionButton b) {
        StructuralSearchFakeInspection.performMove(list, false);
    }

    private static /* synthetic */ void lambda$createOptionsPanel$5(JList list, AnActionButton b) {
        StructuralSearchFakeInspection.performMove(list, true);
    }

    private /* synthetic */ void lambda$createOptionsPanel$4(JList list, AnActionButton b) {
        this.performEdit(list);
    }

    private static /* synthetic */ boolean lambda$createOptionsPanel$3(JList list, AnActionEvent e) {
        return list.getSelectedValuesList().size() < list.getModel().getSize();
    }

    private /* synthetic */ void lambda$createOptionsPanel$2(JList list, AnActionButton b) {
        this.performRemove(list);
    }

    private /* synthetic */ void lambda$createOptionsPanel$1(JList list, AnActionButton b) {
        this.performAdd(list, b);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/inspection/highlightTemplate/StructuralSearchFakeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/inspection/highlightTemplate/StructuralSearchFakeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyListModel
    extends AbstractListModel<Configuration> {
        private final List<Configuration> cache = new SmartList();

        private MyListModel() {
        }

        @Override
        public int getSize() {
            this.initialize();
            return this.cache.size();
        }

        @Override
        public Configuration getElementAt(int index) {
            this.initialize();
            return this.cache.get(index);
        }

        public void fireContentsChanged(Object source) {
            this.fireContentsChanged(source, -1, -1);
        }

        public void clearCache() {
            this.cache.clear();
        }

        public void swap(int first, int second) {
            Configuration one = this.cache.get(first);
            Configuration two = this.cache.get(second);
            int order = one.getOrder();
            one.setOrder(two.getOrder());
            two.setOrder(order);
            this.cache.set(second, one);
            this.cache.set(first, two);
        }

        private void initialize() {
            if (!this.cache.isEmpty()) {
                return;
            }
            List<Configuration> configurations = StructuralSearchFakeInspection.this.getStructuralSearchInspection().getConfigurationsWithUuid(StructuralSearchFakeInspection.this.myConfiguration.getUuid());
            this.cache.addAll(configurations);
            Collections.sort(this.cache, Comparator.comparingInt(Configuration::getOrder));
        }
    }

    private class AddTemplateAction
    extends DumbAwareAction {
        private final JList<Configuration> myList;
        private final boolean myReplace;

        private AddTemplateAction(JList<Configuration> list, boolean replace) {
            super(replace ? SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0]) : SSRBundle.message("SSRInspection.add.search.template.button", new Object[0]));
            this.myList = list;
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddTemplateAction.$$$reportNull$$$0(0);
            }
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            assert (project != null);
            SearchContext context = new SearchContext(project);
            StructuralSearchDialog dialog = new StructuralSearchDialog(context, this.myReplace, true);
            if (!dialog.showAndGet()) {
                return;
            }
            Configuration configuration = dialog.getConfiguration();
            configuration.setUuid(StructuralSearchFakeInspection.this.myConfiguration.getUuid());
            configuration.setName(StructuralSearchFakeInspection.this.myConfiguration.getName());
            MyListModel model = (MyListModel)this.myList.getModel();
            configuration.setOrder(model.getSize());
            StructuralSearchFakeInspection.this.getStructuralSearchInspection().addConfiguration(configuration);
            model.clearCache();
            model.fireContentsChanged(this.myList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/inspection/highlightTemplate/StructuralSearchFakeInspection$AddTemplateAction", "actionPerformed"));
        }
    }
}

