/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplacementPreviewDialog;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UsageViewContext;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class ReplaceUsageViewContext
extends UsageViewContext {
    private final HashMap<Usage, ReplacementInfo> usage2ReplacementInfo = new HashMap();
    private final Replacer replacer = new Replacer(this.mySearchContext.getProject(), this.myConfiguration.getReplaceOptions());

    ReplaceUsageViewContext(SearchContext context, Configuration configuration, Runnable searchStarter) {
        super(configuration, context, searchStarter);
    }

    public void addReplaceUsage(Usage usage, MatchResult result) {
        this.usage2ReplacementInfo.put(usage, this.replacer.buildReplacement(result));
    }

    private static boolean isValid(UsageInfo2UsageAdapter info) {
        PsiElement element = info.getUsageInfo().getElement();
        return element != null && element.isValid();
    }

    @Override
    protected void configureActions() {
        super.configureActions();
        this.myUsageView.addButtonToLowerPane(() -> this.replace(this.myUsageView.getSortedUsages()), SSRBundle.message("do.replace.all.button", new Object[0]));
        this.myUsageView.addButtonToLowerPane(() -> this.replace(this.myUsageView.getSelectedUsages()), SSRBundle.message("replace.selected.button", new Object[0]));
        Runnable previewReplacement = () -> {
            Set selection = this.myUsageView.getSelectedUsages();
            if (selection.isEmpty()) {
                return;
            }
            for (Usage usage : selection) {
                UsageInfo2UsageAdapter info = (UsageInfo2UsageAdapter)usage;
                if (!ReplaceUsageViewContext.isValid(info) || this.myUsageView.getExcludedUsages().contains(usage)) continue;
                ReplacementInfo replacementInfo = this.usage2ReplacementInfo.get(usage);
                ReplacementPreviewDialog previewDialog = new ReplacementPreviewDialog(this.mySearchContext.getProject(), info.getUsageInfo(), replacementInfo.getReplacement());
                if (!previewDialog.showAndGet()) {
                    return;
                }
                this.replace(Collections.singleton(info));
            }
        };
        this.myUsageView.addButtonToLowerPane(previewReplacement, SSRBundle.message("preview.replacement.button", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace(@NotNull Collection<Usage> usages) {
        if (usages == null) {
            ReplaceUsageViewContext.$$$reportNull$$$0(0);
        }
        Set excluded = this.myUsageView.getExcludedUsages();
        usages = usages.stream().filter(u -> !excluded.contains(u)).filter(u -> ReplaceUsageViewContext.isValid((UsageInfo2UsageAdapter)u)).collect(Collectors.toList());
        List files = ContainerUtil.map((Collection)usages, i -> ((UsageInFile)i).getFile());
        if (ReadonlyStatusHandler.getInstance((Project)this.mySearchContext.getProject()).ensureFilesWritable((Collection)files).hasReadonlyFiles()) {
            return;
        }
        this.removeUsagesAndSelectNext(usages, excluded);
        List replacementInfos = ContainerUtil.map((Collection)usages, this.usage2ReplacementInfo::get);
        LocalHistoryAction action = LocalHistory.getInstance().startAction(SSRBundle.message("structural.replace.title", new Object[0]));
        try {
            CommandProcessor.getInstance().executeCommand(this.mySearchContext.getProject(), () -> this.replacer.replaceAll(replacementInfos), SSRBundle.message("structural.replace.title", new Object[0]), null);
        }
        finally {
            action.finish();
        }
    }

    private void removeUsagesAndSelectNext(Collection<Usage> usages, Collection<Usage> excluded) {
        List sortedUsages = this.myUsageView.getSortedUsages();
        if (sortedUsages.size() == usages.size()) {
            this.myUsageView.close();
        } else {
            Usage firstValid = null;
            Usage select = null;
            for (Usage usage : sortedUsages) {
                if (usages.contains(usage)) {
                    select = null;
                    continue;
                }
                if (excluded.contains(usage) || !ReplaceUsageViewContext.isValid((UsageInfo2UsageAdapter)usage)) continue;
                if (select == null) {
                    select = usage;
                }
                if (firstValid != null) continue;
                firstValid = usage;
            }
            this.myUsageView.removeUsagesBulk(usages);
            this.myUsageView.selectUsages(new Usage[]{(Usage)ObjectUtils.coalesce(select, firstValid, this.myUsageView.getSortedUsages().get(0))});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/structuralsearch/plugin/replace/ui/ReplaceUsageViewContext", "replace"));
    }
}

