/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.find.FindBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.Scopes;
import com.intellij.structuralsearch.plugin.ui.DirectoryComboBoxWithButtons;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopePanel
extends JPanel {
    private static final Condition<ScopeDescriptor> SCOPE_FILTER = descriptor -> IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(descriptor.getDisplayName()) || !(descriptor.getScope() instanceof ModuleWithDependenciesScope);
    private final Project myProject;
    @NotNull
    private SearchScope myScope;
    private NullableConsumer<? super SearchScope> myConsumer;
    Scopes.Type myScopeType;
    private boolean myUpdating;
    final ActionToolbarImpl myToolbar;
    final JPanel myScopeDetailsPanel;
    private final ModulesComboBox myModulesComboBox;
    private final DirectoryComboBoxWithButtons myDirectoryComboBox;
    private final ScopeChooserCombo myScopesComboBox;

    public ScopePanel(@NotNull Project project, Disposable parent) {
        if (project == null) {
            ScopePanel.$$$reportNull$$$0(0);
        }
        super(null);
        this.myUpdating = false;
        this.myScopeDetailsPanel = new JPanel(new CardLayout());
        this.myModulesComboBox = new ModulesComboBox();
        this.myScopesComboBox = new ScopeChooserCombo();
        this.myProject = project;
        this.myScope = GlobalSearchScope.projectScope((Project)this.myProject);
        Module[] allModules = ModuleManager.getInstance((Project)project).getModules();
        this.myModulesComboBox.setModules(Arrays.asList(allModules));
        if (allModules.length > 0) {
            this.myModulesComboBox.setSelectedModule(allModules[0]);
        }
        this.myModulesComboBox.addItemListener(e -> this.setScopeFromUI(Scopes.Type.MODULE, false));
        this.myModulesComboBox.setMinimumAndPreferredWidth(JBUIScale.scale((int)300));
        this.myScopesComboBox.init(project, true, false, (Object)"", SCOPE_FILTER);
        this.myScopesComboBox.getComboBox().addItemListener(e -> this.setScopeFromUI(Scopes.Type.NAMED, false));
        Disposer.register((Disposable)parent, (Disposable)this.myScopesComboBox);
        this.myDirectoryComboBox = new DirectoryComboBoxWithButtons(this.myProject);
        this.myDirectoryComboBox.setCallback(() -> this.setScopeFromUI(Scopes.Type.DIRECTORY, false));
        this.myScopeDetailsPanel.add(Scopes.Type.PROJECT.toString(), new JLabel());
        this.myScopeDetailsPanel.add(Scopes.Type.MODULE.toString(), ScopePanel.shrinkWrap((JComponent)this.myModulesComboBox));
        this.myScopeDetailsPanel.add(Scopes.Type.DIRECTORY.toString(), this.myDirectoryComboBox);
        this.myScopeDetailsPanel.add(Scopes.Type.NAMED.toString(), ScopePanel.shrinkWrap((JComponent)this.myScopesComboBox));
        this.myScopeDetailsPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)(UIUtil.isUnderDefaultMacTheme() ? 0 : 3)));
        boolean fullVersion = !PlatformUtils.isDataGrip();
        DefaultActionGroup scopeActionGroup = fullVersion ? new DefaultActionGroup(new AnAction[]{new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.project", (Object[])new Object[0]), Scopes.Type.PROJECT), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.module", (Object[])new Object[0]), Scopes.Type.MODULE), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.directory", (Object[])new Object[0]), Scopes.Type.DIRECTORY), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.scope", (Object[])new Object[0]), Scopes.Type.NAMED)}) : new DefaultActionGroup(new AnAction[]{new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.scope", (Object[])new Object[0]), Scopes.Type.NAMED), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.directory", (Object[])new Object[0]), Scopes.Type.DIRECTORY)});
        this.myToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("ScopePanel", (ActionGroup)scopeActionGroup, true);
        this.myToolbar.setForceMinimumSize(true);
        this.myToolbar.setLayoutPolicy(0);
        this.setScope(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent((Component)this.myToolbar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, 25).addComponent(this.myScopeDetailsPanel));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent((Component)this.myToolbar).addComponent(this.myScopeDetailsPanel));
    }

    private static JComponent shrinkWrap(JComponent component) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)component, "West");
        wrapper.add(Box.createHorizontalGlue(), "Center");
        return wrapper;
    }

    public void setRecentDirectories(@NotNull List<String> recentDirectories) {
        if (recentDirectories == null) {
            ScopePanel.$$$reportNull$$$0(1);
        }
        this.myDirectoryComboBox.setRecentDirectories(recentDirectories);
    }

    public void setScope(@Nullable SearchScope selectedScope) {
        if (selectedScope instanceof LocalSearchScope && selectedScope.getDisplayName().startsWith("Hierarchy of ")) {
            selectedScope = null;
        }
        if (selectedScope != null) {
            this.myScope = selectedScope;
        }
        this.myScopeType = Scopes.getType(this.myScope);
        if (selectedScope instanceof ModuleWithDependenciesScope) {
            ModuleWithDependenciesScope scope = (ModuleWithDependenciesScope)selectedScope;
            this.myModulesComboBox.setSelectedModule(scope.getModule());
        } else if (selectedScope instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)selectedScope;
            VirtualFile directory = directoryScope.getDirectory();
            this.myDirectoryComboBox.setDirectory(directory);
            this.myDirectoryComboBox.setRecursive(directoryScope.isWithSubdirectories());
        } else if (selectedScope != null && selectedScope != GlobalSearchScope.projectScope((Project)this.myProject)) {
            this.myScopesComboBox.selectItem((Object)selectedScope.getDisplayName());
            SearchScope scope = this.myScopesComboBox.getSelectedScope();
            this.myScope = scope == null ? GlobalSearchScope.projectScope((Project)this.myProject) : scope;
        }
        this.myToolbar.updateActionsImmediately();
        ((CardLayout)this.myScopeDetailsPanel.getLayout()).show(this.myScopeDetailsPanel, this.myScopeType.toString());
    }

    public void setScopesFromContext() {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            this.myUpdating = true;
            try {
                Editor editor;
                Module module = (Module)LangDataKeys.MODULE.getData(context);
                if (module != null) {
                    this.myModulesComboBox.setSelectedModule(module);
                }
                if ((editor = (Editor)CommonDataKeys.HOST_EDITOR.getData(context)) != null) {
                    Document document = editor.getDocument();
                    VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                    if (file != null) {
                        this.myDirectoryComboBox.setDirectory(file.getParent());
                    }
                    this.myScopesComboBox.selectItem((Object)IdeBundle.message((String)"scope.current.file", (Object[])new Object[0]));
                } else {
                    VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
                    if (files != null && files.length > 0) {
                        boolean found = false;
                        for (VirtualFile file : files) {
                            if (!file.isDirectory()) continue;
                            this.myDirectoryComboBox.setDirectory(file);
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.myScopesComboBox.selectItem((Object)"Selected Files");
                            this.myDirectoryComboBox.setDirectory(files[0].getParent());
                        }
                    }
                }
            }
            finally {
                this.myUpdating = false;
            }
        });
    }

    public void setScopeConsumer(@Nullable NullableConsumer<? super SearchScope> consumer) {
        this.myConsumer = consumer;
    }

    @NotNull
    public SearchScope getScope() {
        SearchScope searchScope = this.myScope;
        if (searchScope == null) {
            ScopePanel.$$$reportNull$$$0(2);
        }
        return searchScope;
    }

    void setScopeFromUI(@NotNull Scopes.Type type, boolean requestFocus) {
        if (type == null) {
            ScopePanel.$$$reportNull$$$0(3);
        }
        if (this.myUpdating) {
            return;
        }
        switch (type) {
            case PROJECT: {
                this.myScope = GlobalSearchScope.projectScope((Project)this.myProject);
                break;
            }
            case MODULE: {
                Module module = this.myModulesComboBox.getSelectedModule();
                if (module == null) {
                    return;
                }
                this.myScope = GlobalSearchScope.moduleScope((Module)module);
                if (!requestFocus) break;
                this.myModulesComboBox.requestFocus();
                break;
            }
            case DIRECTORY: {
                VirtualFile directory = this.myDirectoryComboBox.getDirectory();
                if (directory == null) {
                    return;
                }
                this.myScope = GlobalSearchScopesCore.directoryScope((Project)this.myProject, (VirtualFile)directory, (boolean)this.myDirectoryComboBox.isRecursive());
                if (!requestFocus) break;
                this.myDirectoryComboBox.getComboBox().requestFocus();
                break;
            }
            case NAMED: {
                SearchScope scope = this.myScopesComboBox.getSelectedScope();
                Object object = this.myScope = scope == null ? GlobalSearchScope.projectScope((Project)this.myProject) : scope;
                if (!requestFocus) break;
                this.myScopesComboBox.requestFocus();
            }
        }
        if (this.myConsumer != null) {
            this.myConsumer.consume((Object)this.myScope);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentDirectories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ScopePanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ScopePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRecentDirectories";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setScopeFromUI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class ScopeToggleAction
    extends ToggleAction {
        private final Scopes.Type myScopeType;

        ScopeToggleAction(@NotNull String text, Scopes.Type scopeType) {
            if (text == null) {
                ScopeToggleAction.$$$reportNull$$$0(0);
            }
            if (scopeType == null) {
                ScopeToggleAction.$$$reportNull$$$0(1);
            }
            super(text, null, EmptyIcon.ICON_0);
            this.myScopeType = scopeType;
            this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ScopeToggleAction.$$$reportNull$$$0(2);
            }
            return this.myScopeType == ScopePanel.this.myScopeType;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ScopeToggleAction.$$$reportNull$$$0(3);
            }
            if (state) {
                ((CardLayout)ScopePanel.this.myScopeDetailsPanel.getLayout()).show(ScopePanel.this.myScopeDetailsPanel, this.myScopeType.toString());
                ScopePanel.this.myScopeType = this.myScopeType;
                ScopePanel.this.setScopeFromUI(this.myScopeType, true);
                ScopePanel.this.myToolbar.updateActionsImmediately();
            }
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ScopePanel$ScopeToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

