/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchHighlightInfoFilter
implements HighlightInfoFilter {
    private static final Key<List<PsiErrorElement>> ERRORS = new Key("STRUCTURAL_SEARCH_ERRORS");
    private static final Comparator<PsiErrorElement> ERROR_COMPARATOR = Comparator.comparingInt(PsiElement::getTextOffset).thenComparing(PsiErrorElement::getErrorDescription);

    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile file) {
        Runnable callback;
        if (highlightInfo == null) {
            StructuralSearchHighlightInfoFilter.$$$reportNull$$$0(0);
        }
        if (file == null) {
            return true;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return true;
        }
        String contextId = (String)document.getUserData(StructuralSearchDialog.STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID);
        if (contextId == null) {
            return true;
        }
        if (highlightInfo.getSeverity() != HighlightSeverity.ERROR) {
            return false;
        }
        if (!Registry.is((String)"ssr.in.editor.problem.highlighting")) {
            return false;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement((PsiElement)file);
        if (profile == null) {
            return true;
        }
        PsiErrorElement error = StructuralSearchHighlightInfoFilter.findErrorElementAt(file, highlightInfo.startOffset, highlightInfo.getDescription());
        if (error == null) {
            return false;
        }
        boolean result = profile.shouldShowProblem(error);
        if (result && (callback = (Runnable)document.getUserData(StructuralSearchDialog.STRUCTURAL_SEARCH_ERROR_CALLBACK)) != null) {
            ApplicationManager.getApplication().invokeLater(callback);
        }
        return result;
    }

    private static PsiErrorElement findErrorElementAt(PsiFile file, int offset, String description) {
        List errorList = (List)ERRORS.get((UserDataHolder)file, StructuralSearchHighlightInfoFilter.findErrors(file));
        for (PsiErrorElement element : errorList) {
            if (element.getTextOffset() != offset || !description.equals(element.getErrorDescription())) continue;
            return element;
        }
        return null;
    }

    private static List<PsiErrorElement> findErrors(PsiFile file) {
        Collection errors = PsiTreeUtil.findChildrenOfType((PsiElement)file, PsiErrorElement.class);
        ArrayList<PsiErrorElement> errorList = new ArrayList<PsiErrorElement>(errors);
        Collections.sort(errorList, ERROR_COMPARATOR);
        file.putUserData(ERRORS, errorList);
        return errorList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfo", "com/intellij/structuralsearch/plugin/ui/StructuralSearchHighlightInfoFilter", "accept"));
    }
}

