/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.StructuralSearchProfileActionProvider;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchUsageTarget;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;

public class UsageViewContext {
    protected final SearchContext mySearchContext;
    protected final Configuration myConfiguration;
    private final ConfigurableUsageTarget myTarget;
    protected UsageView myUsageView;

    protected UsageViewContext(Configuration configuration, SearchContext searchContext, Runnable searchStarter) {
        this.myConfiguration = configuration;
        this.mySearchContext = searchContext;
        this.myTarget = new StructuralSearchUsageTarget(configuration, searchContext, searchStarter);
    }

    public void setUsageView(UsageView usageView) {
        this.myUsageView = usageView;
    }

    public ConfigurableUsageTarget getTarget() {
        return this.myTarget;
    }

    public void configure(@NotNull UsageViewPresentation presentation) {
        if (presentation == null) {
            UsageViewContext.$$$reportNull$$$0(0);
        }
        String pattern = this.myConfiguration.getMatchOptions().getSearchPattern();
        SearchScope scope = this.myConfiguration.getMatchOptions().getScope();
        assert (scope != null);
        String scopeText = scope.getDisplayName();
        presentation.setScopeText(scopeText);
        String usagesString = SSRBundle.message("occurrences.of", pattern);
        presentation.setUsagesString(usagesString);
        presentation.setTabText(StringUtil.shortenTextWithEllipsis((String)usagesString, (int)60, (int)0, (boolean)false));
        presentation.setUsagesWord(SSRBundle.message("occurrence", new Object[0]));
        presentation.setCodeUsagesString(SSRBundle.message("found.occurrences", scopeText));
        presentation.setTargetsNodeText(SSRBundle.message("targets.node.text", new Object[0]));
        presentation.setCodeUsages(false);
        presentation.setUsageTypeFilteringAvailable(true);
    }

    protected void configureActions() {
        if (Registry.is((String)"ssr.separate.inspections")) {
            this.myUsageView.addButtonToLowerPane((Action)new AbstractAction(SSRBundle.message("create.inspection.from.template.action.text", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Project project = UsageViewContext.this.mySearchContext.getProject();
                    InspectionProfileImpl inspectionProfile = InspectionProfileManager.getInstance((Project)project).getCurrentProfile();
                    StructuralSearchProfileActionProvider.createNewInspection(UsageViewContext.this.myConfiguration, inspectionProfile, project);
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/structuralsearch/plugin/ui/UsageViewContext", "configure"));
    }
}

