/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.fields.IntegerField;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class CountFilter
extends FilterAction {
    boolean myMinZero;
    boolean myMaxUnlimited;

    public CountFilter(FilterTable filterTable) {
        super(SSRBundle.messagePointer("count.filter.name", new Object[0]), filterTable);
    }

    @Override
    public boolean hasFilter() {
        NamedScriptableDefinition variable = this.myTable.getVariable();
        if (!(variable instanceof MatchVariableConstraint)) {
            return false;
        }
        MatchVariableConstraint matchVariableConstraint = (MatchVariableConstraint)variable;
        return matchVariableConstraint.getMinCount() != 1 || matchVariableConstraint.getMaxCount() != 1;
    }

    @Override
    public void clearFilter() {
        NamedScriptableDefinition variable = this.myTable.getVariable();
        if (!(variable instanceof MatchVariableConstraint)) {
            return;
        }
        MatchVariableConstraint constraint = (MatchVariableConstraint)variable;
        constraint.setMinCount(1);
        constraint.setMaxCount(1);
    }

    @Override
    public void initFilter() {
        MatchVariableConstraint constraint = (MatchVariableConstraint)this.myTable.getVariable();
        constraint.setMinCount(this.myMinZero ? 0 : 1);
        constraint.setMaxCount(this.myMaxUnlimited ? Integer.MAX_VALUE : 1);
    }

    @Override
    public boolean isApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        if (!(this.myTable.getVariable() instanceof MatchVariableConstraint)) {
            return false;
        }
        StructuralSearchProfile profile = this.myTable.getProfile();
        this.myMinZero = profile.isApplicableConstraint("MINIMUM ZERO", nodes, completePattern, false);
        this.myMaxUnlimited = profile.isApplicableConstraint("MAXIMUM UNLIMITED", nodes, completePattern, false);
        return this.myMinZero || this.myMaxUnlimited;
    }

    @Override
    protected void setLabel(SimpleColoredComponent component) {
        MatchVariableConstraint constraint = (MatchVariableConstraint)this.myTable.getVariable();
        int min = constraint.getMinCount();
        int max = constraint.getMaxCount();
        this.myLabel.append(SSRBundle.message("count.label", "[" + min + "," + (max == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(max)) + ']'));
    }

    @Override
    public FilterEditor getEditor() {
        return new FilterEditor<MatchVariableConstraint>(this.myTable.getVariable(), this.myTable.getConstraintChangedCallback()){
            private final IntegerField myMinField;
            private final IntegerField myMaxField;
            private final JLabel myMinLabel;
            private final JLabel myMaxLabel;
            {
                this.myMinField = new IntegerField();
                this.myMaxField = new IntegerField();
                this.myMinLabel = new JLabel(SSRBundle.message("min.label", new Object[0]));
                this.myMaxLabel = new JLabel(SSRBundle.message("max.label", new Object[0]));
            }

            @Override
            protected void layoutComponents() {
                GroupLayout layout = new GroupLayout((Container)((Object)this));
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.myMinLabel).addComponent((Component)this.myMinField).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, 20).addComponent(this.myMaxLabel).addComponent((Component)this.myMaxField));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myMinLabel).addComponent((Component)this.myMinField).addComponent(this.myMaxLabel).addComponent((Component)this.myMaxField));
                this.myMinField.getValueEditor().addListener(newValue -> {
                    if (this.myMinField.getValueEditor().isValid(newValue) && this.myMaxField.getValue() < newValue) {
                        this.myMaxField.setValue(newValue);
                    }
                });
                this.myMaxField.getValueEditor().addListener(newValue -> {
                    if (this.myMaxField.getValueEditor().isValid(newValue) && this.myMinField.getValue() > newValue) {
                        this.myMinField.setValue(newValue);
                    }
                });
            }

            @Override
            protected void loadValues() {
                this.myMinField.setMinValue(CountFilter.this.myMinZero ? 0 : 1);
                this.myMinField.setMaxValue(CountFilter.this.myMaxUnlimited ? Integer.MAX_VALUE : 1);
                this.myMinField.setDefaultValue(Integer.valueOf(CountFilter.this.myMinZero ? 0 : 1));
                this.myMinField.setDefaultValueText(CountFilter.this.myMinZero ? "0" : "1");
                int minCount = ((MatchVariableConstraint)this.myConstraint).getMinCount();
                if (!this.isDefaultValue(minCount)) {
                    this.myMinField.setValue(Integer.valueOf(minCount));
                }
                this.myMinField.setCanBeEmpty(true);
                this.myMinField.selectAll();
                this.myMaxField.setMinValue(CountFilter.this.myMinZero ? 0 : 1);
                this.myMaxField.setMaxValue(CountFilter.this.myMaxUnlimited ? Integer.MAX_VALUE : 1);
                this.myMaxField.setDefaultValue(Integer.valueOf(CountFilter.this.myMaxUnlimited ? Integer.MAX_VALUE : 1));
                this.myMaxField.setDefaultValueText(CountFilter.this.myMaxUnlimited ? SSRBundle.message("unlimited.placeholder", new Object[0]) : "1");
                int maxCount = ((MatchVariableConstraint)this.myConstraint).getMaxCount();
                if (!this.isDefaultValue(maxCount)) {
                    this.myMaxField.setValue(Integer.valueOf(maxCount));
                }
                this.myMaxField.setCanBeEmpty(true);
                this.myMaxField.selectAll();
            }

            private boolean isDefaultValue(int count) {
                if (count == 0) {
                    return CountFilter.this.myMinZero;
                }
                if (count == 1) {
                    return !CountFilter.this.myMinZero || !CountFilter.this.myMaxUnlimited;
                }
                if (count == Integer.MAX_VALUE) {
                    return CountFilter.this.myMaxUnlimited;
                }
                return false;
            }

            @Override
            public void saveValues() {
                ((MatchVariableConstraint)this.myConstraint).setMinCount(this.myMinField.getValue());
                ((MatchVariableConstraint)this.myConstraint).setMaxCount(this.myMaxField.getValue());
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myMinField;
            }

            public JComponent[] getFocusableComponents() {
                return new IntegerField[]{this.myMinField, this.myMaxField};
            }
        };
    }
}

