/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class VcsDataWrapper {
    private final Project myProject;
    private final ProjectLevelVcsManagerImpl myManager;
    private Map<String, String> myVcses;

    VcsDataWrapper(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (this.myProject == null || this.myProject.isDefault()) {
            this.myManager = null;
            this.myVcses = null;
            return;
        }
        this.myManager = ProjectLevelVcsManagerImpl.getInstanceImpl(this.myProject);
    }

    public boolean enabled() {
        if (this.myProject == null || this.myProject.isDefault() || this.myManager == null) {
            return false;
        }
        if (this.checkMappings()) {
            return false;
        }
        return this.myManager.haveVcses();
    }

    private boolean checkMappings() {
        List<VcsDirectoryMapping> mappings = this.myManager.getDirectoryMappings();
        for (VcsDirectoryMapping mapping : mappings) {
            String vcs = mapping.getVcs();
            if (vcs == null || vcs.length() <= 0) continue;
            return true;
        }
        return false;
    }

    public Project getProject() {
        return this.myProject;
    }

    public ProjectLevelVcsManager getManager() {
        return this.myManager;
    }

    public Map<String, String> getVcses() {
        if (this.myVcses == null && this.myProject != null && !this.myProject.isDefault()) {
            VcsDescriptor[] allVcss = this.myManager.getAllVcss();
            this.myVcses = new HashMap<String, String>(allVcss.length, 1.0f);
            for (VcsDescriptor vcs : allVcss) {
                this.myVcses.put(vcs.getDisplayName(), vcs.getName());
            }
        }
        return this.myVcses;
    }
}

