/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FilesProcessorWithNotificationImpl;
import com.intellij.openapi.vcs.ProjectConfigurationFilesProcessorImplKt;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsImplUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0002\u0010\u000eJ\b\u0010%\u001a\u00020\rH\u0016J\u0016\u0010&\u001a\u00020\r2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0*2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0*J\u0006\u0010+\u001a\u00020\rJ\u001a\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\f2\u0006\u0010/\u001a\u00020\fH\u0002J\b\u00100\u001a\u00020\bH\u0016J\b\u00101\u001a\u00020\bH\u0016J\b\u00102\u001a\u00020\rH\u0016J\u000e\u00103\u001a\u0004\u0018\u00010\f*\u00020\u0004H\u0002R \u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0014\u0010\u0019\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0011R\u0016\u0010!\u001a\n \u0016*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\u0004\u0018\u00010\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0011\u00a8\u00064"}, d2={"Lcom/intellij/openapi/vcs/ProjectConfigurationFilesProcessorImpl;", "Lcom/intellij/openapi/vcs/FilesProcessorWithNotificationImpl;", "Lcom/intellij/openapi/vcs/changes/ChangeListListener;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "vcsName", "", "addChosenFiles", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "askedBeforeProperty", "getAskedBeforeProperty", "()Ljava/lang/String;", "doForCurrentProjectProperty", "getDoForCurrentProjectProperty", "fileSystem", "Lcom/intellij/openapi/vfs/LocalFileSystem;", "kotlin.jvm.PlatformType", "forAllProjectsActionText", "getForAllProjectsActionText", "forCurrentProjectActionText", "getForCurrentProjectActionText", "foundProjectConfigurationFiles", "Ljava/util/concurrent/atomic/AtomicBoolean;", "muteActionText", "getMuteActionText", "showActionText", "getShowActionText", "vcsIgnoreManager", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManager;", "viewFilesDialogTitle", "getViewFilesDialogTitle", "changeListUpdateDone", "doActionOnChosenFiles", "files", "doFilterFiles", "filterNotProjectConfigurationFiles", "", "install", "isProjectConfigurationFile", "", "configDir", "file", "notificationMessage", "notificationTitle", "rememberForAllProjects", "getProjectConfigDir", "intellij.platform.vcs.impl"})
public final class ProjectConfigurationFilesProcessorImpl
extends FilesProcessorWithNotificationImpl
implements ChangeListListener {
    private final AtomicBoolean foundProjectConfigurationFiles;
    private final LocalFileSystem fileSystem;
    private final VcsIgnoreManager vcsIgnoreManager;
    @NotNull
    private final String askedBeforeProperty = "ASKED_SHARE_PROJECT_CONFIGURATION_FILES";
    @NotNull
    private final String doForCurrentProjectProperty = "SHARE_PROJECT_CONFIGURATION_FILES";
    @NotNull
    private final String showActionText;
    @NotNull
    private final String forCurrentProjectActionText;
    @Nullable
    private final String forAllProjectsActionText;
    @NotNull
    private final String muteActionText;
    @Nullable
    private final String viewFilesDialogTitle;
    private final Disposable parentDisposable;
    private final String vcsName;
    private final Function1<Collection<? extends VirtualFile>, Unit> addChosenFiles;

    public final void install() {
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
            final /* synthetic */ ProjectConfigurationFilesProcessorImpl this$0;
            {
                this.this$0 = projectConfigurationFilesProcessorImpl;
            }

            public final T compute() {
                boolean bl = false;
                if (!this.this$0.getProject().isDisposed()) {
                    this.this$0.getProject().getMessageBus().connect(ProjectConfigurationFilesProcessorImpl.access$getParentDisposable$p(this.this$0)).subscribe(ChangeListListener.TOPIC, (Object)this.this$0);
                }
                return (T)Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public final List<VirtualFile> filterNotProjectConfigurationFiles(@NotNull List<? extends VirtualFile> files) {
        Collection<VirtualFile> projectConfigurationFiles;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Collection<VirtualFile> collection = projectConfigurationFiles = this.doFilterFiles((Collection<? extends VirtualFile>)files);
        AtomicBoolean atomicBoolean = this.foundProjectConfigurationFiles;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        atomicBoolean.set(bl2);
        return CollectionsKt.minus((Iterable)files, (Iterable)projectConfigurationFiles);
    }

    public void changeListUpdateDone() {
        if (this.foundProjectConfigurationFiles.compareAndSet(true, false)) {
            Collection<VirtualFile> unversionedProjectConfigurationFiles;
            ChangeListManagerImpl changeListManagerImpl = ChangeListManagerImpl.getInstanceImpl(this.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)changeListManagerImpl, (String)"ChangeListManagerImpl.getInstanceImpl(project)");
            List<VirtualFile> list = changeListManagerImpl.getUnversionedFiles();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"ChangeListManagerImpl.ge\u2026project).unversionedFiles");
            Collection<VirtualFile> collection = unversionedProjectConfigurationFiles = this.doFilterFiles((Collection<? extends VirtualFile>)list);
            boolean bl = false;
            if (!collection.isEmpty()) {
                PropertiesComponent.getInstance((Project)this.getProject()).setValue("SHARE_PROJECT_CONFIGURATION_FILES", VcsImplUtil.isProjectSharedInVcs(this.getProject()));
                this.processFiles(CollectionsKt.toList((Iterable)unversionedProjectConfigurationFiles));
            }
        }
    }

    @Override
    @NotNull
    public Collection<VirtualFile> doFilterFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        VirtualFile projectConfigDir = this.getProjectConfigDir(this.getProject());
        return SequencesKt.toSet((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)files), (Function1)((Function1)new Function1<VirtualFile, Boolean>(this, projectConfigDir){
            final /* synthetic */ ProjectConfigurationFilesProcessorImpl this$0;
            final /* synthetic */ VirtualFile $projectConfigDir;

            public final boolean invoke(@NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return ProjectConfigurationFilesProcessorImplKt.access$getConfigurationFilesExtensionsOutsideStoreDirectory$p().contains(it.getExtension()) || ProjectConfigurationFilesProcessorImpl.access$isProjectConfigurationFile(this.this$0, this.$projectConfigDir, it);
            }
            {
                this.this$0 = projectConfigurationFilesProcessorImpl;
                this.$projectConfigDir = virtualFile;
                super(1);
            }
        })), (Function1)((Function1)new Function1<VirtualFile, Boolean>(this.vcsIgnoreManager){

            public final boolean invoke(@NotNull VirtualFile p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((VcsIgnoreManager)this.receiver).isPotentiallyIgnoredFile(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(VcsIgnoreManager.class);
            }

            public final String getName() {
                return "isPotentiallyIgnoredFile";
            }

            public final String getSignature() {
                return "isPotentiallyIgnoredFile(Lcom/intellij/openapi/vfs/VirtualFile;)Z";
            }
        })));
    }

    @Override
    public void doActionOnChosenFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        this.addChosenFiles.invoke(files);
    }

    @Override
    @NotNull
    public String getAskedBeforeProperty() {
        return this.askedBeforeProperty;
    }

    @Override
    @NotNull
    public String getDoForCurrentProjectProperty() {
        return this.doForCurrentProjectProperty;
    }

    @Override
    @NotNull
    public String notificationTitle() {
        return "";
    }

    @Override
    @NotNull
    public String notificationMessage() {
        String string = VcsBundle.message((String)"project.configuration.files.add.notification.message", (Object[])new Object[]{this.vcsName});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VcsBundle.message(\"proje\u2026cation.message\", vcsName)");
        return string;
    }

    @Override
    @NotNull
    public String getShowActionText() {
        return this.showActionText;
    }

    @Override
    @NotNull
    public String getForCurrentProjectActionText() {
        return this.forCurrentProjectActionText;
    }

    @Override
    @Nullable
    public String getForAllProjectsActionText() {
        return this.forAllProjectsActionText;
    }

    @Override
    @NotNull
    public String getMuteActionText() {
        return this.muteActionText;
    }

    @Override
    @Nullable
    protected String getViewFilesDialogTitle() {
        return this.viewFilesDialogTitle;
    }

    @Override
    public void rememberForAllProjects() {
    }

    private final boolean isProjectConfigurationFile(VirtualFile configDir, VirtualFile file) {
        return configDir != null && VfsUtilCore.isAncestor((VirtualFile)configDir, (VirtualFile)file, (boolean)true);
    }

    private final VirtualFile getProjectConfigDir(@NotNull Project $this$getProjectConfigDir) {
        VirtualFile projectConfigDir;
        VirtualFile virtualFile;
        if (!ProjectKt.isDirectoryBased((Project)$this$getProjectConfigDir) || $this$getProjectConfigDir.isDefault()) {
            return null;
        }
        String string = ProjectKt.getStateStore((Project)$this$getProjectConfigDir).getProjectConfigDir();
        if (string != null) {
            String string2 = string;
            LocalFileSystem localFileSystem = this.fileSystem;
            boolean bl = false;
            boolean bl2 = false;
            String p1 = string2;
            boolean bl3 = false;
            virtualFile = localFileSystem.findFileByPath(p1);
        } else {
            virtualFile = projectConfigDir = null;
        }
        if (projectConfigDir == null) {
            ProjectConfigurationFilesProcessorImplKt.access$getLOG$p().warn("Cannot find project config directory for non-default and non-directory based project " + $this$getProjectConfigDir.getName());
        }
        return projectConfigDir;
    }

    public ProjectConfigurationFilesProcessorImpl(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull String vcsName, @NotNull Function1<? super Collection<? extends VirtualFile>, Unit> addChosenFiles) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkParameterIsNotNull((Object)vcsName, (String)"vcsName");
        Intrinsics.checkParameterIsNotNull(addChosenFiles, (String)"addChosenFiles");
        super(project, parentDisposable);
        this.parentDisposable = parentDisposable;
        this.vcsName = vcsName;
        this.addChosenFiles = addChosenFiles;
        this.foundProjectConfigurationFiles = new AtomicBoolean();
        this.fileSystem = LocalFileSystem.getInstance();
        this.vcsIgnoreManager = VcsIgnoreManager.getInstance((Project)project);
        this.askedBeforeProperty = "ASKED_SHARE_PROJECT_CONFIGURATION_FILES";
        this.doForCurrentProjectProperty = "SHARE_PROJECT_CONFIGURATION_FILES";
        String string = VcsBundle.getString((String)"project.configuration.files.add.notification.action.view");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VcsBundle.getString(\"pro\u2026otification.action.view\")");
        this.showActionText = string;
        String string2 = VcsBundle.getString((String)"project.configuration.files.add.notification.action.add");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"VcsBundle.getString(\"pro\u2026notification.action.add\")");
        this.forCurrentProjectActionText = string2;
        String string3 = VcsBundle.getString((String)"project.configuration.files.add.notification.action.mute");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"VcsBundle.getString(\"pro\u2026otification.action.mute\")");
        this.muteActionText = string3;
        this.viewFilesDialogTitle = VcsBundle.message((String)"project.configuration.files.view.dialog.title", (Object[])new Object[]{this.vcsName});
    }

    public static final /* synthetic */ Disposable access$getParentDisposable$p(ProjectConfigurationFilesProcessorImpl $this) {
        return $this.parentDisposable;
    }

    public static final /* synthetic */ boolean access$isProjectConfigurationFile(ProjectConfigurationFilesProcessorImpl $this, VirtualFile configDir, VirtualFile file) {
        return $this.isProjectConfigurationFile(configDir, file);
    }
}

