/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RollbackLineStatusAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u000223B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0014J\r\u0010!\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020$H\u0014J!\u0010(\u001a\u0002H)\"\u0004\b\u0001\u0010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H)0+H\u0016\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010/\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&H\u0016J\r\u00100\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b1R$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00064"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "R", "Lcom/intellij/openapi/vcs/ex/Range;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "mode", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;)V", "value", "getMode", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "setMode", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "renderer", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$LocalLineStatusMarkerRenderer;", "getRenderer", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$LocalLineStatusMarkerRenderer;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "fireFileUnchanged", "", "fireLinesUnchanged", "startLine", "", "endLine", "freeze", "freeze$intellij_platform_vcs_impl", "isAvailableAt", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isDetectWhitespaceChangedLines", "readLock", "T", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "scrollAndShowHint", "range", "showHint", "unfreeze", "unfreeze$intellij_platform_vcs_impl", "LocalLineStatusMarkerRenderer", "Mode", "intellij.platform.vcs.impl"})
public abstract class LocalLineStatusTracker<R extends Range>
extends LineStatusTrackerBase<R>
implements LineStatusTracker<R> {
    @NotNull
    private Mode mode;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;

    @NotNull
    protected abstract LocalLineStatusMarkerRenderer getRenderer();

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        if (value == this.mode) {
            return;
        }
        this.mode = value;
        this.updateInnerRanges();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAvailableAt(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        if (this.mode == Mode.SILENT) return false;
        EditorSettings editorSettings = editor.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorSettings, (String)"editor.settings");
        if (!editorSettings.isLineMarkerAreaShown()) return false;
        if (DiffUtil.isDiffEditor((Editor)editor)) return false;
        return true;
    }

    protected boolean isDetectWhitespaceChangedLines() {
        return this.mode == Mode.SMART;
    }

    protected void fireFileUnchanged() {
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalSettings, (String)"GeneralSettings.getInstance()");
        if (generalSettings.isSaveOnFrameDeactivation()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                final /* synthetic */ LocalLineStatusTracker this$0;

                public final void run() {
                    FileDocumentManager.getInstance().saveDocument(this.this$0.getDocument());
                }
                {
                    this.this$0 = localLineStatusTracker;
                }
            }, this.getProject().getDisposed());
        }
    }

    protected void fireLinesUnchanged(int startLine, int endLine) {
        if (this.getDocument().getTextLength() == 0) {
            return;
        }
        if (startLine == endLine) {
            return;
        }
        Document document = this.getDocument();
        if (document == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
        }
        ((DocumentImpl)document).clearLineModificationFlags(startLine, endLine);
    }

    @Override
    public void scrollAndShowHint(@NotNull Range range, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.getRenderer().scrollAndShow(editor, range);
    }

    @Override
    public void showHint(@NotNull Range range, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.getRenderer().showAfterScroll(editor, range);
    }

    public final void freeze$intellij_platform_vcs_impl() {
        this.getDocumentTracker().freeze(Side.LEFT);
        this.getDocumentTracker().freeze(Side.RIGHT);
    }

    public final void unfreeze$intellij_platform_vcs_impl() {
        this.getDocumentTracker().unfreeze(Side.LEFT);
        this.getDocumentTracker().unfreeze(Side.RIGHT);
    }

    @Override
    public <T> T readLock(@NotNull Function0<? extends T> task2) {
        Intrinsics.checkParameterIsNotNull(task2, (String)"task");
        return (T)this.getDocumentTracker().readLock(task2);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    public LocalLineStatusTracker(@NotNull Project project, @NotNull Document document, @NotNull VirtualFile virtualFile, @NotNull Mode mode) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        super(project, document);
        this.project = project;
        this.virtualFile = virtualFile;
        this.mode = mode;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "", "(Ljava/lang/String;I)V", "DEFAULT", "SMART", "SILENT", "intellij.platform.vcs.impl"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode DEFAULT;
        public static final /* enum */ Mode SMART;
        public static final /* enum */ Mode SILENT;
        private static final /* synthetic */ Mode[] $VALUES;

        static {
            Mode[] modeArray = new Mode[3];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = DEFAULT = new Mode();
            modeArray[1] = SMART = new Mode();
            modeArray[2] = SILENT = new Mode();
            $VALUES = modeArray;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0014\u0018\u00002\u00020\u0001:\u0001\u001dB\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$LocalLineStatusMarkerRenderer;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer;", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "canDoAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "ranges", "", "Lcom/intellij/openapi/vcs/ex/Range;", "e", "Ljava/awt/event/MouseEvent;", "createToolbarActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "range", "mousePosition", "Ljava/awt/Point;", "getEditorFilter", "Lcom/intellij/openapi/editor/markup/MarkupEditorFilter;", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "paint", "", "g", "Ljava/awt/Graphics;", "RollbackLineStatusRangeAction", "intellij.platform.vcs.impl"})
    protected static class LocalLineStatusMarkerRenderer
    extends LineStatusMarkerPopupRenderer {
        @NotNull
        private final LocalLineStatusTracker<?> tracker;

        @Nullable
        protected MarkupEditorFilter getEditorFilter() {
            return MarkupEditorFilterFactory.createIsNotDiffFilter();
        }

        protected boolean canDoAction(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull(ranges, (String)"ranges");
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (this.getTracker().getMode() == Mode.SILENT) {
                return false;
            }
            return super.canDoAction(editor, ranges, e);
        }

        protected void paint(@NotNull Editor editor, @NotNull Graphics g) {
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
            if (this.getTracker().getMode() == Mode.SILENT) {
                return;
            }
            super.paint(editor, g);
        }

        @NotNull
        protected List<AnAction> createToolbarActions(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition) {
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add(new LineStatusMarkerPopupRenderer.ShowPrevChangeMarkerAction((LineStatusMarkerPopupRenderer)this, editor, range));
            actions.add(new LineStatusMarkerPopupRenderer.ShowNextChangeMarkerAction((LineStatusMarkerPopupRenderer)this, editor, range));
            actions.add((Object)new RollbackLineStatusRangeAction(editor, range));
            actions.add(new LineStatusMarkerPopupRenderer.ShowLineStatusRangeDiffAction((LineStatusMarkerPopupRenderer)this, editor, range));
            actions.add(new LineStatusMarkerPopupRenderer.CopyLineStatusRangeAction((LineStatusMarkerPopupRenderer)this, editor, range));
            actions.add(new LineStatusMarkerPopupRenderer.ToggleByWordDiffAction((LineStatusMarkerPopupRenderer)this, editor, range, mousePosition));
            return actions;
        }

        @NotNull
        protected FileType getFileType() {
            FileType fileType = this.getTracker().getVirtualFile().getFileType();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"tracker.virtualFile.fileType");
            return fileType;
        }

        @NotNull
        public LocalLineStatusTracker<?> getTracker() {
            return this.tracker;
        }

        public LocalLineStatusMarkerRenderer(@NotNull LocalLineStatusTracker<?> tracker) {
            Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            super((LineStatusTrackerBase)tracker);
            this.tracker = tracker;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$LocalLineStatusMarkerRenderer$RollbackLineStatusRangeAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$RangeMarkerAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$LocalLineStatusMarkerRenderer;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/Range;)V", "actionPerformed", "", "isEnabled", "", "intellij.platform.vcs.impl"})
        private final class RollbackLineStatusRangeAction
        extends LineStatusMarkerPopupRenderer.RangeMarkerAction
        implements LightEditCompatible {
            protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range) {
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
                return true;
            }

            protected void actionPerformed(@NotNull Editor editor, @NotNull Range range) {
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
                RollbackLineStatusAction.rollback((LineStatusTrackerBase)LocalLineStatusMarkerRenderer.this.getTracker(), range, editor);
            }

            public RollbackLineStatusRangeAction(@NotNull Editor editor, Range range) {
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
                super((LineStatusMarkerPopupRenderer)LocalLineStatusMarkerRenderer.this, editor, range, "Vcs.RollbackChangedLines");
            }
        }
    }
}

