/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.LocalFileSystem;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileWatchRequestModifier
implements Runnable,
Disposable {
    private final Project myProject;
    private final NewMappings myNewMappings;
    private final LocalFileSystem myLfs;
    private final Object LOCK;
    private Set<LocalFileSystem.WatchRequest> myWatches;
    private boolean myDisposed;

    public FileWatchRequestModifier(@NotNull Project project, @NotNull NewMappings newMappings, @NotNull LocalFileSystem localFileSystem) {
        if (project == null) {
            FileWatchRequestModifier.$$$reportNull$$$0(0);
        }
        if (newMappings == null) {
            FileWatchRequestModifier.$$$reportNull$$$0(1);
        }
        if (localFileSystem == null) {
            FileWatchRequestModifier.$$$reportNull$$$0(2);
        }
        this.LOCK = new Object();
        this.myWatches = Collections.emptySet();
        this.myLfs = localFileSystem;
        this.myProject = project;
        this.myNewMappings = newMappings;
        Disposer.register((Disposable)newMappings, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDisposed = true;
            this.myLfs.removeWatchedRoots(this.myWatches);
            this.myWatches = Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myDisposed) {
                return;
            }
            if (!this.myProject.isInitialized()) {
                return;
            }
            THashSet newWatchedRoots = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            for (VcsDirectoryMapping mapping : this.myNewMappings.getDirectoryMappings()) {
                if (mapping.isDefaultMapping()) continue;
                newWatchedRoots.add(FileUtil.toCanonicalPath((String)mapping.getDirectory()));
            }
            this.myWatches = this.myLfs.replaceWatchedRoots(this.myWatches, (Collection)newWatchedRoots, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "newMappings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "localFileSystem";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/FileWatchRequestModifier";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

