/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CurrentBranchConditionCache;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import com.intellij.vcs.log.util.StopWatch;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainingBranchesGetter {
    private static final Logger LOG = Logger.getInstance(ContainingBranchesGetter.class);
    @NotNull
    private final SequentialLimitedLifoExecutor<CachingTask> myTaskExecutor;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final List<Runnable> myLoadingFinishedListeners;
    @NotNull
    private SLRUMap<CommitId, List<String>> myCache;
    @NotNull
    private final CurrentBranchConditionCache myConditionsCache;
    private int myCurrentBranchesChecksum;

    ContainingBranchesGetter(@NotNull VcsLogData logData, @NotNull Disposable parentDisposable) {
        if (logData == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(1);
        }
        this.myLoadingFinishedListeners = new ArrayList<Runnable>();
        this.myCache = ContainingBranchesGetter.createCache();
        this.myLogData = logData;
        this.myConditionsCache = new CurrentBranchConditionCache(logData, parentDisposable);
        this.myTaskExecutor = new SequentialLimitedLifoExecutor(parentDisposable, 10, CachingTask::run);
        this.myLogData.addDataPackChangeListener(dataPack -> {
            Collection<VcsRef> currentBranches = dataPack.getRefsModel().getBranches();
            int checksum = currentBranches.hashCode();
            if (this.myCurrentBranchesChecksum != 0 && this.myCurrentBranchesChecksum != checksum) {
                this.clearCache();
            }
            this.myCurrentBranchesChecksum = checksum;
        });
    }

    private void clearCache() {
        this.myCache = ContainingBranchesGetter.createCache();
        this.myTaskExecutor.clear();
        this.myConditionsCache.clear();
        ApplicationManager.getApplication().invokeLater(this::notifyListeners);
    }

    public void addTaskCompletedListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListeners.add(runnable);
    }

    public void removeTaskCompletedListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListeners.remove(runnable);
    }

    private void notifyListeners() {
        LOG.assertTrue(EventQueue.isDispatchThread());
        for (Runnable listener2 : this.myLoadingFinishedListeners) {
            listener2.run();
        }
    }

    @Nullable
    public List<String> requestContainingBranches(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(4);
        }
        if (hash == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        List<String> refs = this.getContainingBranchesFromCache(root, hash);
        if (refs == null) {
            this.myTaskExecutor.queue(new CachingTask(this.createTask(root, hash, this.myLogData.getDataPack()), this.myCache));
        }
        return refs;
    }

    @Nullable
    public List<String> getContainingBranchesFromCache(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(6);
        }
        if (hash == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        return (List)this.myCache.get((Object)new CommitId(hash, root));
    }

    @Nullable
    public List<String> getContainingBranchesQuickly(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(8);
        }
        if (hash == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(EventQueue.isDispatchThread());
        CommitId commitId = new CommitId(hash, root);
        List<String> branches = (List<String>)this.myCache.get((Object)commitId);
        if (branches == null) {
            int nodeId;
            int index = this.myLogData.getCommitIndex(hash, root);
            PermanentGraph<Integer> pg = this.myLogData.getDataPack().getPermanentGraph();
            if (pg instanceof PermanentGraphInfo && (branches = (nodeId = ((PermanentGraphInfo)pg).getPermanentCommitsInfo().getNodeId(index)) < 10000 && ContainingBranchesGetter.canUseGraphForComputation(this.myLogData.getLogProvider(root)) ? this.getContainingBranchesSynchronously(root, hash) : (List)BackgroundTaskUtil.tryComputeFast(indicator -> this.getContainingBranchesSynchronously(root, hash), (long)100L)) != null) {
                this.myCache.put((Object)commitId, branches);
            }
        }
        return branches;
    }

    @NotNull
    public Condition<Integer> getContainedInCurrentBranchCondition(@NotNull VirtualFile root) {
        if (root == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(10);
        }
        Condition<Integer> condition = this.myConditionsCache.getContainedInCurrentBranchCondition(root);
        if (condition == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(11);
        }
        return condition;
    }

    @NotNull
    private static SLRUMap<CommitId, List<String>> createCache() {
        return new SLRUMap(1000, 1000);
    }

    @NotNull
    public List<String> getContainingBranchesSynchronously(@NotNull VirtualFile root, @NotNull Hash hash) {
        if (root == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(12);
        }
        if (hash == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(13);
        }
        List<String> list = this.createTask(root, hash, this.myLogData.getDataPack()).getContainingBranches();
        if (list == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private Task createTask(@NotNull VirtualFile root, @NotNull Hash hash, @NotNull DataPack dataPack) {
        VcsLogProvider provider;
        if (root == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(15);
        }
        if (hash == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(16);
        }
        if (dataPack == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(17);
        }
        if (ContainingBranchesGetter.canUseGraphForComputation(provider = this.myLogData.getLogProvider(root))) {
            return new GraphTask(provider, root, hash, dataPack);
        }
        return new ProviderTask(provider, root, hash);
    }

    private static boolean canUseGraphForComputation(@NotNull VcsLogProvider logProvider) {
        if (logProvider == null) {
            ContainingBranchesGetter.$$$reportNull$$$0(18);
        }
        return (Boolean)VcsLogProperties.LIGHTWEIGHT_BRANCHES.getOrDefault(logProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/ContainingBranchesGetter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/ContainingBranchesGetter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainedInCurrentBranchCondition";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingBranchesSynchronously";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTaskCompletedListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeTaskCompletedListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requestContainingBranches";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranchesFromCache";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranchesQuickly";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContainedInCurrentBranchCondition";
                break;
            }
            case 11: 
            case 14: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranchesSynchronously";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canUseGraphForComputation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CachingTask {
        @NotNull
        private final Task myTask;
        @NotNull
        private final SLRUMap<CommitId, List<String>> myCache;

        CachingTask(@NotNull Task task2, SLRUMap<CommitId, List<String>> cache) {
            if (task2 == null) {
                CachingTask.$$$reportNull$$$0(0);
            }
            if (cache == null) {
                CachingTask.$$$reportNull$$$0(1);
            }
            this.myTask = task2;
            this.myCache = cache;
        }

        public void run() {
            List<String> branches = this.myTask.getContainingBranches();
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myCache.put((Object)new CommitId(this.myTask.myHash, this.myTask.myRoot), (Object)branches);
                ContainingBranchesGetter.this.notifyListeners();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "task";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cache";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/data/ContainingBranchesGetter$CachingTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProviderTask
    extends Task {
        ProviderTask(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash) {
            if (provider == null) {
                ProviderTask.$$$reportNull$$$0(0);
            }
            if (root == null) {
                ProviderTask.$$$reportNull$$$0(1);
            }
            if (hash == null) {
                ProviderTask.$$$reportNull$$$0(2);
            }
            super(provider, root, hash);
        }

        @Override
        @NotNull
        public List<String> getContainingBranches(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
            if (provider == null) {
                ProviderTask.$$$reportNull$$$0(3);
            }
            if (root == null) {
                ProviderTask.$$$reportNull$$$0(4);
            }
            if (hash == null) {
                ProviderTask.$$$reportNull$$$0(5);
            }
            ArrayList<String> branches = new ArrayList<String>(provider.getContainingBranches(root, hash));
            Collections.sort(branches);
            ArrayList<String> arrayList = branches;
            if (arrayList == null) {
                ProviderTask.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hash";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/ContainingBranchesGetter$ProviderTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/ContainingBranchesGetter$ProviderTask";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingBranches";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getContainingBranches";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class GraphTask
    extends Task {
        @NotNull
        private final RefsModel myRefs;
        @NotNull
        private final PermanentGraph<Integer> myGraph;

        GraphTask(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash, DataPack dataPack) {
            if (provider == null) {
                GraphTask.$$$reportNull$$$0(0);
            }
            if (root == null) {
                GraphTask.$$$reportNull$$$0(1);
            }
            if (hash == null) {
                GraphTask.$$$reportNull$$$0(2);
            }
            if (dataPack == null) {
                GraphTask.$$$reportNull$$$0(3);
            }
            super(provider, root, hash);
            this.myGraph = dataPack.getPermanentGraph();
            this.myRefs = dataPack.getRefsModel();
        }

        @Override
        @NotNull
        protected List<String> getContainingBranches(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash) {
            if (provider == null) {
                GraphTask.$$$reportNull$$$0(4);
            }
            if (root == null) {
                GraphTask.$$$reportNull$$$0(5);
            }
            if (hash == null) {
                GraphTask.$$$reportNull$$$0(6);
            }
            Set branchesIndexes = this.myGraph.getContainingBranches((Object)ContainingBranchesGetter.this.myLogData.getCommitIndex(hash, root));
            Collection branchesRefs = new HashSet();
            for (Integer index : branchesIndexes) {
                this.myRefs.refsToCommit(index).stream().filter(ref -> ref.getType().isBranch()).forEach(branchesRefs::add);
            }
            branchesRefs = ContainerUtil.sorted(branchesRefs, (Comparator)provider.getReferenceManager().getLabelsOrderComparator());
            ArrayList<String> branchesList = new ArrayList<String>();
            for (VcsRef ref2 : branchesRefs) {
                branchesList.add(ref2.getName());
            }
            ArrayList<String> arrayList = branchesList;
            if (arrayList == null) {
                GraphTask.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hash";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataPack";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/ContainingBranchesGetter$GraphTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/ContainingBranchesGetter$GraphTask";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingBranches";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getContainingBranches";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class Task {
        @NotNull
        private final VcsLogProvider myProvider;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final Hash myHash;

        Task(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash) {
            if (provider == null) {
                Task.$$$reportNull$$$0(0);
            }
            if (root == null) {
                Task.$$$reportNull$$$0(1);
            }
            if (hash == null) {
                Task.$$$reportNull$$$0(2);
            }
            this.myProvider = provider;
            this.myRoot = root;
            this.myHash = hash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public List<String> getContainingBranches() {
            List<String> list;
            StopWatch sw = StopWatch.start("get containing branches");
            try {
                List<String> list2 = this.getContainingBranches(this.myProvider, this.myRoot, this.myHash);
                list = list2;
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                List<String> list3 = Collections.emptyList();
                List<String> list4 = list3;
                if (list4 == null) {
                    Task.$$$reportNull$$$0(4);
                }
                return list4;
            }
            finally {
                sw.report();
            }
            if (list == null) {
                Task.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        protected abstract List<String> getContainingBranches(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull Hash var3) throws VcsException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hash";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/ContainingBranchesGetter$Task";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/ContainingBranchesGetter$Task";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingBranches";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

