/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeavyAwareExecutor
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ListeningExecutorService myExecutorService;
    private final int myDelayMs;
    private final int myLongActivityDurationMs;

    public HeavyAwareExecutor(@NotNull Project project, int delayMs, int longActivityDurationMs, @NotNull Disposable parent) {
        if (project == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDelayMs = delayMs;
        this.myLongActivityDurationMs = longActivityDurationMs;
        this.myExecutorService = MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.getAppExecutorService());
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public Future<?> executeOutOfHeavyOrPowerSave(@NotNull Consumer<? super ProgressIndicator> task2, @NotNull ProgressIndicator indicator) {
        if (task2 == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(3);
        }
        ExecutingHeavyOrPowerSaveListener executingListener = new ExecutingHeavyOrPowerSaveListener(this.myProject, this.myDelayMs, this, () -> {
            ListenableFuture<?> future2 = this.runAsync(task2, indicator);
            Disposable disposable = Disposer.newDisposable();
            future2.addListener(() -> Disposer.dispose((Disposable)disposable), MoreExecutors.directExecutor());
            new CancellingOnHeavyOrPowerSaveListener(this.myProject, indicator, this.myLongActivityDurationMs, disposable);
            return future2;
        });
        return Futures.transformAsync(executingListener.getFuture(), input -> input, (Executor)MoreExecutors.directExecutor());
    }

    @NotNull
    private ListenableFuture<?> runAsync(@NotNull Consumer<? super ProgressIndicator> task2, @NotNull ProgressIndicator indicator) {
        if (task2 == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(5);
        }
        Runnable taskWithProgress = () -> ProgressManager.getInstance().runProcess(() -> task2.consume((Object)indicator), indicator);
        ListenableFuture listenableFuture = this.myExecutorService.submit(taskWithProgress);
        if (listenableFuture == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(6);
        }
        return listenableFuture;
    }

    public void dispose() {
    }

    public static void executeOutOfHeavyProcessLater(@NotNull Runnable command, int delayMs) {
        if (command == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(7);
        }
        HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> JobScheduler.getScheduler().schedule(() -> {
            if (HeavyProcessLatch.INSTANCE.isRunning()) {
                HeavyAwareExecutor.executeOutOfHeavyProcessLater(command, delayMs);
            } else {
                command.run();
            }
        }, (long)delayMs, TimeUnit.MILLISECONDS));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/HeavyAwareExecutor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeOutOfHeavyOrPowerSave";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runAsync";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeOutOfHeavyProcessLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExecutingHeavyOrPowerSaveListener
    implements PowerSaveMode.Listener,
    Disposable {
        @NotNull
        private final AtomicReference<Computable<ListenableFuture<?>>> myTask;
        private final int myDelayMs;
        private final SettableFuture<ListenableFuture<?>> myFuture;

        ExecutingHeavyOrPowerSaveListener(@NotNull Project project, int delayMs, @NotNull Disposable parent, @NotNull Computable<ListenableFuture<?>> task2) {
            if (project == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(1);
            }
            if (task2 == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(2);
            }
            this.myTask = new AtomicReference<Object>(null);
            this.myDelayMs = delayMs;
            this.myFuture = SettableFuture.create();
            this.myTask.set(task2);
            project.getMessageBus().connect((Disposable)this).subscribe(PowerSaveMode.TOPIC, (Object)this);
            Disposer.register((Disposable)parent, (Disposable)this);
            this.tryRun();
        }

        @NotNull
        public ListenableFuture<ListenableFuture<?>> getFuture() {
            SettableFuture<ListenableFuture<?>> settableFuture = this.myFuture;
            if (settableFuture == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(3);
            }
            return settableFuture;
        }

        public void powerSaveStateChanged() {
            this.tryRun();
        }

        private void tryRun() {
            if (!PowerSaveMode.isEnabled()) {
                HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> JobScheduler.getScheduler().schedule(() -> {
                    if (!HeavyProcessLatch.INSTANCE.isRunning() && !PowerSaveMode.isEnabled()) {
                        Disposer.dispose((Disposable)this);
                        Computable task2 = this.myTask.getAndSet(null);
                        if (task2 != null) {
                            this.runTask(task2);
                        }
                    } else {
                        this.tryRun();
                    }
                }, (long)this.myDelayMs, TimeUnit.MILLISECONDS));
            }
        }

        private void runTask(@NotNull Computable<ListenableFuture<?>> task2) {
            if (task2 == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(4);
            }
            try {
                this.myFuture.set(task2.compute());
            }
            catch (Throwable t) {
                this.myFuture.setException(t);
            }
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/HeavyAwareExecutor$ExecutingHeavyOrPowerSaveListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor$ExecutingHeavyOrPowerSaveListener";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFuture";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "runTask";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CancellingOnHeavyOrPowerSaveListener
    implements HeavyProcessLatch.HeavyProcessListener,
    PowerSaveMode.Listener {
        @NotNull
        private final ProgressIndicator myIndicator;
        private final int myLongActivityDurationMs;
        @Nullable
        private ScheduledFuture<?> myFuture;

        CancellingOnHeavyOrPowerSaveListener(@NotNull Project project, @NotNull ProgressIndicator indicator, int logActivityDurationMs, @NotNull Disposable disposable) {
            if (project == null) {
                CancellingOnHeavyOrPowerSaveListener.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                CancellingOnHeavyOrPowerSaveListener.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                CancellingOnHeavyOrPowerSaveListener.$$$reportNull$$$0(2);
            }
            this.myFuture = null;
            this.myIndicator = indicator;
            this.myLongActivityDurationMs = logActivityDurationMs;
            HeavyProcessLatch.INSTANCE.addListener((HeavyProcessLatch.HeavyProcessListener)this, disposable);
            project.getMessageBus().connect(disposable).subscribe(PowerSaveMode.TOPIC, (Object)this);
            this.scheduleCancel();
            this.powerSaveStateChanged();
        }

        public void processStarted() {
            this.scheduleCancel();
        }

        public void processFinished() {
            this.doNotCancel();
        }

        public void powerSaveStateChanged() {
            if (PowerSaveMode.isEnabled() && this.myIndicator.isRunning()) {
                this.myIndicator.cancel();
            }
        }

        private synchronized void scheduleCancel() {
            if (HeavyProcessLatch.INSTANCE.isRunning() && this.myFuture == null) {
                this.myFuture = JobScheduler.getScheduler().schedule(() -> {
                    if (HeavyProcessLatch.INSTANCE.isRunning() && this.myIndicator.isRunning()) {
                        this.myIndicator.cancel();
                    }
                }, (long)this.myLongActivityDurationMs, TimeUnit.MILLISECONDS);
            }
        }

        private synchronized void doNotCancel() {
            if (!HeavyProcessLatch.INSTANCE.isRunning() && this.myFuture != null) {
                ScheduledFuture<?> future2 = this.myFuture;
                this.myFuture = null;
                future2.cancel(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "disposable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor$CancellingOnHeavyOrPowerSaveListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

