/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.actions.AddGroupToLocalWhitelistDialog;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistTestGroupStorage;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AddTestGroupToLocalWhitelistAction
extends DumbAwareAction {
    private static final LayeredIcon ICON = new LayeredIcon(new Icon[]{AllIcons.General.Add, AllIcons.Actions.Scratch});

    public AddTestGroupToLocalWhitelistAction() {
        super(ActionsBundle.messagePointer((String)"action.AddTestGroupToLocalWhitelistAction.text", (Object[])new Object[0]), ActionsBundle.messagePointer((String)"action.AddTestGroupToLocalWhitelistAction.description", (Object[])new Object[0]), (Icon)ICON);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AddTestGroupToLocalWhitelistAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        final AddGroupToLocalWhitelistDialog dialog2 = new AddGroupToLocalWhitelistDialog(project, null, null);
        boolean result = dialog2.showAndGet();
        if (!result || StringUtil.isEmpty((String)dialog2.getGroupId()) || StringUtil.isEmpty((String)dialog2.getRecorderId())) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Adding Test Group and Updating Whitelist...", false){

            public void run(@NotNull ProgressIndicator indicator) {
                String recorderId;
                WhitelistTestGroupStorage testWhitelist;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((testWhitelist = WhitelistTestGroupStorage.getTestStorage((String)(recorderId = dialog2.getRecorderId()))) == null) {
                    AddTestGroupToLocalWhitelistAction.this.showNotification(project, NotificationType.ERROR, "Cannot find test whitelist storage.");
                    return;
                }
                try {
                    if (dialog2.isCustomRules()) {
                        testWhitelist.addGroupWithCustomRules(dialog2.getGroupId(), dialog2.getCustomRules());
                    } else {
                        testWhitelist.addTestGroup(dialog2.getGroupId());
                    }
                    AddTestGroupToLocalWhitelistAction.this.showNotification(project, NotificationType.INFORMATION, "Group '" + dialog2.getGroupId() + "' was added to local whitelist");
                }
                catch (IOException ex) {
                    AddTestGroupToLocalWhitelistAction.this.showNotification(project, NotificationType.ERROR, "Failed updating local list: " + ex.getMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/statistic/actions/AddTestGroupToLocalWhitelistAction$1", "run"));
            }
        });
    }

    protected void showNotification(@NotNull Project project, @NotNull NotificationType type, @NotNull String message) {
        if (project == null) {
            AddTestGroupToLocalWhitelistAction.$$$reportNull$$$0(1);
        }
        if (type == null) {
            AddTestGroupToLocalWhitelistAction.$$$reportNull$$$0(2);
        }
        if (message == null) {
            AddTestGroupToLocalWhitelistAction.$$$reportNull$$$0(3);
        }
        String title = StatisticsBundle.message((String)"stats.feature.usage.statistics", (Object[])new Object[0]);
        Notifications.Bus.notify((Notification)new Notification("FeatureUsageStatistics", title, message, type), (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/actions/AddTestGroupToLocalWhitelistAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

