/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

class IoTimings {
    private static final int WARM_UP_PROBES = 2;
    private static final int IO_PROBES = 42;

    IoTimings() {
    }

    static long calcIoTiming() {
        long start = System.nanoTime();
        for (int i = 0; i < 2; ++i) {
            IoTimings.singleIteration(i, true);
        }
        long warmupMinutes = TimeUnit.NANOSECONDS.toMinutes(System.nanoTime() - start);
        if (warmupMinutes > 1L) {
            System.out.println("Too long warmup: " + warmupMinutes + " minutes");
        }
        start = System.nanoTime();
        for (int i = 0; i < 42; ++i) {
            IoTimings.singleIteration(i, i == 41);
        }
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
    }

    private static void singleIteration(int i, boolean doSync) {
        try {
            File tempFile = FileUtil.createTempFile((String)"test", (String)("test" + i));
            try (FileWriter writer = new FileWriter(tempFile);){
                for (int j = 0; j < 15; ++j) {
                    writer.write("test" + j);
                    writer.flush();
                }
            }
            var4_5 = null;
            try (FileReader reader = new FileReader(tempFile);){
                while (reader.read() >= 0) {
                }
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            if (doSync) {
                var4_5 = null;
                try (FileOutputStream stream = new FileOutputStream(tempFile);){
                    stream.getFD().sync();
                }
                catch (Throwable throwable) {
                    var4_5 = throwable;
                    throw throwable;
                }
            }
            if (!tempFile.delete()) {
                throw new IOException("Unable to delete: " + tempFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

