/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.ml.CompletionEnvironment;
import com.intellij.codeInsight.completion.ml.ContextFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.completion.ml.common.LocationFeaturesUtil;
import com.intellij.completion.ngram.NGram;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\f\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/completion/ml/common/CommonLocationFeatures;", "Lcom/intellij/codeInsight/completion/ml/ContextFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "environment", "Lcom/intellij/codeInsight/completion/ml/CompletionEnvironment;", "getName", "putNGramScorer", "", "addPsiParents", "", "position", "Lcom/intellij/psi/PsiElement;", "numParents", "", "intellij.statsCollector"})
public final class CommonLocationFeatures
implements ContextFeatureProvider {
    @NotNull
    public String getName() {
        return "common";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull CompletionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Lookup lookup = environment.getLookup();
        Intrinsics.checkExpressionValueIsNotNull((Object)lookup, (String)"environment.lookup");
        Lookup lookup2 = lookup;
        Editor editor = lookup2.getTopLevelEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"lookup.topLevelEditor");
        Editor editor2 = editor;
        int caretOffset = lookup2.getLookupStart();
        LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(caretOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition, (String)"editor.offsetToLogicalPosition(caretOffset)");
        LogicalPosition logicalPosition2 = logicalPosition;
        int lineStartOffset = editor2.getDocument().getLineStartOffset(logicalPosition2.line);
        String string = editor2.getDocument().getText(new TextRange(lineStartOffset, caretOffset));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"editor.document.getText(\u2026tartOffset, caretOffset))");
        String linePrefix = string;
        this.putNGramScorer(environment);
        Map result = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"line_num", (Object)MLFeatureValue.Companion.float(logicalPosition2.line)), TuplesKt.to((Object)"col_num", (Object)MLFeatureValue.Companion.float(logicalPosition2.column)), TuplesKt.to((Object)"indent_level", (Object)MLFeatureValue.Companion.float(LocationFeaturesUtil.INSTANCE.indentLevel(linePrefix, EditorUtil.getTabSize((Editor)editor2)))), TuplesKt.to((Object)"is_in_line_beginning", (Object)MLFeatureValue.Companion.binary(StringUtil.isEmptyOrSpaces((String)linePrefix)))});
        if (DumbService.isDumb((Project)lookup2.getProject())) {
            result.put("dumb_mode", MLFeatureValue.Companion.binary(true));
        }
        CompletionParameters completionParameters = environment.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)completionParameters, (String)"environment.parameters");
        PsiElement psiElement = completionParameters.getPosition();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"environment.parameters.position");
        this.addPsiParents(result, psiElement, 10);
        return result;
    }

    private final void putNGramScorer(CompletionEnvironment environment) {
        CompletionParameters completionParameters = environment.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)completionParameters, (String)"environment.parameters");
        NGram.ScoringFunction scoringFunction = NGram.INSTANCE.createScoringFunction(completionParameters, 4);
        if (scoringFunction != null) {
            environment.putUserData(NGram.INSTANCE.getNGRAM_SCORER_KEY$intellij_statsCollector(), (Object)scoringFunction);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addPsiParents(@NotNull Map<String, MLFeatureValue> $this$addPsiParents, PsiElement position, int numParents) {
        PsiElement psiElement = position.getParent();
        if (psiElement == null) {
            return;
        }
        PsiElement curParent = psiElement;
        int n = 1;
        int n2 = numParents;
        if (n <= n2) {
            while (true) {
                void i;
                PsiElement psiElement2;
                if ((psiElement2 = curParent) == null || (psiElement2 = psiElement2.getParent()) == null) {
                    return;
                }
                curParent = psiElement2;
                String parentName = "parent_" + (int)i;
                $this$addPsiParents.put(parentName, MLFeatureValue.Companion.className(curParent.getClass()));
                if (curParent instanceof PsiFileSystemItem) {
                    return;
                }
                if (i == n2) break;
                ++i;
            }
        }
    }
}

