/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.settings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.completion.ranker.WeakModelProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="CompletionMLRankingSettings", storages={@Storage(value="completionMLRanking.xml")})
public class CompletionMLRankingSettings
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(CompletionMLRankingSettings.class);
    private static final Collection<String> ENABLED_BY_DEFAULT = WeakModelProvider.enabledByDefault();
    private final State myState = new State();

    @NotNull
    public static CompletionMLRankingSettings getInstance() {
        CompletionMLRankingSettings completionMLRankingSettings = (CompletionMLRankingSettings)ServiceManager.getService(CompletionMLRankingSettings.class);
        if (completionMLRankingSettings == null) {
            CompletionMLRankingSettings.$$$reportNull$$$0(0);
        }
        return completionMLRankingSettings;
    }

    public boolean isRankingEnabled() {
        return this.myState.rankingEnabled;
    }

    public boolean isShowDiffEnabled() {
        return this.myState.rankingEnabled && this.myState.showDiff;
    }

    void setRankingEnabled(boolean value) {
        this.myState.rankingEnabled = value;
    }

    public boolean isCompletionLogsSendAllowed() {
        return ApplicationManager.getApplication().isEAP() && Registry.is((String)"completion.stats.send.logs");
    }

    public boolean isLanguageEnabled(@NotNull String languageName) {
        if (languageName == null) {
            CompletionMLRankingSettings.$$$reportNull$$$0(1);
        }
        return this.myState.language2state.getOrDefault(languageName, ENABLED_BY_DEFAULT.contains(languageName));
    }

    public void setLanguageEnabled(@NotNull String languageName, boolean isEnabled) {
        boolean defaultValue;
        if (languageName == null) {
            CompletionMLRankingSettings.$$$reportNull$$$0(2);
        }
        if ((defaultValue = ENABLED_BY_DEFAULT.contains(languageName)) == isEnabled) {
            this.myState.language2state.remove(languageName);
        } else {
            this.myState.language2state.put(languageName, isEnabled);
        }
        this.logCompletionState(languageName, isEnabled);
    }

    public void setShowDiffEnabled(boolean isEnabled) {
        this.myState.showDiff = isEnabled;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            CompletionMLRankingSettings.$$$reportNull$$$0(3);
        }
        this.myState.rankingEnabled = state.rankingEnabled;
        this.myState.showDiff = state.showDiff;
        state.language2state.forEach((lang, enabled) -> this.setLanguageEnabled((String)lang, (boolean)enabled));
    }

    private void logCompletionState(@NotNull String languageName, boolean isEnabled) {
        if (languageName == null) {
            CompletionMLRankingSettings.$$$reportNull$$$0(4);
        }
        boolean enabled = this.myState.rankingEnabled && isEnabled;
        boolean showDiff = enabled && this.myState.showDiff;
        LOG.info("ML Completion " + (enabled ? "enabled" : "disabled") + " ,show diff " + (showDiff ? "on" : "off") + " for: " + languageName);
    }

    static /* synthetic */ Collection access$000() {
        return ENABLED_BY_DEFAULT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/completion/settings/CompletionMLRankingSettings";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/completion/settings/CompletionMLRankingSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logCompletionState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        public boolean rankingEnabled = !CompletionMLRankingSettings.access$000().isEmpty();
        public boolean showDiff = false;
        public Map<String, Boolean> language2state = new HashMap<String, Boolean>();
    }
}

