/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.settings.CompletionMLRankingSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.stats.storage.factors.LookupStorage;
import com.intellij.ui.JBColor;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/stats/completion/ItemsDiffCustomizingContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "shouldShowDiff", "", "Companion", "MovedLookupElement", "intellij.statsCollector"})
public final class ItemsDiffCustomizingContributor
extends CompletionContributor {
    @NotNull
    private static final Key<AtomicInteger> DIFF_KEY;
    public static final Companion Companion;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        if (this.shouldShowDiff(parameters)) {
            result.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>(result){
                final /* synthetic */ CompletionResultSet $result;

                public final void consume(CompletionResult it) {
                    CompletionResult completionResult = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)completionResult, (String)"it");
                    LookupElement lookupElement = completionResult.getLookupElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)lookupElement, (String)"it.lookupElement");
                    this.$result.passResult(it.withLookupElement((LookupElement)new MovedLookupElement(lookupElement)));
                }
                {
                    this.$result = completionResultSet;
                }
            });
        } else {
            super.fillCompletionVariants(parameters, result);
        }
    }

    private final boolean shouldShowDiff(CompletionParameters parameters) {
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
        CompletionMLRankingSettings mlRankingSettings = completionMLRankingSettings;
        if (!mlRankingSettings.isShowDiffEnabled()) {
            return false;
        }
        if (!mlRankingSettings.isRankingEnabled()) {
            return false;
        }
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)parameters.getEditor());
        if (!(lookupEx instanceof LookupImpl)) {
            lookupEx = null;
        }
        LookupImpl lookupImpl = (LookupImpl)lookupEx;
        if (lookupImpl == null) {
            return false;
        }
        LookupImpl lookup = lookupImpl;
        LookupStorage lookupStorage = LookupStorage.Companion.get(lookup);
        return (lookupStorage != null ? lookupStorage.getModel() : null) != null;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"ItemsDiffCustomizerContributor.DIFF_KEY");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<AtomicInteger\u2026zerContributor.DIFF_KEY\")");
        DIFF_KEY = key;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/stats/completion/ItemsDiffCustomizingContributor$MovedLookupElement;", "Lcom/intellij/codeInsight/lookup/LookupElementDecorator;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "delegate", "(Lcom/intellij/codeInsight/lookup/LookupElement;)V", "renderElement", "", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "Companion", "intellij.statsCollector"})
    private static final class MovedLookupElement
    extends LookupElementDecorator<LookupElement> {
        @NotNull
        private static final JBColor ML_RANK_DIFF_GREEN_COLOR;
        @Deprecated
        public static final Companion Companion;

        public void renderElement(@NotNull LookupElementPresentation presentation) {
            Color color;
            String text;
            Integer diff;
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            super.renderElement(presentation);
            AtomicInteger atomicInteger = (AtomicInteger)this.getUserData(Companion.getDIFF_KEY());
            Integer n = diff = atomicInteger != null ? Integer.valueOf(atomicInteger.get()) : null;
            if (diff == null || diff == 0 || !presentation.isReal()) {
                return;
            }
            String string = text = diff < 0 ? " \u2191" + -diff.intValue() + ' ' : " \u2193" + diff + ' ';
            if (diff < 0) {
                color = (Color)ML_RANK_DIFF_GREEN_COLOR;
            } else {
                JBColor jBColor = JBColor.RED;
                Intrinsics.checkExpressionValueIsNotNull((Object)jBColor, (String)"JBColor.RED");
                color = (Color)jBColor;
            }
            Color color2 = color;
            List list = presentation.getTailFragments();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"presentation.tailFragments");
            List fragments = list;
            presentation.setTailText(text, color2);
            for (LookupElementPresentation.TextFragment fragment : fragments) {
                String string2 = fragment.text;
                LookupElementPresentation.TextFragment textFragment = fragment;
                Intrinsics.checkExpressionValueIsNotNull((Object)textFragment, (String)"fragment");
                presentation.appendTailText(string2, textFragment.isGrayed());
            }
        }

        public MovedLookupElement(@NotNull LookupElement delegate) {
            Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
            super(delegate);
        }

        static {
            Companion = new Companion(null);
            ML_RANK_DIFF_GREEN_COLOR = new JBColor(JBColor.GREEN.darker(), JBColor.GREEN.brighter());
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/stats/completion/ItemsDiffCustomizingContributor$MovedLookupElement$Companion;", "", "()V", "ML_RANK_DIFF_GREEN_COLOR", "Lcom/intellij/ui/JBColor;", "getML_RANK_DIFF_GREEN_COLOR", "()Lcom/intellij/ui/JBColor;", "intellij.statsCollector"})
        private static final class Companion {
            @NotNull
            public final JBColor getML_RANK_DIFF_GREEN_COLOR() {
                return ML_RANK_DIFF_GREEN_COLOR;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/stats/completion/ItemsDiffCustomizingContributor$Companion;", "", "()V", "DIFF_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/util/concurrent/atomic/AtomicInteger;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getDIFF_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.statsCollector"})
    public static final class Companion {
        @NotNull
        public final Key<AtomicInteger> getDIFF_KEY() {
            return DIFF_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

