/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.LogConsoleManagerBase;
import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.RunTab;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.net.NetUtils;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.intellij.lang.xpath.xslt.run.XsltRunConfiguration;
import org.intellij.lang.xpath.xslt.run.XsltRunnerExtension;
import org.intellij.plugins.xsltDebugger.DebugProcessListener;
import org.intellij.plugins.xsltDebugger.XsltDebuggerRunner;
import org.intellij.plugins.xsltDebugger.ui.OutputTabComponent;
import org.intellij.plugins.xsltDebugger.ui.StructureTabComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltDebuggerExtension
extends XsltRunnerExtension {
    private static final Logger LOG = Logger.getInstance((String)XsltDebuggerExtension.class.getName());
    public static final Key<XsltChecker.LanguageLevel> VERSION = Key.create((String)"VERSION");
    private static final Key<Integer> PORT = Key.create((String)"PORT");
    private static final Key<Manifest> MANIFEST = Key.create((String)"MANIFEST");
    private static final Key<String> ACCESS_TOKEN = Key.create((String)"access token");
    @NonNls
    private static final String SAXON_6_JAR = "saxon.jar";
    @NonNls
    private static final String SAXON_9_JAR = "saxon9he.jar";

    protected boolean supports(XsltRunConfiguration config, boolean debugger) {
        return (debugger || XsltDebuggerRunner.ACTIVE.get() == Boolean.TRUE) && config.getOutputType() == XsltRunConfiguration.OutputType.CONSOLE;
    }

    public ProcessListener createProcessListener(Project project, UserDataHolder extensionData) {
        Integer port = (Integer)extensionData.getUserData(PORT);
        assert (port != null);
        return new DebugProcessListener(project, port, (String)extensionData.getUserData(ACCESS_TOKEN));
    }

    public boolean createTabs(Project project, AdditionalTabComponentManager manager, @NotNull AdditionalTabComponent outputConsole, ProcessHandler process) {
        if (outputConsole == null) {
            XsltDebuggerExtension.$$$reportNull$$$0(0);
        }
        if (manager instanceof RunTab) {
            LogConsoleManagerBase runTab = ((RunTab)manager).getLogConsoleManager();
            runTab.addAdditionalTabComponent((AdditionalTabComponent)new OutputTabComponent(outputConsole), "XSLT-Output", AllIcons.Debugger.Console);
            runTab.addAdditionalTabComponent((AdditionalTabComponent)StructureTabComponent.create(process, (Disposable)outputConsole), "XSLT-Structure", PlatformIcons.FLATTEN_PACKAGES_ICON);
        } else {
            manager.addAdditionalTabComponent((AdditionalTabComponent)new OutputTabComponent(outputConsole), "XSLT-Output");
            manager.addAdditionalTabComponent((AdditionalTabComponent)StructureTabComponent.create(process, (Disposable)outputConsole), "XSLT-Structure");
        }
        return true;
    }

    public void patchParameters(SimpleJavaParameters parameters, XsltRunConfiguration configuration, UserDataHolder extensionData) throws CantRunException {
        File rmiStubs;
        File pluginPath;
        Sdk jdk = configuration.getEffectiveJDK();
        assert (jdk != null);
        JavaVersion version = JavaVersion.tryParse((String)jdk.getVersionString());
        if (version == null || version.feature < 5 || version.feature > 8) {
            throw new CantRunException("The XSLT Debugger requires Java 1.5 - 1.8 to run");
        }
        if (configuration.getOutputType() != XsltRunConfiguration.OutputType.CONSOLE) {
            throw new CantRunException("XSLT Debugger requires Output Type == CONSOLE");
        }
        try {
            int port = NetUtils.findAvailableSocketPort();
            parameters.getVMParametersList().defineProperty("xslt.debugger.port", String.valueOf(port));
            extensionData.putUserData(PORT, (Object)port);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            throw new CantRunException("Unable to find a free network port");
        }
        String token = UUID.randomUUID().toString();
        parameters.getVMParametersList().defineProperty("xslt.debugger.token", token);
        extensionData.putUserData(ACCESS_TOKEN, (Object)token);
        char c = File.separatorChar;
        PluginId pluginId = PluginManagerCore.getPluginByClassName((String)((Object)((Object)this)).getClass().getName());
        assert (pluginId != null || System.getProperty("xslt-debugger.plugin.path") != null) : "PluginId not found - development builds need to specify -Dxslt-debugger.plugin.path=../out/classes/production/intellij.xslt.debugger.engine";
        if (pluginId != null) {
            IdeaPluginDescriptor descriptor = PluginManagerCore.getPlugin((PluginId)pluginId);
            assert (descriptor != null);
            pluginPath = descriptor.getPath();
        } else {
            pluginPath = new File(System.getProperty("xslt-debugger.plugin.path"));
        }
        File rtClasspath = new File(pluginPath, "lib" + c + "xslt-debugger-engine.jar");
        if (rtClasspath.exists()) {
            parameters.getClassPath().addTail(rtClasspath.getAbsolutePath());
            rmiStubs = new File(pluginPath, "lib" + c + "rmi-stubs.jar");
            assert (rmiStubs.exists()) : rmiStubs.getAbsolutePath();
            parameters.getClassPath().addTail(rmiStubs.getAbsolutePath());
            File engineImpl = new File(pluginPath, "lib" + c + "rt" + c + "xslt-debugger-engine-impl.jar");
            assert (engineImpl.exists()) : engineImpl.getAbsolutePath();
            parameters.getClassPath().addTail(engineImpl.getAbsolutePath());
        } else {
            rtClasspath = new File(pluginPath, "classes");
            if (!rtClasspath.exists()) {
                if (ApplicationManager.getApplication().isInternal() && new File(pluginPath, "org").exists()) {
                    rtClasspath = pluginPath;
                    File engineImplInternal = new File(pluginPath, ".." + c + "intellij.xslt.debugger.engine.impl");
                    assert (engineImplInternal.exists()) : engineImplInternal.getAbsolutePath();
                    parameters.getClassPath().addTail(engineImplInternal.getAbsolutePath());
                } else {
                    throw new CantRunException("Runtime classes not found at " + rtClasspath.getAbsolutePath());
                }
            }
            parameters.getClassPath().addTail(rtClasspath.getAbsolutePath());
            rmiStubs = new File(rtClasspath, "rmi-stubs.jar");
            assert (rmiStubs.exists()) : rmiStubs.getAbsolutePath();
            parameters.getClassPath().addTail(rmiStubs.getAbsolutePath());
        }
        File trove4j = new File(PathUtil.getJarPathForClass(THashMap.class));
        parameters.getClassPath().addTail(trove4j.getAbsolutePath());
        String type = parameters.getVMParametersList().getPropertyValue("xslt.transformer.type");
        if ("saxon".equalsIgnoreCase(type)) {
            XsltDebuggerExtension.addSaxon(parameters, pluginPath, SAXON_6_JAR);
        } else if ("saxon9".equalsIgnoreCase(type)) {
            XsltDebuggerExtension.addSaxon(parameters, pluginPath, SAXON_9_JAR);
        } else if ("xalan".equalsIgnoreCase(type)) {
            Boolean xalanPresent = XsltDebuggerExtension.isValidXalanPresent(parameters);
            if (xalanPresent == null) {
                XsltDebuggerExtension.addXalan(parameters, pluginPath);
            } else if (!xalanPresent.booleanValue()) {
                throw new CantRunException("Unsupported Xalan version is present in classpath.");
            }
        } else {
            if (type != null) {
                throw new CantRunException("Unsupported Transformer type '" + type + "'");
            }
            if (StringUtil.toLowerCase((String)parameters.getClassPath().getPathsString()).contains("xalan") && XsltDebuggerExtension.isValidXalanPresent(parameters) == Boolean.TRUE) {
                parameters.getVMParametersList().defineProperty("xslt.transformer.type", "xalan");
            }
        }
        VirtualFile xsltFile = configuration.findXsltFile();
        PsiManager psiManager = PsiManager.getInstance((Project)configuration.getProject());
        XsltChecker.LanguageLevel level = xsltFile != null ? XsltSupport.getXsltLanguageLevel((PsiFile)psiManager.findFile(xsltFile)) : XsltChecker.LanguageLevel.V1;
        extensionData.putUserData(VERSION, (Object)level);
        if (!parameters.getVMParametersList().hasProperty("xslt.transformer.type")) {
            if (level == XsltChecker.LanguageLevel.V2) {
                parameters.getVMParametersList().defineProperty("xslt.transformer.type", "saxon9");
                XsltDebuggerExtension.addSaxon(parameters, pluginPath, SAXON_9_JAR);
            } else {
                parameters.getVMParametersList().defineProperty("xslt.transformer.type", "saxon");
                XsltDebuggerExtension.addSaxon(parameters, pluginPath, SAXON_6_JAR);
            }
        }
        parameters.getVMParametersList().defineProperty("xslt.main", "org.intellij.plugins.xsltDebugger.rt.XSLTDebuggerMain");
    }

    @Nullable
    private static Boolean isValidXalanPresent(SimpleJavaParameters parameters) {
        List files = parameters.getClassPath().getVirtualFiles();
        for (VirtualFile file : files) {
            block10: {
                VirtualFile manifestFile;
                if (!file.getName().matches(".*xalan.*\\.jar")) continue;
                VirtualFile root = JarFileSystem.getInstance().getJarRootForLocalFile(file);
                VirtualFile virtualFile = manifestFile = root != null ? root.findFileByRelativePath("META-INF/MANIFEST.MF") : null;
                if (manifestFile != null) {
                    try {
                        Attributes attributes;
                        Manifest manifest = (Manifest)manifestFile.getUserData(MANIFEST);
                        if (manifest == null) {
                            manifest = new Manifest(manifestFile.getInputStream());
                            manifestFile.putUserData(MANIFEST, (Object)manifest);
                        }
                        if ((attributes = manifest.getAttributes("org/apache/xalan/")) == null) {
                            attributes = manifest.getAttributes("org/apache/xalan");
                        }
                        if (attributes == null) {
                            LOG.info("No manifest attributes for 'org/apache/xalan/' in " + manifestFile.getPresentableUrl());
                            continue;
                        }
                        String version = attributes.getValue("Implementation-Version");
                        if (version != null) {
                            String[] parts = version.split("\\.");
                            if (parts.length >= 2 && Integer.parseInt(parts[0]) >= 2 && Integer.parseInt(parts[1]) >= 6) {
                                return true;
                            }
                            LOG.info("Unsupported Xalan version: " + version);
                            break block10;
                        }
                        LOG.info("No Xalan version information in " + file.getPath());
                    }
                    catch (IOException e) {
                        LOG.warn("Unable to read manifest from " + file.getName(), (Throwable)e);
                    }
                } else {
                    LOG.info("No manifest file in " + file.getPath());
                }
            }
            return false;
        }
        return null;
    }

    private static void addXalan(SimpleJavaParameters parameters, File pluginPath) {
        File xalan = XsltDebuggerExtension.findTransformerJar(pluginPath, "xalan-2.7.2.jar");
        parameters.getClassPath().addTail(xalan.getAbsolutePath());
        parameters.getClassPath().addTail(new File(xalan.getParentFile(), "serializer-2.7.2.jar").getAbsolutePath());
    }

    private static void addSaxon(SimpleJavaParameters parameters, File pluginPath, String saxonJar) {
        File saxon = XsltDebuggerExtension.findTransformerJar(pluginPath, saxonJar);
        parameters.getClassPath().addTail(saxon.getAbsolutePath());
    }

    private static File findTransformerJar(File pluginPath, String jarFile) {
        char c = File.separatorChar;
        File transformerFile = new File(pluginPath, "lib" + c + "rt" + c + jarFile);
        if (!(transformerFile.exists() || (transformerFile = new File(pluginPath, "lib" + c + jarFile)).exists() || (transformerFile = new File(new File(pluginPath, ".." + c + "intellij.xslt.debugger.engine.impl"), jarFile)).exists())) {
            transformerFile = new File(pluginPath, jarFile);
            assert (transformerFile.exists()) : transformerFile.getAbsolutePath();
        }
        return transformerFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsole", "org/intellij/plugins/xsltDebugger/XsltDebuggerExtension", "createTabs"));
    }
}

