/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.reference.SoftReference;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.StringInterner;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.intellij.plugins.xsltDebugger.XsltDebuggerSession;
import org.intellij.plugins.xsltDebugger.rt.engine.OutputEventQueue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GeneratedStructureModel
extends DefaultTreeModel {
    @NonNls
    private static final String PENDING = "...";
    private static WeakReference<Interner<String>> ourSharedInterner;
    private final LinkedList<DefaultMutableTreeNode> myCurrentPath = new LinkedList();
    private final List<DefaultMutableTreeNode> myLastNodes = new LinkedList<DefaultMutableTreeNode>();
    private final Interner<String> myInterner = GeneratedStructureModel.getInterner();
    private boolean myFilterWhitespace;
    private boolean myListenersDisabled;

    private static Interner<String> getInterner() {
        Interner interner = (Interner)SoftReference.dereference(ourSharedInterner);
        if (interner == null) {
            interner = new StringInterner();
            ourSharedInterner = new WeakReference<Interner>(interner);
        }
        return interner;
    }

    public GeneratedStructureModel() {
        super(new MyRootNode());
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        this.myCurrentPath.add(root);
        root.add(new DefaultMutableTreeNode(PENDING));
    }

    public void update(List<OutputEventQueue.NodeEvent> eventQueue) {
        if (!SwingUtilities.isEventDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(() -> this.updateImpl(eventQueue));
            return;
        }
        this.updateImpl(eventQueue);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (!this.myFilterWhitespace) {
            return super.getChild(parent, index);
        }
        return GeneratedStructureModel.getFilteredChildren((DefaultMutableTreeNode)parent, false).get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (!this.myFilterWhitespace) {
            return super.getChildCount(parent);
        }
        return GeneratedStructureModel.getFilteredChildren((DefaultMutableTreeNode)parent, false).size();
    }

    @Override
    public boolean isLeaf(Object node) {
        if (!this.myFilterWhitespace) {
            return super.isLeaf(node);
        }
        return super.isLeaf(node) || GeneratedStructureModel.getFilteredChildren((DefaultMutableTreeNode)node, true).size() == 0;
    }

    private static List getFilteredChildren(DefaultMutableTreeNode node, boolean checkOnly) {
        if (node.getChildCount() == 0) {
            return Collections.emptyList();
        }
        Object nodes = checkOnly ? new SmartList() : new ArrayList(node.getChildCount());
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
        while (child != null) {
            OutputEventQueue.NodeEvent event;
            if (child instanceof StructureNode && (event = (OutputEventQueue.NodeEvent)child.getUserObject()) != null && event.getType() == 4 && event.getValue().trim().length() == 0) {
                child = child.getNextSibling();
                continue;
            }
            nodes.add(child);
            if (checkOnly) {
                return nodes;
            }
            child = child.getNextSibling();
        }
        return nodes;
    }

    private void updateImpl(List<OutputEventQueue.NodeEvent> nodeEvents) {
        if (nodeEvents.size() > 0) {
            for (DefaultMutableTreeNode node : this.myLastNodes) {
                if (!(node instanceof StructureNode)) continue;
                ((StructureNode)node).refresh();
            }
            this.myLastNodes.clear();
        }
        for (OutputEventQueue.NodeEvent event : nodeEvents) {
            event = this.intern(event);
            DefaultMutableTreeNode node = this.myCurrentPath.getFirst();
            switch (event.getType()) {
                case 0: {
                    break;
                }
                case 1: {
                    StructureNode child = new StructureNode(event);
                    this.myLastNodes.add(child);
                    int index = this.getChildCount(node) - 1;
                    node.insert(child, node.getChildCount() - 1);
                    child.add(new DefaultMutableTreeNode(PENDING));
                    this.myCurrentPath.addFirst(child);
                    this.nodesWereInserted(node, new int[]{index});
                    break;
                }
                case 2: {
                    if (node instanceof MyRootNode) break;
                }
                case 99: {
                    DefaultMutableTreeNode c = this.myCurrentPath.removeFirst();
                    int childIndex = this.getChildCount(c) - 1;
                    int realChildIndex = c.getChildCount() - 1;
                    if (realChildIndex < 0) break;
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)c.getChildAt(realChildIndex);
                    assert (childNode.getUserObject() == PENDING);
                    c.remove(realChildIndex);
                    this.nodesWereRemoved(c, new int[]{childIndex}, new Object[]{childNode});
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 20: {
                    StructureNode ch = new StructureNode(event);
                    this.myLastNodes.add(ch);
                    int i = this.getChildCount(node) - 1;
                    node.insert(ch, node.getChildCount() - 1);
                    this.nodesWereInserted(node, new int[]{i});
                }
            }
        }
    }

    private OutputEventQueue.NodeEvent intern(OutputEventQueue.NodeEvent event) {
        event.myURI = this.intern(event.myURI);
        event.myQName = this.intern(event.myQName);
        event.myValue = this.intern(event.myValue);
        return event;
    }

    @Nullable
    private OutputEventQueue.NodeEvent.QName intern(OutputEventQueue.NodeEvent.QName name) {
        if (name == null) {
            return null;
        }
        name.myPrefix = this.intern(name.myPrefix);
        name.myLocalName = this.intern(name.myLocalName);
        name.myURI = this.intern(name.myURI);
        return name;
    }

    @Nullable
    private String intern(String s) {
        if (s != null) {
            if (s.length() == 0) {
                return s.intern();
            }
            return (String)this.myInterner.intern((Object)s);
        }
        return null;
    }

    public boolean isFilterWhitespace() {
        return this.myFilterWhitespace;
    }

    public void setFilterWhitespace(boolean b) {
        boolean old = this.myFilterWhitespace;
        this.myFilterWhitespace = b;
        if (b != old) {
            this.nodeStructureChanged((TreeNode)this.getRoot());
        }
    }

    public void finalUpdate(List<OutputEventQueue.NodeEvent> events) {
        Runnable runnable = () -> {
            this.myListenersDisabled = true;
            try {
                this.updateImpl(events);
            }
            finally {
                this.myListenersDisabled = false;
                this.nodeStructureChanged((TreeNode)this.getRoot());
            }
        };
        ApplicationManager.getApplication().invokeLater(runnable);
    }

    @Override
    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.myListenersDisabled) {
            return;
        }
        super.fireTreeNodesChanged(source, path, childIndices, children);
    }

    @Override
    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.myListenersDisabled) {
            return;
        }
        super.fireTreeNodesInserted(source, path, childIndices, children);
    }

    @Override
    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.myListenersDisabled) {
            return;
        }
        super.fireTreeNodesRemoved(source, path, childIndices, children);
    }

    @Override
    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.myListenersDisabled) {
            return;
        }
        super.fireTreeStructureChanged(source, path, childIndices, children);
    }

    public static class StructureNode
    extends DefaultMutableTreeNode
    implements Navigatable {
        private boolean isNew = true;

        public StructureNode(OutputEventQueue.NodeEvent event) {
            super(event);
        }

        private void refresh() {
            this.isNew = false;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public OutputEventQueue.NodeEvent getUserObject() {
            return (OutputEventQueue.NodeEvent)super.getUserObject();
        }

        public void navigate(boolean requestFocus) {
            OutputEventQueue.NodeEvent event = this.getUserObject();
            Project project = (Project)DataManager.getInstance().getDataContext().getData(CommonDataKeys.PROJECT.getName());
            XsltDebuggerSession.openLocation(project, event.getURI(), event.getLineNumber() - 1);
        }

        public boolean canNavigate() {
            return this.getUserObject().getLineNumber() > 0;
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }
    }

    private static class MyRootNode
    extends DefaultMutableTreeNode {
        MyRootNode() {
            super("ROOT");
        }
    }
}

