/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.crypto.generators;

import org.gradle.internal.impldep.org.bouncycastle.crypto.Digest;
import org.gradle.internal.impldep.org.bouncycastle.crypto.digests.Blake2bDigest;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.Argon2Parameters;
import org.gradle.internal.impldep.org.bouncycastle.util.Arrays;
import org.gradle.internal.impldep.org.bouncycastle.util.Pack;
import org.gradle.internal.impldep.org.bouncycastle.util.encoders.Hex;

public class Argon2BytesGenerator {
    private static final int ARGON2_BLOCK_SIZE = 1024;
    private static final int ARGON2_QWORDS_IN_BLOCK = 128;
    private static final int ARGON2_ADDRESSES_IN_BLOCK = 128;
    private static final int ARGON2_PREHASH_DIGEST_LENGTH = 64;
    private static final int ARGON2_PREHASH_SEED_LENGTH = 72;
    private static final int ARGON2_SYNC_POINTS = 4;
    private static final int MIN_PARALLELISM = 1;
    private static final int MAX_PARALLELISM = 0x1000000;
    private static final int MIN_OUTLEN = 4;
    private static final int MIN_ITERATIONS = 1;
    private Block[] memory;
    private int segmentLength;
    private int laneLength;
    private Argon2Parameters parameters;
    private byte[] result;

    public void init(Argon2Parameters argon2Parameters) {
        this.parameters = argon2Parameters;
        if (argon2Parameters.getLanes() < 1) {
            throw new IllegalStateException("lanes must be greater than 1");
        }
        if (argon2Parameters.getLanes() > 0x1000000) {
            throw new IllegalStateException("lanes must be less than 16777216");
        }
        if (argon2Parameters.getMemory() < 2 * argon2Parameters.getLanes()) {
            throw new IllegalStateException("memory is less than: " + 2 * argon2Parameters.getLanes() + " expected " + 2 * argon2Parameters.getLanes());
        }
        if (argon2Parameters.getIterations() < 1) {
            throw new IllegalStateException("iterations is less than: 1");
        }
        this.doInit(argon2Parameters);
    }

    public int generateBytes(char[] cArray, byte[] byArray) {
        return this.generateBytes(this.parameters.getCharToByteConverter().convert(cArray), byArray);
    }

    public int generateBytes(char[] cArray, byte[] byArray, int n, int n2) {
        return this.generateBytes(this.parameters.getCharToByteConverter().convert(cArray), byArray, n, n2);
    }

    public int generateBytes(byte[] byArray, byte[] byArray2) {
        return this.generateBytes(byArray, byArray2, 0, byArray2.length);
    }

    public int generateBytes(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (n2 < 4) {
            throw new IllegalStateException("output length less than 4");
        }
        this.initialize(byArray, n2);
        this.fillMemoryBlocks();
        this.digest(n2);
        System.arraycopy(this.result, 0, byArray2, n, n2);
        this.reset();
        return n2;
    }

    private void reset() {
        for (int i = 0; i < this.memory.length; ++i) {
            Block block = this.memory[i];
            block.clear();
        }
        this.memory = null;
        Arrays.fill(this.result, (byte)0);
    }

    private void doInit(Argon2Parameters argon2Parameters) {
        int n = argon2Parameters.getMemory();
        if (n < 8 * argon2Parameters.getLanes()) {
            n = 8 * argon2Parameters.getLanes();
        }
        this.segmentLength = n / (argon2Parameters.getLanes() * 4);
        this.laneLength = this.segmentLength * 4;
        n = this.segmentLength * (argon2Parameters.getLanes() * 4);
        this.initMemory(n);
    }

    private void initMemory(int n) {
        this.memory = new Block[n];
        for (int i = 0; i < this.memory.length; ++i) {
            this.memory[i] = new Block();
        }
    }

    private void fillMemoryBlocks() {
        FillBlock fillBlock = new FillBlock();
        Position position = new Position();
        for (int i = 0; i < this.parameters.getIterations(); ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < this.parameters.getLanes(); ++k) {
                    position.update(i, k, j, 0);
                    this.fillSegment(fillBlock, position);
                }
            }
        }
    }

    private void fillSegment(FillBlock fillBlock, Position position) {
        Block block = null;
        Block block2 = null;
        Block block3 = null;
        boolean bl = this.isDataIndependentAddressing(position);
        int n = Argon2BytesGenerator.getStartingIndex(position);
        int n2 = position.lane * this.laneLength + position.slice * this.segmentLength + n;
        int n3 = this.getPrevOffset(n2);
        if (bl) {
            block = fillBlock.addressBlock.clear();
            block3 = fillBlock.zeroBlock.clear();
            block2 = fillBlock.inputBlock.clear();
            this.initAddressBlocks(fillBlock, position, block3, block2, block);
        }
        position.index = n;
        while (position.index < this.segmentLength) {
            long l;
            int n4 = this.getRefLane(position, l = this.getPseudoRandom(fillBlock, position, block, block2, block3, n3 = this.rotatePrevOffset(n2, n3), bl));
            int n5 = this.getRefColumn(position, l, n4 == position.lane);
            Block block4 = this.memory[n3];
            Block block5 = this.memory[this.laneLength * n4 + n5];
            Block block6 = this.memory[n2];
            if (this.isWithXor(position)) {
                fillBlock.fillBlockWithXor(block4, block5, block6);
            } else {
                fillBlock.fillBlock(block4, block5, block6);
            }
            ++position.index;
            ++n2;
            ++n3;
        }
    }

    private boolean isDataIndependentAddressing(Position position) {
        return this.parameters.getType() == 1 || this.parameters.getType() == 2 && position.pass == 0 && position.slice < 2;
    }

    private void initAddressBlocks(FillBlock fillBlock, Position position, Block block, Block block2, Block block3) {
        ((Block)block2).v[0] = this.intToLong(position.pass);
        ((Block)block2).v[1] = this.intToLong(position.lane);
        ((Block)block2).v[2] = this.intToLong(position.slice);
        ((Block)block2).v[3] = this.intToLong(this.memory.length);
        ((Block)block2).v[4] = this.intToLong(this.parameters.getIterations());
        ((Block)block2).v[5] = this.intToLong(this.parameters.getType());
        if (position.pass == 0 && position.slice == 0) {
            this.nextAddresses(fillBlock, block, block2, block3);
        }
    }

    private boolean isWithXor(Position position) {
        return position.pass != 0 && this.parameters.getVersion() != 16;
    }

    private int getPrevOffset(int n) {
        if (n % this.laneLength == 0) {
            return n + this.laneLength - 1;
        }
        return n - 1;
    }

    private int rotatePrevOffset(int n, int n2) {
        if (n % this.laneLength == 1) {
            n2 = n - 1;
        }
        return n2;
    }

    private static int getStartingIndex(Position position) {
        if (position.pass == 0 && position.slice == 0) {
            return 2;
        }
        return 0;
    }

    private void nextAddresses(FillBlock fillBlock, Block block, Block block2, Block block3) {
        long[] lArray = block2.v;
        lArray[6] = lArray[6] + 1L;
        fillBlock.fillBlock(block, block2, block3);
        fillBlock.fillBlock(block, block3, block3);
    }

    private long getPseudoRandom(FillBlock fillBlock, Position position, Block block, Block block2, Block block3, int n, boolean bl) {
        if (bl) {
            if (position.index % 128 == 0) {
                this.nextAddresses(fillBlock, block3, block2, block);
            }
            return block.v[position.index % 128];
        }
        return this.memory[n].v[0];
    }

    private int getRefLane(Position position, long l) {
        int n = (int)((l >>> 32) % (long)this.parameters.getLanes());
        if (position.pass == 0 && position.slice == 0) {
            n = position.lane;
        }
        return n;
    }

    private int getRefColumn(Position position, long l, boolean bl) {
        int n;
        int n2;
        if (position.pass == 0) {
            n2 = 0;
            n = bl ? position.slice * this.segmentLength + position.index - 1 : position.slice * this.segmentLength + (position.index == 0 ? -1 : 0);
        } else {
            n2 = (position.slice + 1) * this.segmentLength % this.laneLength;
            n = bl ? this.laneLength - this.segmentLength + position.index - 1 : this.laneLength - this.segmentLength + (position.index == 0 ? -1 : 0);
        }
        long l2 = l & 0xFFFFFFFFL;
        l2 = l2 * l2 >>> 32;
        l2 = (long)(n - 1) - ((long)n * l2 >>> 32);
        return (int)((long)n2 + l2) % this.laneLength;
    }

    private void digest(int n) {
        Block block = this.memory[this.laneLength - 1];
        for (int i = 1; i < this.parameters.getLanes(); ++i) {
            int n2 = i * this.laneLength + (this.laneLength - 1);
            block.xorWith(this.memory[n2]);
        }
        byte[] byArray = block.toBytes();
        this.result = this.hash(byArray, n);
    }

    private byte[] initialHash(Argon2Parameters argon2Parameters, int n, byte[] byArray) {
        Blake2bDigest blake2bDigest = new Blake2bDigest(512);
        Argon2BytesGenerator.addIntToLittleEndian(blake2bDigest, argon2Parameters.getLanes());
        Argon2BytesGenerator.addIntToLittleEndian(blake2bDigest, n);
        Argon2BytesGenerator.addIntToLittleEndian(blake2bDigest, argon2Parameters.getMemory());
        Argon2BytesGenerator.addIntToLittleEndian(blake2bDigest, argon2Parameters.getIterations());
        Argon2BytesGenerator.addIntToLittleEndian(blake2bDigest, argon2Parameters.getVersion());
        Argon2BytesGenerator.addIntToLittleEndian(blake2bDigest, argon2Parameters.getType());
        Argon2BytesGenerator.addByteString(blake2bDigest, byArray);
        Argon2BytesGenerator.addByteString(blake2bDigest, argon2Parameters.getSalt());
        Argon2BytesGenerator.addByteString(blake2bDigest, argon2Parameters.getSecret());
        Argon2BytesGenerator.addByteString(blake2bDigest, argon2Parameters.getAdditional());
        byte[] byArray2 = new byte[blake2bDigest.getDigestSize()];
        blake2bDigest.doFinal(byArray2, 0);
        return byArray2;
    }

    private byte[] hash(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = Pack.intToLittleEndian(n);
        int n2 = 64;
        if (n <= n2) {
            Blake2bDigest blake2bDigest = new Blake2bDigest(n * 8);
            blake2bDigest.update(byArray3, 0, byArray3.length);
            blake2bDigest.update(byArray, 0, byArray.length);
            blake2bDigest.doFinal(byArray2, 0);
        } else {
            Blake2bDigest blake2bDigest = new Blake2bDigest(n2 * 8);
            byte[] byArray4 = new byte[n2];
            blake2bDigest.update(byArray3, 0, byArray3.length);
            blake2bDigest.update(byArray, 0, byArray.length);
            blake2bDigest.doFinal(byArray4, 0);
            System.arraycopy(byArray4, 0, byArray2, 0, n2 / 2);
            int n3 = (n + 31) / 32 - 2;
            int n4 = n2 / 2;
            int n5 = 2;
            while (n5 <= n3) {
                blake2bDigest.update(byArray4, 0, byArray4.length);
                blake2bDigest.doFinal(byArray4, 0);
                System.arraycopy(byArray4, 0, byArray2, n4, n2 / 2);
                ++n5;
                n4 += n2 / 2;
            }
            n5 = n - 32 * n3;
            blake2bDigest = new Blake2bDigest(n5 * 8);
            blake2bDigest.update(byArray4, 0, byArray4.length);
            blake2bDigest.doFinal(byArray2, n4);
        }
        return byArray2;
    }

    private static void roundFunction(Block block, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        Argon2BytesGenerator.F(block, n, n5, n9, n13);
        Argon2BytesGenerator.F(block, n2, n6, n10, n14);
        Argon2BytesGenerator.F(block, n3, n7, n11, n15);
        Argon2BytesGenerator.F(block, n4, n8, n12, n16);
        Argon2BytesGenerator.F(block, n, n6, n11, n16);
        Argon2BytesGenerator.F(block, n2, n7, n12, n13);
        Argon2BytesGenerator.F(block, n3, n8, n9, n14);
        Argon2BytesGenerator.F(block, n4, n5, n10, n15);
    }

    private static void F(Block block, int n, int n2, int n3, int n4) {
        Argon2BytesGenerator.fBlaMka(block, n, n2);
        Argon2BytesGenerator.rotr64(block, n4, n, 32L);
        Argon2BytesGenerator.fBlaMka(block, n3, n4);
        Argon2BytesGenerator.rotr64(block, n2, n3, 24L);
        Argon2BytesGenerator.fBlaMka(block, n, n2);
        Argon2BytesGenerator.rotr64(block, n4, n, 16L);
        Argon2BytesGenerator.fBlaMka(block, n3, n4);
        Argon2BytesGenerator.rotr64(block, n2, n3, 63L);
    }

    private static void fBlaMka(Block block, int n, int n2) {
        long l = (block.v[n] & 0xFFFFFFFFL) * (block.v[n2] & 0xFFFFFFFFL);
        ((Block)block).v[n] = block.v[n] + block.v[n2] + 2L * l;
    }

    private static void rotr64(Block block, int n, int n2, long l) {
        long l2 = block.v[n] ^ block.v[n2];
        ((Block)block).v[n] = l2 >>> (int)l | l2 << (int)(64L - l);
    }

    private void initialize(byte[] byArray, int n) {
        byte[] byArray2 = this.initialHash(this.parameters, n, byArray);
        this.fillFirstBlocks(byArray2);
    }

    private static void addIntToLittleEndian(Digest digest, int n) {
        digest.update((byte)n);
        digest.update((byte)(n >>> 8));
        digest.update((byte)(n >>> 16));
        digest.update((byte)(n >>> 24));
    }

    private static void addByteString(Digest digest, byte[] byArray) {
        if (byArray != null) {
            Argon2BytesGenerator.addIntToLittleEndian(digest, byArray.length);
            digest.update(byArray, 0, byArray.length);
        } else {
            Argon2BytesGenerator.addIntToLittleEndian(digest, 0);
        }
    }

    private void fillFirstBlocks(byte[] byArray) {
        byte[] byArray2 = new byte[]{0, 0, 0, 0};
        byte[] byArray3 = new byte[]{1, 0, 0, 0};
        byte[] byArray4 = this.getInitialHashLong(byArray, byArray2);
        byte[] byArray5 = this.getInitialHashLong(byArray, byArray3);
        for (int i = 0; i < this.parameters.getLanes(); ++i) {
            Pack.intToLittleEndian(i, byArray4, 68);
            Pack.intToLittleEndian(i, byArray5, 68);
            byte[] byArray6 = this.hash(byArray4, 1024);
            this.memory[i * this.laneLength + 0].fromBytes(byArray6);
            byArray6 = this.hash(byArray5, 1024);
            this.memory[i * this.laneLength + 1].fromBytes(byArray6);
        }
    }

    private byte[] getInitialHashLong(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[72];
        System.arraycopy(byArray, 0, byArray3, 0, 64);
        System.arraycopy(byArray2, 0, byArray3, 64, 4);
        return byArray3;
    }

    private long intToLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    private static class Block {
        private static final int SIZE = 128;
        private final long[] v = new long[128];

        private Block() {
        }

        void fromBytes(byte[] byArray) {
            if (byArray.length != 1024) {
                throw new IllegalArgumentException("input shorter than blocksize");
            }
            for (int i = 0; i < 128; ++i) {
                this.v[i] = Pack.littleEndianToLong(byArray, i * 8);
            }
        }

        byte[] toBytes() {
            byte[] byArray = new byte[1024];
            for (int i = 0; i < 128; ++i) {
                Pack.longToLittleEndian(this.v[i], byArray, i * 8);
            }
            return byArray;
        }

        private void copyBlock(Block block) {
            System.arraycopy(block.v, 0, this.v, 0, 128);
        }

        private void xor(Block block, Block block2) {
            for (int i = 0; i < 128; ++i) {
                this.v[i] = block.v[i] ^ block2.v[i];
            }
        }

        public void xor(Block block, Block block2, Block block3) {
            for (int i = 0; i < 128; ++i) {
                this.v[i] = block.v[i] ^ block2.v[i] ^ block3.v[i];
            }
        }

        private void xorWith(Block block) {
            for (int i = 0; i < this.v.length; ++i) {
                this.v[i] = this.v[i] ^ block.v[i];
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < 128; ++i) {
                stringBuffer.append(Hex.toHexString(Pack.longToLittleEndian(this.v[i])));
            }
            return stringBuffer.toString();
        }

        public Block clear() {
            Arrays.fill(this.v, 0L);
            return this;
        }
    }

    private static class FillBlock {
        Block R = new Block();
        Block Z = new Block();
        Block addressBlock = new Block();
        Block zeroBlock = new Block();
        Block inputBlock = new Block();

        private FillBlock() {
        }

        private void applyBlake() {
            int n;
            int n2;
            for (n2 = 0; n2 < 8; ++n2) {
                n = 16 * n2;
                Argon2BytesGenerator.roundFunction(this.Z, n, n + 1, n + 2, n + 3, n + 4, n + 5, n + 6, n + 7, n + 8, n + 9, n + 10, n + 11, n + 12, n + 13, n + 14, n + 15);
            }
            for (n2 = 0; n2 < 8; ++n2) {
                n = 2 * n2;
                Argon2BytesGenerator.roundFunction(this.Z, n, n + 1, n + 16, n + 17, n + 32, n + 33, n + 48, n + 49, n + 64, n + 65, n + 80, n + 81, n + 96, n + 97, n + 112, n + 113);
            }
        }

        private void fillBlock(Block block, Block block2, Block block3) {
            if (block == this.zeroBlock) {
                this.R.copyBlock(block2);
            } else {
                this.R.xor(block, block2);
            }
            this.Z.copyBlock(this.R);
            this.applyBlake();
            block3.xor(this.R, this.Z);
        }

        private void fillBlockWithXor(Block block, Block block2, Block block3) {
            this.R.xor(block, block2);
            this.Z.copyBlock(this.R);
            this.applyBlake();
            block3.xor(this.R, this.Z, block3);
        }
    }

    private static class Position {
        int pass;
        int lane;
        int slice;
        int index;

        Position() {
        }

        void update(int n, int n2, int n3, int n4) {
            this.pass = n;
            this.lane = n2;
            this.slice = n3;
            this.index = n4;
        }
    }
}

