/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.commons.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Stream;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.JUnitException;

@API(status=API.Status.INTERNAL, since="1.1")
public class LogRecordListener {
    private final ThreadLocal<List<LogRecord>> logRecords = ThreadLocal.withInitial(ArrayList::new);

    public void logRecordSubmitted(LogRecord logRecord) {
        this.logRecords.get().add(logRecord);
    }

    public Stream<LogRecord> stream() {
        return this.logRecords.get().stream();
    }

    public Stream<LogRecord> stream(Class<?> clazz) {
        if (clazz == null) {
            throw new JUnitException("Class must not be null");
        }
        return this.stream().filter(logRecord -> logRecord.getLoggerName().equals(clazz.getName()));
    }

    public Stream<LogRecord> stream(Class<?> clazz, Level level) {
        if (level == null) {
            throw new JUnitException("Level must not be null");
        }
        return this.stream(clazz).filter(logRecord -> logRecord.getLevel() == level);
    }

    public void clear() {
        this.logRecords.get().clear();
    }
}

