/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.gradle.internal.impldep.org.junit.platform.engine.TestDescriptor;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.Node;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.NopLock;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.ResourceLock;

class NodeExecutionAdvisor {
    private final Map<TestDescriptor, Node.ExecutionMode> forcedExecutionModeByTestDescriptor = new HashMap<TestDescriptor, Node.ExecutionMode>();
    private final Map<TestDescriptor, ResourceLock> resourceLocksByTestDescriptor = new HashMap<TestDescriptor, ResourceLock>();

    NodeExecutionAdvisor() {
    }

    void forceExecutionMode(TestDescriptor testDescriptor, Node.ExecutionMode executionMode) {
        this.forcedExecutionModeByTestDescriptor.put(testDescriptor, executionMode);
    }

    void useResourceLock(TestDescriptor testDescriptor, ResourceLock resourceLock) {
        this.resourceLocksByTestDescriptor.put(testDescriptor, resourceLock);
    }

    Optional<Node.ExecutionMode> getForcedExecutionMode(TestDescriptor testDescriptor) {
        return Optional.ofNullable(this.forcedExecutionModeByTestDescriptor.get(testDescriptor));
    }

    ResourceLock getResourceLock(TestDescriptor testDescriptor) {
        return this.resourceLocksByTestDescriptor.getOrDefault(testDescriptor, NopLock.INSTANCE);
    }
}

