/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Key;
import com.intellij.util.lang.JavaVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageLevel {
    JDK_1_3(JavaPsiBundle.message("jdk.1.3.language.level.description", new Object[0]), 3),
    JDK_1_4(JavaPsiBundle.message("jdk.1.4.language.level.description", new Object[0]), 4),
    JDK_1_5(JavaPsiBundle.message("jdk.1.5.language.level.description", new Object[0]), 5),
    JDK_1_6(JavaPsiBundle.message("jdk.1.6.language.level.description", new Object[0]), 6),
    JDK_1_7(JavaPsiBundle.message("jdk.1.7.language.level.description", new Object[0]), 7),
    JDK_1_8(JavaPsiBundle.message("jdk.1.8.language.level.description", new Object[0]), 8),
    JDK_1_9(JavaPsiBundle.message("jdk.1.9.language.level.description", new Object[0]), 9),
    JDK_10(JavaPsiBundle.message("jdk.10.language.level.description", new Object[0]), 10),
    JDK_11(JavaPsiBundle.message("jdk.11.language.level.description", new Object[0]), 11),
    JDK_12(JavaPsiBundle.message("jdk.12.language.level.description", new Object[0]), 12),
    JDK_13(JavaPsiBundle.message("jdk.13.language.level.description", new Object[0]), 13),
    JDK_13_PREVIEW(JavaPsiBundle.message("jdk.13.preview.language.level.description", new Object[0]), 13),
    JDK_14(JavaPsiBundle.message("jdk.14.language.level.description", new Object[0]), 14),
    JDK_14_PREVIEW(JavaPsiBundle.message("jdk.14.preview.language.level.description", new Object[0]), 14),
    JDK_X(JavaPsiBundle.message("jdk.X.language.level.description", new Object[0]), 15);

    public static final LanguageLevel HIGHEST;
    public static final Key<LanguageLevel> KEY;
    private final String myPresentableText;
    private final JavaVersion myVersion;
    private final boolean myPreview;

    private LanguageLevel(String presentableText, int major) {
        this.myPresentableText = presentableText;
        this.myVersion = JavaVersion.compose((int)major);
        this.myPreview = this.name().endsWith("_PREVIEW");
    }

    public boolean isPreview() {
        return this.myPreview;
    }

    @NotNull
    @Nls
    public String getPresentableText() {
        String string = this.myPresentableText;
        if (string == null) {
            LanguageLevel.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAtLeast(@NotNull LanguageLevel level) {
        if (level == null) {
            LanguageLevel.$$$reportNull$$$0(1);
        }
        return this.compareTo(level) >= 0;
    }

    public boolean isLessThan(@NotNull LanguageLevel level) {
        if (level == null) {
            LanguageLevel.$$$reportNull$$$0(2);
        }
        return this.compareTo(level) < 0;
    }

    @NotNull
    public JavaVersion toJavaVersion() {
        JavaVersion javaVersion = this.myVersion;
        if (javaVersion == null) {
            LanguageLevel.$$$reportNull$$$0(3);
        }
        return javaVersion;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public String getCompilerComplianceDefaultOption() {
        return this.myVersion.feature <= 8 ? "1." + this.myVersion.feature : String.valueOf(this.myVersion.feature);
    }

    @Nullable
    public static LanguageLevel parse(@Nullable String compilerComplianceOption) {
        JavaSdkVersion sdkVersion;
        if (compilerComplianceOption != null && (sdkVersion = JavaSdkVersion.fromVersionString(compilerComplianceOption)) != null) {
            return sdkVersion.getMaxLanguageLevel();
        }
        return null;
    }

    static {
        HIGHEST = JDK_13;
        KEY = Key.create((String)"LANGUAGE_LEVEL");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/pom/java/LanguageLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/pom/java/LanguageLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toJavaVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isLessThan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

