/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IdFilter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiShortNamesCache {
    public static final ExtensionPointName<PsiShortNamesCache> EP_NAME = ExtensionPointName.create((String)"com.intellij.java.shortNamesCache");

    public static PsiShortNamesCache getInstance(Project project) {
        return (PsiShortNamesCache)ServiceManager.getService((Project)project, PsiShortNamesCache.class);
    }

    public PsiFile @NotNull [] getFilesByName(@NotNull String name) {
        if (name == null) {
            PsiShortNamesCache.$$$reportNull$$$0(0);
        }
        if (PsiFile.EMPTY_ARRAY == null) {
            PsiShortNamesCache.$$$reportNull$$$0(1);
        }
        return PsiFile.EMPTY_ARRAY;
    }

    public String @NotNull [] getAllFileNames() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            PsiShortNamesCache.$$$reportNull$$$0(2);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public abstract PsiClass @NotNull [] getClassesByName(@NotNull @NonNls String var1, @NotNull GlobalSearchScope var2);

    public abstract String @NotNull [] getAllClassNames();

    public boolean processAllClassNames(@NotNull Processor<? super String> processor) {
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(3);
        }
        return ContainerUtil.process((Object[])this.getAllClassNames(), processor);
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(5);
        }
        return ContainerUtil.process((Object[])this.getAllClassNames(), processor);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public void getAllClassNames(@NotNull HashSet<? super String> dest) {
        if (dest == null) {
            PsiShortNamesCache.$$$reportNull$$$0(6);
        }
        this.processAllClassNames((Processor<? super String>)new CommonProcessors.CollectProcessor(dest));
    }

    public abstract PsiMethod @NotNull [] getMethodsByName(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2);

    public abstract PsiMethod @NotNull [] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, int var3);

    public abstract PsiField @NotNull [] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, int var3);

    public abstract boolean processMethodsWithName(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<? super PsiMethod> var3);

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (name == null) {
            PsiShortNamesCache.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(9);
        }
        return this.processMethodsWithName(name, scope, (Processor<? super PsiMethod>)((Processor)method -> processor.process(method)));
    }

    public boolean processAllMethodNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(11);
        }
        return ContainerUtil.process((Object[])this.getAllMethodNames(), processor);
    }

    public boolean processAllFieldNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(13);
        }
        return ContainerUtil.process((Object[])this.getAllFieldNames(), processor);
    }

    public abstract String @NotNull [] getAllMethodNames();

    public abstract PsiField @NotNull [] getFieldsByName(@NotNull @NonNls String var1, @NotNull GlobalSearchScope var2);

    public abstract String @NotNull [] getAllFieldNames();

    public boolean processFieldsWithName(@NotNull String name, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (name == null) {
            PsiShortNamesCache.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(16);
        }
        return ContainerUtil.process((Object[])this.getFieldsByName(name, scope), processor);
    }

    public boolean processClassesWithName(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (name == null) {
            PsiShortNamesCache.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(19);
        }
        return ContainerUtil.process((Object[])this.getClassesByName(name, scope), processor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/PsiShortNamesCache";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/PsiShortNamesCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processAllClassNames";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllClassNames";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsWithName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAllMethodNames";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAllFieldNames";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processFieldsWithName";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processClassesWithName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

