/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.memory.utils.InstanceJavaValue;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.ui.PaintingListener;
import com.intellij.debugger.streams.ui.TraceContainer;
import com.intellij.debugger.streams.ui.ValuesSelectionListener;
import com.intellij.debugger.streams.ui.impl.PrimitiveValueDescriptor;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.Value;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class CollectionTree
extends XDebuggerTree
implements TraceContainer {
    private static final Map<Integer, Color> COLORS_CACHE = new HashMap<Integer, Color>();
    private static final Object NULL_MARKER = ObjectUtils.sentinel((String)"CollectionTree.NULL_MARKER");
    private final NodeManagerImpl myNodeManager;
    private final Project myProject;
    private final Map<TraceElement, TreePath> myValue2Path;
    private final Map<TreePath, TraceElement> myPath2Value;
    private final int myItemsCount;
    private Set<TreePath> myHighlighted;
    private final EventDispatcher<ValuesSelectionListener> mySelectionDispatcher;
    private final EventDispatcher<PaintingListener> myPaintingDispatcher;
    private boolean myIgnoreInternalSelectionEvents;
    private boolean myIgnoreExternalSelectionEvents;

    CollectionTree(@NotNull List<Value> values, final @NotNull List<TraceElement> traceElements, final @NotNull EvaluationContextImpl evaluationContext) {
        if (values == null) {
            CollectionTree.$$$reportNull$$$0(0);
        }
        if (traceElements == null) {
            CollectionTree.$$$reportNull$$$0(1);
        }
        if (evaluationContext == null) {
            CollectionTree.$$$reportNull$$$0(2);
        }
        super(evaluationContext.getProject(), (XDebuggerEditorsProvider)new JavaDebuggerEditorsProvider(), null, "XDebugger.Inspect.Tree.Popup", null);
        this.myValue2Path = new HashMap<TraceElement, TreePath>();
        this.myPath2Value = new HashMap<TreePath, TraceElement>();
        this.myHighlighted = Collections.emptySet();
        this.mySelectionDispatcher = EventDispatcher.create(ValuesSelectionListener.class);
        this.myPaintingDispatcher = EventDispatcher.create(PaintingListener.class);
        this.myIgnoreInternalSelectionEvents = false;
        this.myIgnoreExternalSelectionEvents = false;
        this.myProject = evaluationContext.getProject();
        this.myNodeManager = new MyNodeManager(this.myProject);
        this.myItemsCount = values.size();
        XValueNodeImpl root = new XValueNodeImpl((XDebuggerTree)this, null, "root", (XValue)new MyRootValue(values, evaluationContext));
        this.setRoot((XDebuggerTreeNode)root, false);
        root.setLeaf(false);
        final Map key2TraceElements = StreamEx.of(traceElements).groupingBy(CollectionTree::extractKey);
        final HashMap key2Index = new HashMap(key2TraceElements.size() + 1);
        this.addTreeListener(new XDebuggerTreeListener(){

            public void nodeLoaded(final @NotNull RestorableStateNode node, @NotNull String name) {
                XValueContainer container;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (name == null) {
                    1.$$$reportNull$$$0(1);
                }
                final 1 listener = this;
                if (node instanceof XValueContainerNode && (container = ((XValueContainerNode)node).getValueContainer()) instanceof JavaValue) {
                    final ValueDescriptorImpl descriptor = ((JavaValue)container).getDescriptor();
                    evaluationContext.getDebugProcess().getManagerThread().schedule(new DebuggerCommandImpl(){

                        protected void action() {
                            Value value = descriptor.getValue();
                            ApplicationManager.getApplication().invokeLater(() -> {
                                Object key = value == null ? NULL_MARKER : value;
                                List elements2 = (List)key2TraceElements.get(key);
                                int nextIndex = key2Index.getOrDefault(key, -1) + 1;
                                if (elements2 != null && nextIndex < elements2.size()) {
                                    TraceElement element = (TraceElement)elements2.get(nextIndex);
                                    CollectionTree.this.myValue2Path.put(element, node.getPath());
                                    CollectionTree.this.myPath2Value.put(node.getPath(), element);
                                    key2Index.put(key, nextIndex);
                                }
                                if (CollectionTree.this.myPath2Value.size() == traceElements.size()) {
                                    CollectionTree.this.removeTreeListener(listener);
                                    ApplicationManager.getApplication().invokeLater(() -> CollectionTree.this.repaint());
                                }
                            });
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/streams/ui/impl/CollectionTree$1";
                objectArray[2] = "nodeLoaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.addTreeSelectionListener(e -> {
            if (this.myIgnoreInternalSelectionEvents) {
                return;
            }
            List<TraceElement> selectedItems = TreeUtil.collectSelectedPaths((JTree)((Object)this)).stream().map(this::getTopPath).map(this.myPath2Value::get).filter(Objects::nonNull).collect(Collectors.toList());
            this.fireSelectionChanged(selectedItems);
        });
        this.setSelectionRow(0);
        this.expandNodesOnLoad(node -> node == root);
    }

    CollectionTree(@NotNull List<TraceElement> traceElements, @NotNull EvaluationContextImpl evaluationContext) {
        if (traceElements == null) {
            CollectionTree.$$$reportNull$$$0(3);
        }
        if (evaluationContext == null) {
            CollectionTree.$$$reportNull$$$0(4);
        }
        this(ContainerUtil.map(traceElements, TraceElement::getValue), traceElements, evaluationContext);
    }

    public boolean isFileColorsEnabled() {
        return true;
    }

    @Nullable
    public Color getFileColorForPath(@NotNull TreePath path) {
        if (path == null) {
            CollectionTree.$$$reportNull$$$0(5);
        }
        if (this.isPathHighlighted(path)) {
            Color background = UIUtil.getTreeSelectionBackground((boolean)true);
            return COLORS_CACHE.computeIfAbsent(background.getRGB(), rgb -> new JBColor(new Color(background.getRed(), background.getGreen(), background.getBlue(), 75), new Color(background.getRed(), background.getGreen(), background.getBlue(), 100)));
        }
        return UIUtil.getTreeBackground();
    }

    public void clearSelection() {
        this.myIgnoreInternalSelectionEvents = true;
        super.clearSelection();
        this.myIgnoreInternalSelectionEvents = false;
    }

    @Nullable
    public Rectangle getRectByValue(@NotNull TraceElement element) {
        TreePath path;
        if (element == null) {
            CollectionTree.$$$reportNull$$$0(6);
        }
        return (path = this.myValue2Path.get(element)) == null ? null : this.getPathBounds(path);
    }

    @Override
    public void highlight(@NotNull List<TraceElement> elements2) {
        if (elements2 == null) {
            CollectionTree.$$$reportNull$$$0(7);
        }
        this.clearSelection();
        this.highlightValues(elements2);
        this.tryScrollTo(elements2);
        this.updatePresentation();
    }

    @Override
    public void select(@NotNull List<TraceElement> elements2) {
        if (elements2 == null) {
            CollectionTree.$$$reportNull$$$0(8);
        }
        TreePath[] paths = (TreePath[])elements2.stream().map(this.myValue2Path::get).toArray(TreePath[]::new);
        this.select(paths);
        this.highlightValues(elements2);
        if (paths.length > 0) {
            this.scrollPathToVisible(paths[0]);
        }
        this.updatePresentation();
    }

    @Override
    public void addSelectionListener(@NotNull ValuesSelectionListener listener) {
        if (listener == null) {
            CollectionTree.$$$reportNull$$$0(9);
        }
        this.mySelectionDispatcher.addListener((EventListener)listener);
    }

    @Override
    public boolean highlightedExists() {
        return !this.isSelectionEmpty() || !this.myHighlighted.isEmpty();
    }

    public int getItemsCount() {
        return this.myItemsCount;
    }

    public void addPaintingListener(@NotNull PaintingListener listener) {
        if (listener == null) {
            CollectionTree.$$$reportNull$$$0(10);
        }
        this.myPaintingDispatcher.addListener((EventListener)listener);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((PaintingListener)this.myPaintingDispatcher.getMulticaster()).componentPainted();
    }

    private void select(TreePath @NotNull [] paths) {
        if (paths == null) {
            CollectionTree.$$$reportNull$$$0(11);
        }
        if (this.myIgnoreExternalSelectionEvents) {
            return;
        }
        this.myIgnoreInternalSelectionEvents = true;
        this.getSelectionModel().setSelectionPaths(paths);
        this.myIgnoreInternalSelectionEvents = false;
    }

    private void fireSelectionChanged(List<TraceElement> selectedItems) {
        this.myIgnoreExternalSelectionEvents = true;
        ((ValuesSelectionListener)this.mySelectionDispatcher.getMulticaster()).selectionChanged(selectedItems);
        this.myIgnoreExternalSelectionEvents = false;
    }

    private void tryScrollTo(@NotNull List<TraceElement> elements2) {
        if (elements2 == null) {
            CollectionTree.$$$reportNull$$$0(12);
        }
        int[] rows = elements2.stream().map(this.myValue2Path::get).filter(Objects::nonNull).mapToInt(arg_0 -> this.getRowForPath(arg_0)).sorted().toArray();
        if (rows.length == 0) {
            return;
        }
        if (this.isShowing()) {
            Rectangle bestVisibleArea = this.optimizeRowsCountInVisibleRect(rows);
            Rectangle visibleRect = this.getVisibleRect();
            boolean notVisibleHighlightedRowExists = Arrays.stream(rows).anyMatch(x -> !visibleRect.intersects(this.getRowBounds(x)));
            if (notVisibleHighlightedRowExists) {
                this.scrollRectToVisible(bestVisibleArea);
            }
        } else {
            this.scrollPathToVisible(this.getPathForRow(rows[0]));
        }
    }

    @NotNull
    private Rectangle optimizeRowsCountInVisibleRect(int @NotNull [] rows) {
        if (rows == null) {
            CollectionTree.$$$reportNull$$$0(13);
        }
        Rectangle visibleRect = this.getVisibleRect();
        int height = visibleRect.height;
        int topIndex = 0;
        Rectangle rowBounds = this.getRowBounds(rows[topIndex]);
        if (rowBounds == null) {
            Rectangle rectangle = visibleRect;
            if (rectangle == null) {
                CollectionTree.$$$reportNull$$$0(14);
            }
            return rectangle;
        }
        int topY = rowBounds.y;
        class Result {
            private int top = 0;
            private int bot = 0;

            Result() {
            }

            @Contract(pure=true)
            private int count() {
                return this.bot - this.top;
            }
        }
        Result result = new Result();
        for (int bottomIndex = 1; bottomIndex < rows.length; ++bottomIndex) {
            int nextY = this.getRowBounds((int)rows[bottomIndex]).y;
            while (nextY - topY > height) {
                if ((rowBounds = this.getRowBounds(rows[++topIndex])) == null) {
                    Rectangle rectangle = visibleRect;
                    if (rectangle == null) {
                        CollectionTree.$$$reportNull$$$0(15);
                    }
                    return rectangle;
                }
                topY = rowBounds.y;
            }
            if (bottomIndex - topIndex <= result.count()) continue;
            result.top = topIndex;
            result.bot = bottomIndex;
        }
        int y = this.getRowBounds((int)rows[((Result)result).top]).y;
        if (y > visibleRect.y) {
            Rectangle botBounds = this.getRowBounds(rows[result.bot]);
            y = botBounds.y + botBounds.height - visibleRect.height;
        }
        return new Rectangle(visibleRect.x, y, visibleRect.width, height);
    }

    private void highlightValues(@NotNull List<TraceElement> elements2) {
        if (elements2 == null) {
            CollectionTree.$$$reportNull$$$0(16);
        }
        this.myHighlighted = elements2.stream().map(this.myValue2Path::get).collect(Collectors.toSet());
    }

    private void updatePresentation() {
        this.revalidate();
        this.repaint();
    }

    public boolean isHighlighted(@NotNull TraceElement traceElement) {
        TreePath path;
        if (traceElement == null) {
            CollectionTree.$$$reportNull$$$0(17);
        }
        return (path = this.myValue2Path.get(traceElement)) != null && this.isPathHighlighted(path);
    }

    private boolean isPathHighlighted(@NotNull TreePath path) {
        if (path == null) {
            CollectionTree.$$$reportNull$$$0(18);
        }
        return this.myHighlighted.contains(path) || this.isPathSelected(path);
    }

    @NotNull
    private TreePath getTopPath(@NotNull TreePath path) {
        TreePath current;
        if (path == null) {
            CollectionTree.$$$reportNull$$$0(19);
        }
        for (current = path; current != null && !this.myPath2Value.containsKey(current); current = current.getParentPath()) {
        }
        TreePath treePath = current != null ? current : path;
        if (treePath == null) {
            CollectionTree.$$$reportNull$$$0(20);
        }
        return treePath;
    }

    private static Object extractKey(@NotNull TraceElement element) {
        Value value;
        if (element == null) {
            CollectionTree.$$$reportNull$$$0(21);
        }
        return (value = element.getValue()) == null ? NULL_MARKER : value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceElements";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 5: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 14: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/ui/impl/CollectionTree";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/ui/impl/CollectionTree";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeRowsCountInVisibleRect";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileColorForPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRectByValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addPaintingListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryScrollTo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "optimizeRowsCountInVisibleRect";
                break;
            }
            case 14: 
            case 15: 
            case 20: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "highlightValues";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighted";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isPathHighlighted";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTopPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extractKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyNodeManager
    extends NodeManagerImpl {
        MyNodeManager(Project project) {
            super(project, null);
        }

        public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor, EvaluationContext evaluationContext) {
            return new DebuggerTreeNodeImpl(null, descriptor);
        }

        public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor) {
            return new DebuggerTreeNodeImpl(null, (NodeDescriptor)descriptor);
        }

        public DebuggerTreeNodeImpl createMessageNode(String message) {
            return new DebuggerTreeNodeImpl(null, (NodeDescriptor)new MessageDescriptor(message));
        }
    }

    private class MyRootValue
    extends XValue {
        private final List<Value> myValues;
        private final EvaluationContextImpl myEvaluationContext;

        MyRootValue(@NotNull List<Value> values, EvaluationContextImpl evaluationContext) {
            if (values == null) {
                MyRootValue.$$$reportNull$$$0(0);
            }
            if (evaluationContext == null) {
                MyRootValue.$$$reportNull$$$0(1);
            }
            this.myValues = values;
            this.myEvaluationContext = evaluationContext;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                MyRootValue.$$$reportNull$$$0(2);
            }
            XValueChildrenList children = new XValueChildrenList();
            for (Value value : this.myValues) {
                PrimitiveValueDescriptor valueDescriptor = new PrimitiveValueDescriptor(CollectionTree.this.myProject, value);
                children.add((XNamedValue)new InstanceJavaValue((ValueDescriptorImpl)valueDescriptor, this.myEvaluationContext, CollectionTree.this.myNodeManager));
            }
            node.addChildren(children, true);
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                MyRootValue.$$$reportNull$$$0(3);
            }
            if (place == null) {
                MyRootValue.$$$reportNull$$$0(4);
            }
            node.setPresentation(null, "", "", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluationContext";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/streams/ui/impl/CollectionTree$MyRootValue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeChildren";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

