/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.Collections;
import javax.swing.Icon;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.resolve.GrammarFactory;
import org.intellij.plugins.relaxNG.model.resolve.RelaxSymbolIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoSymbolContributor
implements ChooseByNameContributorEx {
    public void processNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            GotoSymbolContributor.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            GotoSymbolContributor.$$$reportNull$$$0(1);
        }
        FileBasedIndex.getInstance().processAllKeys(RelaxSymbolIndex.NAME, processor, scope, filter);
    }

    public void processElementsWithName(final @NotNull String name, final @NotNull Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        if (name == null) {
            GotoSymbolContributor.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            GotoSymbolContributor.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            GotoSymbolContributor.$$$reportNull$$$0(4);
        }
        final boolean[] result = new boolean[]{true};
        PsiManager psiManager = PsiManager.getInstance((Project)parameters.getProject());
        FileBasedIndex.getInstance().getFilesWithKey(RelaxSymbolIndex.NAME, Collections.singleton(name), file -> {
            Grammar grammar;
            PsiFile psiFile = psiManager.findFile(file);
            Grammar grammar2 = grammar = psiFile instanceof XmlFile ? GrammarFactory.getGrammar((XmlFile)psiFile) : null;
            if (grammar == null) {
                return true;
            }
            grammar.acceptChildren(new CommonElement.Visitor(){

                @Override
                public void visitDefine(Define define) {
                    if (!result[0]) {
                        return;
                    }
                    if (name.equals(define.getName())) {
                        NavigationItem wrapped = GotoSymbolContributor.wrap(define.getPsiElement());
                        result[0] = wrapped == null || processor.process((Object)wrapped);
                    }
                }
            });
            return result[0];
        }, parameters.getSearchScope());
    }

    @Nullable
    static NavigationItem wrap(final @Nullable PsiElement item) {
        if (!(item instanceof NavigationItem)) {
            return null;
        }
        PsiMetaData metaData0 = item instanceof PsiMetaOwner ? ((PsiMetaOwner)item).getMetaData() : null;
        final PsiPresentableMetaData metaData = metaData0 instanceof PsiPresentableMetaData ? (PsiPresentableMetaData)metaData0 : null;
        ColoredItemPresentation presentation = metaData != null ? new ColoredItemPresentation(){

            public String getPresentableText() {
                return metaData.getName();
            }

            @NotNull
            public String getLocationString() {
                String string = MyNavigationItem.getLocationString(item);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public Icon getIcon(boolean open) {
                return metaData.getIcon();
            }

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                ItemPresentation p = ((NavigationItem)item).getPresentation();
                return p instanceof ColoredItemPresentation ? ((ColoredItemPresentation)p).getTextAttributesKey() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/GotoSymbolContributor$2", "getLocationString"));
            }
        } : ((NavigationItem)item).getPresentation();
        return presentation == null ? null : new MyNavigationItem((NavigationItem)item, (ItemPresentation)presentation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/relaxNG/GotoSymbolContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementsWithName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyNavigationItem
    implements PsiElementNavigationItem,
    ItemPresentation {
        final NavigationItem myItem;
        final ItemPresentation myPresentation;

        private MyNavigationItem(NavigationItem item, @NotNull ItemPresentation presentation) {
            if (presentation == null) {
                MyNavigationItem.$$$reportNull$$$0(0);
            }
            this.myItem = item;
            this.myPresentation = presentation;
        }

        public String getPresentableText() {
            return this.myPresentation.getPresentableText();
        }

        @Nullable
        public String getLocationString() {
            return MyNavigationItem.getLocationString((PsiElement)this.myItem);
        }

        private static String getLocationString(PsiElement element) {
            return "(in " + element.getContainingFile().getName() + ")";
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return this.myPresentation.getIcon(open);
        }

        @Nullable
        public TextAttributesKey getTextAttributesKey() {
            return this.myPresentation instanceof ColoredItemPresentation ? ((ColoredItemPresentation)this.myPresentation).getTextAttributesKey() : null;
        }

        public String getName() {
            return this.myItem.getName();
        }

        public ItemPresentation getPresentation() {
            return this;
        }

        public PsiElement getTargetElement() {
            return (PsiElement)this.myItem;
        }

        public void navigate(boolean requestFocus) {
            this.myItem.navigate(requestFocus);
        }

        public boolean canNavigate() {
            return this.myItem.canNavigate();
        }

        public boolean canNavigateToSource() {
            return this.myItem.canNavigateToSource();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "org/intellij/plugins/relaxNG/GotoSymbolContributor$MyNavigationItem", "<init>"));
        }
    }
}

