/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util.importProject;

import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.JavaProjectStructureDetector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import com.intellij.remoteServer.util.importProject.CloudGitChooseAccountStepImpl;
import com.intellij.remoteServer.util.importProject.CloudGitJavaSourceRoot;
import com.intellij.remoteServer.util.importProject.CloudGitProjectRoot;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CloudGitProjectStructureDetector
extends ProjectStructureDetector {
    private final JavaProjectStructureDetector myJavaDetector = new JavaProjectStructureDetector();

    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, File @NotNull [] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            CloudGitProjectStructureDetector.$$$reportNull$$$0(0);
        }
        if (base == null) {
            CloudGitProjectStructureDetector.$$$reportNull$$$0(1);
        }
        if (result == null) {
            CloudGitProjectStructureDetector.$$$reportNull$$$0(2);
        }
        if (children == null) {
            CloudGitProjectStructureDetector.$$$reportNull$$$0(3);
        }
        CloudGitProjectStructureDetector.detectApplicationRoot(dir, result);
        for (DetectedProjectRoot projectRoot : result) {
            if (!(projectRoot instanceof CloudGitProjectRoot) || !FileUtil.isAncestor((File)projectRoot.getDirectory(), (File)dir, (boolean)true)) continue;
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = this.detectJavaRoots(((CloudGitProjectRoot)projectRoot).getJavaSourceRootTypeName(), dir, children, base, result);
            if (directoryProcessingResult == null) {
                CloudGitProjectStructureDetector.$$$reportNull$$$0(4);
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            CloudGitProjectStructureDetector.$$$reportNull$$$0(5);
        }
        return directoryProcessingResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void detectApplicationRoot(@NotNull File dir, @NotNull List<? super DetectedProjectRoot> result) {
        VirtualFile repositoryRoot;
        if (dir == null) {
            CloudGitProjectStructureDetector.$$$reportNull$$$0(6);
        }
        if (result == null) {
            CloudGitProjectStructureDetector.$$$reportNull$$$0(7);
        }
        if ((repositoryRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir)) == null) {
            return;
        }
        if (GitUtil.findGitDir((VirtualFile)repositoryRoot) == null) {
            return;
        }
        Disposable disposable = Disposer.newDisposable();
        try {
            Project project = ProjectManager.getInstance().getDefaultProject();
            GitRepository repository = GitRepositoryImpl.createInstance((VirtualFile)repositoryRoot, (Project)project, (Disposable)disposable, (boolean)false);
            for (CloudGitDeploymentDetector deploymentDetector : (CloudGitDeploymentDetector[])CloudGitDeploymentDetector.EP_NAME.getExtensions()) {
                String applicationName = deploymentDetector.getFirstApplicationName(repository);
                if (applicationName == null) continue;
                result.add(new CloudGitProjectRoot(deploymentDetector, dir, repositoryRoot, applicationName));
            }
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    private ProjectStructureDetector.DirectoryProcessingResult detectJavaRoots(String javaSourceRootTypeName, @NotNull File dir, File @NotNull [] children, @NotNull File base, @NotNull List<? super DetectedProjectRoot> result) {
        if (dir == null) {
            CloudGitProjectStructureDetector.$$$reportNull$$$0(8);
        }
        if (base == null) {
            CloudGitProjectStructureDetector.$$$reportNull$$$0(9);
        }
        if (result == null) {
            CloudGitProjectStructureDetector.$$$reportNull$$$0(10);
        }
        if (children == null) {
            CloudGitProjectStructureDetector.$$$reportNull$$$0(11);
        }
        ArrayList detectedJavaRoots = new ArrayList();
        ProjectStructureDetector.DirectoryProcessingResult processingResult = this.myJavaDetector.detectRoots(dir, children, base, detectedJavaRoots);
        for (DetectedProjectRoot detectedJavaRoot : detectedJavaRoots) {
            if (!(detectedJavaRoot instanceof JavaModuleSourceRoot)) continue;
            result.add((DetectedProjectRoot)new CloudGitJavaSourceRoot(javaSourceRootTypeName, (JavaModuleSourceRoot)detectedJavaRoot));
        }
        return processingResult;
    }

    public List<ModuleWizardStep> createWizardSteps(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, Icon stepIcon) {
        ArrayList<ModuleWizardStep> result = new ArrayList<ModuleWizardStep>();
        for (CloudGitDeploymentDetector deploymentDetector : (CloudGitDeploymentDetector[])CloudGitDeploymentDetector.EP_NAME.getExtensions()) {
            result.add(new CloudGitChooseAccountStepImpl(deploymentDetector, this, builder, projectDescriptor));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectRoots";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectApplicationRoot";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detectJavaRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

