/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.util.containers.ConcurrentMultiMap;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005J\"\u0010\f\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u000b\u001a\u00020\u0005J\"\u0010\u000e\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u000b\u001a\u00020\u0005R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogNotificationService;", "", "()V", "subscribers", "Lcom/intellij/util/containers/ConcurrentMultiMap;", "", "Lkotlin/Function1;", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "", "notifySubscribers", "logEvent", "recorderId", "subscribe", "subscriber", "unsubscribe", "intellij.platform.statistics"})
public final class EventLogNotificationService {
    private static final ConcurrentMultiMap<String, Function1<LogEvent, Unit>> subscribers;
    public static final EventLogNotificationService INSTANCE;

    public final void notifySubscribers(@NotNull LogEvent logEvent, @NotNull String recorderId) {
        Intrinsics.checkParameterIsNotNull((Object)logEvent, (String)"logEvent");
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        Collection collection = subscribers.get((Object)recorderId);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"subscribers[recorderId]");
        Collection copyOnWriteArraySet = collection;
        for (Function1 onLogEvent : copyOnWriteArraySet) {
            onLogEvent.invoke((Object)logEvent);
        }
    }

    public final void subscribe(@NotNull Function1<? super LogEvent, Unit> subscriber, @NotNull String recorderId) {
        Intrinsics.checkParameterIsNotNull(subscriber, (String)"subscriber");
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        subscribers.putValue((Object)recorderId, subscriber);
    }

    public final void unsubscribe(@NotNull Function1<? super LogEvent, Unit> subscriber, @NotNull String recorderId) {
        Intrinsics.checkParameterIsNotNull(subscriber, (String)"subscriber");
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        subscribers.remove((Object)recorderId, subscriber);
    }

    private EventLogNotificationService() {
    }

    static {
        EventLogNotificationService eventLogNotificationService;
        INSTANCE = eventLogNotificationService = new EventLogNotificationService();
        subscribers = new ConcurrentMultiMap();
    }
}

