/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.whitelist;

import com.intellij.internal.statistic.eventLog.EventLogBuildNumber;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.WhiteListGroupRules;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistGroupRulesStorage;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseWhitelistStorage
implements WhitelistGroupRulesStorage {
    @NotNull
    protected final AtomicBoolean isWhiteListInitialized = new AtomicBoolean(false);

    protected BaseWhitelistStorage() {
    }

    @Override
    public boolean isUnreachableWhitelist() {
        return !this.isWhiteListInitialized.get();
    }

    @NotNull
    protected Map<String, WhiteListGroupRules> createValidators(@NotNull FUStatisticsWhiteListGroupsService.WLGroups groups) {
        if (groups == null) {
            BaseWhitelistStorage.$$$reportNull$$$0(0);
        }
        EventLogBuildNumber buildNumber = EventLogBuildNumber.fromString((String)EventLogConfiguration.INSTANCE.getBuild());
        Map<String, WhiteListGroupRules> map = groups.groups.stream().filter(group -> group.accepts(buildNumber)).collect(Collectors.toMap(group -> group.id, group -> BaseWhitelistStorage.createRules(group, groups.rules)));
        if (map == null) {
            BaseWhitelistStorage.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    protected static WhiteListGroupRules createRules(@NotNull FUStatisticsWhiteListGroupsService.WLGroup group, @Nullable FUStatisticsWhiteListGroupsService.WLRule globalRules) {
        if (group == null) {
            BaseWhitelistStorage.$$$reportNull$$$0(2);
        }
        WhiteListGroupRules whiteListGroupRules = globalRules != null ? WhiteListGroupRules.create(group, globalRules.enums, globalRules.regexps) : WhiteListGroupRules.create(group, null, null);
        if (whiteListGroupRules == null) {
            BaseWhitelistStorage.$$$reportNull$$$0(3);
        }
        return whiteListGroupRules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/whitelist/BaseWhitelistStorage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/whitelist/BaseWhitelistStorage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createValidators";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createValidators";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

