/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.eventLog.DeviceConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogInternalApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogInternalRecorderConfig;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfig;
import com.intellij.internal.statistic.eventLog.EventLogSendListener;
import com.intellij.internal.statistic.eventLog.EventLogStatisticsService;
import com.intellij.internal.statistic.eventLog.EventLogSystemLogger;
import com.intellij.internal.statistic.eventLog.EventLogUploadSettingsService;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class StatisticsUploadAssistant {
    private static final String IDEA_SUPPRESS_REPORT_STATISTICS = "idea.suppress.statistics.report";
    private static final String ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT = "idea.local.statistics.without.report";
    public static final Object LOCK = new Object();

    private StatisticsUploadAssistant() {
    }

    public static long getSendPeriodInMillis() {
        return UsageStatisticsPersistenceComponent.getInstance().getPeriod().getMillis();
    }

    public static boolean isTimeToSend() {
        return StatisticsUploadAssistant.isTimeToSend(UsageStatisticsPersistenceComponent.getInstance());
    }

    public static boolean isTimeToSend(UsageStatisticsPersistenceComponent settings) {
        long timeDelta = System.currentTimeMillis() - settings.getLastTimeSent();
        return Math.abs(timeDelta) > settings.getPeriod().getMillis();
    }

    public static boolean isSendAllowed() {
        return StatisticsUploadAssistant.isSendAllowed(UsageStatisticsPersistenceComponent.getInstance());
    }

    public static boolean isSendAllowed(UsageStatisticsPersistenceComponent settings) {
        return settings != null && settings.isAllowed() && !Boolean.getBoolean(IDEA_SUPPRESS_REPORT_STATISTICS) && !Boolean.getBoolean(ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT);
    }

    public static boolean isCollectAllowed() {
        UsageStatisticsPersistenceComponent settings = UsageStatisticsPersistenceComponent.getInstance();
        return settings != null && settings.isAllowed() || Boolean.getBoolean(ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT);
    }

    public static boolean isTestStatisticsEnabled() {
        return Boolean.getBoolean(ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT) || StringUtil.isNotEmpty((String)System.getenv("TEAMCITY_VERSION"));
    }

    public static void updateSentTime() {
        UsageStatisticsPersistenceComponent.getInstance().setSentTime(System.currentTimeMillis());
    }

    @NotNull
    public static StatisticsService getEventLogStatisticsService(final @NotNull String recorderId) {
        if (recorderId == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(0);
        }
        EventLogSendListener listener = new EventLogSendListener(){

            public void onLogsSend(int succeed, int failed, int totalLocalFiles) {
                EventLogSystemLogger.logFilesSend(recorderId, totalLocalFiles, succeed, failed, false);
            }
        };
        return new EventLogStatisticsService(new DeviceConfiguration(EventLogConfiguration.INSTANCE.getDeviceId(), EventLogConfiguration.INSTANCE.getBucket()), (EventLogRecorderConfig)new EventLogInternalRecorderConfig(recorderId), (EventLogApplicationInfo)new EventLogInternalApplicationInfo(recorderId, false), listener);
    }

    public static EventLogUploadSettingsService createExternalSettings(@NotNull String recorderId, boolean isTest) {
        if (recorderId == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(1);
        }
        return new EventLogUploadSettingsService(recorderId, (EventLogApplicationInfo)new EventLogInternalApplicationInfo(recorderId, isTest));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "recorderId";
        objectArray2[1] = "com/intellij/internal/statistic/utils/StatisticsUploadAssistant";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getEventLogStatisticsService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createExternalSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

