/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPluginDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugins;
import org.jetbrains.idea.maven.dom.model.MavenDomProfile;
import org.jetbrains.idea.maven.dom.model.MavenDomProfiles;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.model.MavenDomSettingsModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenParentDesc;
import org.jetbrains.idea.maven.project.MavenParentProjectFileProcessor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenDomProjectProcessorUtils {
    private MavenDomProjectProcessorUtils() {
    }

    @NotNull
    public static Set<MavenDomProjectModel> getChildrenProjects(@NotNull MavenDomProjectModel model) {
        if (model == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(0);
        }
        HashSet<MavenDomProjectModel> models = new HashSet<MavenDomProjectModel>();
        MavenDomProjectProcessorUtils.collectChildrenProjects(model, models);
        HashSet<MavenDomProjectModel> hashSet = models;
        if (hashSet == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static void collectChildrenProjects(@NotNull MavenDomProjectModel model, @NotNull Set<? super MavenDomProjectModel> models) {
        MavenProject mavenProject;
        if (model == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(2);
        }
        if (models == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(3);
        }
        if ((mavenProject = MavenDomUtil.findProject(model)) != null) {
            Project project = model.getManager().getProject();
            for (MavenProject inheritor : MavenProjectsManager.getInstance(project).findInheritors(mavenProject)) {
                MavenDomProjectModel inheritorProjectModel = MavenDomUtil.getMavenDomProjectModel(project, inheritor.getFile());
                if (inheritorProjectModel == null || models.contains(inheritorProjectModel)) continue;
                models.add(inheritorProjectModel);
                MavenDomProjectProcessorUtils.collectChildrenProjects(inheritorProjectModel, models);
            }
        }
    }

    @NotNull
    public static Set<MavenDomProjectModel> collectParentProjects(@NotNull MavenDomProjectModel projectDom) {
        if (projectDom == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(4);
        }
        HashSet<MavenDomProjectModel> parents = new HashSet<MavenDomProjectModel>();
        Processor collectProcessor = model -> {
            parents.add((MavenDomProjectModel)model);
            return false;
        };
        MavenDomProjectProcessorUtils.processParentProjects(projectDom, (Processor<? super MavenDomProjectModel>)collectProcessor);
        HashSet<MavenDomProjectModel> hashSet = parents;
        if (hashSet == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    public static void processParentProjects(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<? super MavenDomProjectModel> processor) {
        if (projectDom == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(7);
        }
        HashSet<MavenDomProjectModel> processed = new HashSet<MavenDomProjectModel>();
        Project project = projectDom.getManager().getProject();
        MavenDomProjectModel parent = MavenDomProjectProcessorUtils.findParent(projectDom, project);
        while (parent != null && !processed.contains(parent)) {
            processed.add(parent);
            if (processor.process((Object)parent)) break;
            parent = MavenDomProjectProcessorUtils.findParent(parent, project);
        }
    }

    @Nullable
    public static MavenDomProjectModel findParent(@NotNull MavenDomProjectModel model, Project project) {
        if (model == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(8);
        }
        return MavenDomProjectProcessorUtils.findParent(model.getMavenParent(), project);
    }

    @Nullable
    public static MavenDomProjectModel findParent(@NotNull MavenDomParent mavenDomParent, Project project) {
        if (mavenDomParent == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(9);
        }
        if (!DomUtil.hasXml((DomElement)mavenDomParent)) {
            return null;
        }
        MavenId id = new MavenId(mavenDomParent.getGroupId().getStringValue(), mavenDomParent.getArtifactId().getStringValue(), mavenDomParent.getVersion().getStringValue());
        MavenProject mavenProject = MavenProjectsManager.getInstance(project).findProject(id);
        return mavenProject != null ? MavenDomUtil.getMavenDomProjectModel(project, mavenProject.getFile()) : null;
    }

    @Nullable
    public static XmlTag searchProperty(final @NotNull String propertyName, @NotNull MavenDomProjectModel projectDom, @NotNull Project project) {
        if (propertyName == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(10);
        }
        if (projectDom == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(11);
        }
        if (project == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(12);
        }
        SearchProcessor<XmlTag, MavenDomProperties> searchProcessor = new SearchProcessor<XmlTag, MavenDomProperties>(){

            @Override
            protected XmlTag find(MavenDomProperties element) {
                return MavenDomProjectProcessorUtils.findProperty(element, propertyName);
            }
        };
        MavenDomProjectProcessorUtils.processProperties(projectDom, (Processor<MavenDomProperties>)searchProcessor, project);
        return (XmlTag)((SearchProcessor)searchProcessor).myResult;
    }

    @Nullable
    public static XmlTag findProperty(@NotNull MavenDomProperties mavenDomProperties, @NotNull String propertyName) {
        XmlTag propertiesTag;
        if (mavenDomProperties == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(13);
        }
        if (propertyName == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(14);
        }
        if ((propertiesTag = mavenDomProperties.getXmlTag()) == null) {
            return null;
        }
        for (XmlTag each : propertiesTag.getSubTags()) {
            if (!each.getName().equals(propertyName)) continue;
            return each;
        }
        return null;
    }

    public static Set<XmlTag> collectProperties(@NotNull MavenDomProjectModel projectDom, @NotNull Project project) {
        if (projectDom == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(15);
        }
        if (project == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(16);
        }
        HashSet<XmlTag> properties = new HashSet<XmlTag>();
        Processor collectProcessor = mavenDomProperties -> {
            XmlTag propertiesTag = mavenDomProperties.getXmlTag();
            if (propertiesTag != null) {
                ContainerUtil.addAll((Collection)properties, (Object[])propertiesTag.getSubTags());
            }
            return false;
        };
        MavenDomProjectProcessorUtils.processProperties(projectDom, (Processor<MavenDomProperties>)collectProcessor, project);
        return properties;
    }

    @NotNull
    public static Set<MavenDomDependency> searchDependencyUsages(@NotNull MavenDomDependency dependency) {
        DependencyConflictId dependencyId;
        MavenDomProjectModel model;
        if (dependency == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(17);
        }
        if ((model = (MavenDomProjectModel)dependency.getParentOfType(MavenDomProjectModel.class, false)) != null && (dependencyId = DependencyConflictId.create(dependency)) != null) {
            return MavenDomProjectProcessorUtils.searchDependencyUsages(model, dependencyId, Collections.singleton(dependency));
        }
        Set<MavenDomDependency> set = Collections.emptySet();
        if (set == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(18);
        }
        return set;
    }

    @NotNull
    public static Set<MavenDomDependency> searchDependencyUsages(@NotNull MavenDomProjectModel model, @NotNull DependencyConflictId dependencyId, @NotNull Set<MavenDomDependency> excludes) {
        if (model == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(19);
        }
        if (dependencyId == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(20);
        }
        if (excludes == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(21);
        }
        Project project = model.getManager().getProject();
        HashSet<MavenDomDependency> usages = new HashSet<MavenDomDependency>();
        Processor collectProcessor = mavenDomProjectModel -> {
            for (MavenDomDependency domDependency : mavenDomProjectModel.getDependencies().getDependencies()) {
                if (excludes.contains(domDependency) || !dependencyId.equals(DependencyConflictId.create(domDependency))) continue;
                usages.add(domDependency);
            }
            return false;
        };
        MavenDomProjectProcessorUtils.processChildrenRecursively(model, (Processor<? super MavenDomProjectModel>)collectProcessor, project, new HashSet(), true);
        HashSet<MavenDomDependency> hashSet = usages;
        if (hashSet == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(22);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<MavenDomPlugin> searchManagedPluginUsages(@NotNull MavenDomPlugin plugin) {
        String artifactId;
        if (plugin == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(23);
        }
        if ((artifactId = plugin.getArtifactId().getStringValue()) == null) {
            List<MavenDomPlugin> list = Collections.emptyList();
            if (list == null) {
                MavenDomProjectProcessorUtils.$$$reportNull$$$0(24);
            }
            return list;
        }
        String groupId = plugin.getGroupId().getStringValue();
        MavenDomProjectModel model = (MavenDomProjectModel)plugin.getParentOfType(MavenDomProjectModel.class, false);
        if (model == null) {
            List<MavenDomPlugin> list = Collections.emptyList();
            if (list == null) {
                MavenDomProjectProcessorUtils.$$$reportNull$$$0(25);
            }
            return list;
        }
        return MavenDomProjectProcessorUtils.searchManagedPluginUsages(model, groupId, artifactId);
    }

    @NotNull
    public static Collection<MavenDomPlugin> searchManagedPluginUsages(@NotNull MavenDomProjectModel model, @Nullable String groupId, @NotNull String artifactId) {
        if (model == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(26);
        }
        if (artifactId == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(27);
        }
        Project project = model.getManager().getProject();
        HashSet<MavenDomPlugin> usages = new HashSet<MavenDomPlugin>();
        Processor collectProcessor = mavenDomProjectModel -> {
            for (MavenDomPlugin domPlugin : mavenDomProjectModel.getBuild().getPlugins().getPlugins()) {
                if (!MavenPluginDomUtil.isPlugin(domPlugin, groupId, artifactId)) continue;
                usages.add(domPlugin);
            }
            return false;
        };
        MavenDomProjectProcessorUtils.processChildrenRecursively(model, (Processor<? super MavenDomProjectModel>)collectProcessor, project, new HashSet(), true);
        HashSet<MavenDomPlugin> hashSet = usages;
        if (hashSet == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    public static void processChildrenRecursively(@Nullable MavenDomProjectModel model, @NotNull Processor<? super MavenDomProjectModel> processor) {
        if (processor == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(29);
        }
        MavenDomProjectProcessorUtils.processChildrenRecursively(model, processor, true);
    }

    public static void processChildrenRecursively(@Nullable MavenDomProjectModel model, @NotNull Processor<? super MavenDomProjectModel> processor, boolean processCurrentModel) {
        if (processor == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(30);
        }
        if (model != null) {
            MavenDomProjectProcessorUtils.processChildrenRecursively(model, processor, model.getManager().getProject(), new HashSet(), processCurrentModel);
        }
    }

    public static void processChildrenRecursively(@Nullable MavenDomProjectModel model, @NotNull Processor<? super MavenDomProjectModel> processor, @NotNull Project project, @NotNull Set<? super MavenDomProjectModel> processedModels, boolean strict) {
        if (processor == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(31);
        }
        if (project == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(32);
        }
        if (processedModels == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(33);
        }
        if (model != null && !processedModels.contains(model)) {
            processedModels.add(model);
            if (strict && processor.process((Object)model)) {
                return;
            }
            MavenProject mavenProject = MavenDomUtil.findProject(model);
            if (mavenProject != null) {
                for (MavenProject childProject : MavenProjectsManager.getInstance(project).findInheritors(mavenProject)) {
                    MavenDomProjectModel childProjectModel = MavenDomUtil.getMavenDomProjectModel(project, childProject.getFile());
                    MavenDomProjectProcessorUtils.processChildrenRecursively(childProjectModel, processor, project, processedModels, true);
                }
            }
        }
    }

    @Nullable
    public static MavenDomDependency searchManagingDependency(@NotNull MavenDomDependency dependency) {
        if (dependency == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(34);
        }
        return MavenDomProjectProcessorUtils.searchManagingDependency(dependency, dependency.getManager().getProject());
    }

    @Nullable
    public static MavenDomDependency searchManagingDependency(@NotNull MavenDomDependency dependency, @NotNull Project project) {
        DependencyConflictId depId;
        if (dependency == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(35);
        }
        if (project == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(36);
        }
        if ((depId = DependencyConflictId.create(dependency)) == null) {
            return null;
        }
        MavenDomProjectModel model = (MavenDomProjectModel)dependency.getParentOfType(MavenDomProjectModel.class, false);
        if (model == null) {
            return null;
        }
        Ref res = new Ref();
        Processor processor = dependency1 -> {
            if (depId.equals(DependencyConflictId.create(dependency1))) {
                res.set(dependency1);
                return true;
            }
            return false;
        };
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(model, (Processor<? super MavenDomDependency>)processor, project);
        return (MavenDomDependency)res.get();
    }

    @Nullable
    public static MavenDomPlugin searchManagingPlugin(final @NotNull MavenDomPlugin plugin) {
        if (plugin == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(37);
        }
        final String artifactId = plugin.getArtifactId().getStringValue();
        final String groupId = plugin.getGroupId().getStringValue();
        if (artifactId == null) {
            return null;
        }
        final MavenDomProjectModel model = (MavenDomProjectModel)plugin.getParentOfType(MavenDomProjectModel.class, false);
        if (model == null) {
            return null;
        }
        SearchProcessor<MavenDomPlugin, MavenDomPlugins> processor = new SearchProcessor<MavenDomPlugin, MavenDomPlugins>(){

            @Override
            protected MavenDomPlugin find(MavenDomPlugins mavenDomPlugins) {
                if (model.equals(mavenDomPlugins.getParentOfType(MavenDomProjectModel.class, true)) && plugin.getParentOfType(MavenDomPluginManagement.class, false) != null) {
                    return null;
                }
                for (MavenDomPlugin domPlugin : mavenDomPlugins.getPlugins()) {
                    if (!MavenPluginDomUtil.isPlugin(domPlugin, groupId, artifactId)) continue;
                    return domPlugin;
                }
                return null;
            }
        };
        Function domProfileFunction = mavenDomProfile -> mavenDomProfile.getBuild().getPluginManagement().getPlugins();
        MavenDomProjectProcessorUtils.process(model, processor, model.getManager().getProject(), domProfileFunction, domProfileFunction);
        return (MavenDomPlugin)((SearchProcessor)processor).myResult;
    }

    private static boolean processDependencyRecurrently(@NotNull Processor<? super MavenDomDependency> processor, @NotNull MavenDomDependency domDependency, @NotNull Set<String> recursionProtector) {
        if (processor == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(38);
        }
        if (domDependency == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(39);
        }
        if (recursionProtector == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(40);
        }
        if ("import".equals(domDependency.getScope().getRawText())) {
            GenericDomValueReference reference;
            PsiElement resolve;
            GenericDomValue<String> version = domDependency.getVersion();
            if (version.getXmlElement() != null && (resolve = (reference = new GenericDomValueReference(version)).resolve()) instanceof XmlFile) {
                if (!recursionProtector.add(((XmlFile)resolve).getVirtualFile().getPath())) {
                    return false;
                }
                MavenDomProjectModel dependModel = MavenDomUtil.getMavenDomModel((PsiFile)resolve, MavenDomProjectModel.class);
                if (dependModel == null) {
                    return false;
                }
                for (MavenDomDependency dependency : dependModel.getDependencyManagement().getDependencies().getDependencies()) {
                    if (!MavenDomProjectProcessorUtils.processDependencyRecurrently(processor, dependency, recursionProtector)) continue;
                    return true;
                }
            }
        } else if (processor.process((Object)domDependency)) {
            return true;
        }
        return false;
    }

    public static boolean processDependenciesInDependencyManagement(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<? super MavenDomDependency> processor, @NotNull Project project) {
        if (projectDom == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(41);
        }
        if (processor == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(42);
        }
        if (project == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(43);
        }
        Processor managedDependenciesListProcessor = dependencies -> {
            for (MavenDomDependency domDependency : dependencies.getDependencies()) {
                if (!MavenDomProjectProcessorUtils.processDependencyRecurrently(processor, domDependency, new HashSet<String>())) continue;
                return true;
            }
            return false;
        };
        Function domFunction = mavenDomProfile -> mavenDomProfile.getDependencyManagement().getDependencies();
        return MavenDomProjectProcessorUtils.process(projectDom, managedDependenciesListProcessor, project, domFunction, domFunction);
    }

    public static boolean processDependencies(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<MavenDomDependencies> processor) {
        if (projectDom == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(44);
        }
        if (processor == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(45);
        }
        Function domFunction = mavenDomProfile -> mavenDomProfile.getDependencies();
        return MavenDomProjectProcessorUtils.process(projectDom, processor, projectDom.getManager().getProject(), domFunction, domFunction);
    }

    public static boolean processProperties(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<MavenDomProperties> processor, @NotNull Project project) {
        if (projectDom == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(46);
        }
        if (processor == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(47);
        }
        if (project == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(48);
        }
        Function domFunction = mavenDomProfile -> mavenDomProfile.getProperties();
        return MavenDomProjectProcessorUtils.process(projectDom, processor, project, domFunction, domFunction);
    }

    public static <T> boolean process(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<T> processor, @NotNull Project project, @NotNull Function<? super MavenDomProfile, T> domProfileFunction, @NotNull Function<? super MavenDomProjectModel, T> projectDomFunction) {
        if (projectDom == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(49);
        }
        if (processor == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(50);
        }
        if (project == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(51);
        }
        if (domProfileFunction == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(52);
        }
        if (projectDomFunction == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(53);
        }
        return MavenDomProjectProcessorUtils.process(projectDom, processor, project, domProfileFunction, projectDomFunction, new HashSet<MavenDomProjectModel>());
    }

    public static <T> boolean process(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<T> processor, @NotNull Project project, @NotNull Function<? super MavenDomProfile, T> domProfileFunction, @NotNull Function<? super MavenDomProjectModel, T> projectDomFunction, Set<MavenDomProjectModel> processed) {
        if (projectDom == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(54);
        }
        if (processor == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(55);
        }
        if (project == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(56);
        }
        if (domProfileFunction == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(57);
        }
        if (projectDomFunction == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(58);
        }
        if (processed.contains(projectDom)) {
            return true;
        }
        processed.add(projectDom);
        MavenProject mavenProjectOrNull = MavenDomUtil.findProject(projectDom);
        if (MavenDomProjectProcessorUtils.processSettingsXml(mavenProjectOrNull, processor, project, domProfileFunction)) {
            return true;
        }
        if (MavenDomProjectProcessorUtils.processProject(projectDom, mavenProjectOrNull, processor, project, domProfileFunction, projectDomFunction)) {
            return true;
        }
        return MavenDomProjectProcessorUtils.processParentProjectFile(projectDom, processor, project, domProfileFunction, projectDomFunction, processed);
    }

    private static <T> boolean processParentProjectFile(MavenDomProjectModel projectDom, final Processor<T> processor, final Project project, final Function<? super MavenDomProfile, T> domProfileFunction, final Function<? super MavenDomProjectModel, T> projectDomFunction, final Set<MavenDomProjectModel> processed) {
        Boolean aBoolean = (Boolean)new DomParentProjectFileProcessor<Boolean>(MavenProjectsManager.getInstance(project)){

            @Override
            protected Boolean doProcessParent(VirtualFile parentFile) {
                MavenDomProjectModel parentProjectDom = MavenDomUtil.getMavenDomProjectModel(project, parentFile);
                if (parentProjectDom == null) {
                    return false;
                }
                return MavenDomProjectProcessorUtils.process(parentProjectDom, processor, project, domProfileFunction, projectDomFunction, processed);
            }
        }.process(projectDom);
        return aBoolean != null && aBoolean != false;
    }

    private static <T> boolean processSettingsXml(@Nullable MavenProject mavenProject, @NotNull Processor<? super T> processor, @NotNull Project project, Function<? super MavenDomProfile, ? extends T> domProfileFunction) {
        if (processor == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(59);
        }
        if (project == null) {
            MavenDomProjectProcessorUtils.$$$reportNull$$$0(60);
        }
        MavenGeneralSettings settings = MavenProjectsManager.getInstance(project).getGeneralSettings();
        for (VirtualFile each : settings.getEffectiveSettingsFiles()) {
            MavenDomSettingsModel settingsDom = MavenDomUtil.getMavenDomModel(project, each, MavenDomSettingsModel.class);
            if (settingsDom == null || !MavenDomProjectProcessorUtils.processProfiles(settingsDom.getProfiles(), mavenProject, processor, domProfileFunction)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean processProject(MavenDomProjectModel projectDom, MavenProject mavenProjectOrNull, Processor<? super T> processor, Project project, Function<? super MavenDomProfile, ? extends T> domProfileFunction, Function<? super MavenDomProjectModel, ? extends T> projectDomFunction) {
        if (MavenDomProjectProcessorUtils.processProfilesXml(MavenDomUtil.getVirtualFile(projectDom), mavenProjectOrNull, processor, project, domProfileFunction)) {
            return true;
        }
        if (MavenDomProjectProcessorUtils.processProfiles(projectDom.getProfiles(), mavenProjectOrNull, processor, domProfileFunction)) {
            return true;
        }
        Object t = projectDomFunction.fun((Object)projectDom);
        return t != null && processor.process(t);
    }

    private static <T> boolean processProfilesXml(VirtualFile projectFile, MavenProject mavenProjectOrNull, Processor<? super T> processor, Project project, Function<? super MavenDomProfile, ? extends T> f) {
        VirtualFile profilesFile = MavenUtil.findProfilesXmlFile(projectFile);
        if (profilesFile == null) {
            return false;
        }
        MavenDomProfiles profiles = MavenDomUtil.getMavenDomProfilesModel(project, profilesFile);
        if (profiles == null) {
            return false;
        }
        return MavenDomProjectProcessorUtils.processProfiles(profiles, mavenProjectOrNull, processor, f);
    }

    private static <T> boolean processProfiles(MavenDomProfiles profilesDom, MavenProject mavenProjectOrNull, Processor<? super T> processor, Function<? super MavenDomProfile, ? extends T> f) {
        Collection activeProfiles = mavenProjectOrNull == null ? null : mavenProjectOrNull.getActivatedProfilesIds().getEnabledProfiles();
        for (MavenDomProfile each : profilesDom.getProfiles()) {
            XmlTag idTag = each.getId().getXmlTag();
            if (idTag == null || activeProfiles != null && !activeProfiles.contains(idTag.getValue().getTrimmedText()) || !MavenDomProjectProcessorUtils.processProfile(each, processor, f)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean processProfile(MavenDomProfile profileDom, Processor<? super T> processor, Function<? super MavenDomProfile, ? extends T> f) {
        Object t = f.fun((Object)profileDom);
        return t != null && processor.process(t);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 15: 
            case 41: 
            case 44: 
            case 46: 
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDom";
                break;
            }
            case 7: 
            case 29: 
            case 30: 
            case 31: 
            case 38: 
            case 42: 
            case 45: 
            case 47: 
            case 50: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDomParent";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 12: 
            case 16: 
            case 32: 
            case 36: 
            case 43: 
            case 48: 
            case 51: 
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDomProperties";
                break;
            }
            case 17: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyId";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 23: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedModels";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domDependency";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursionProtector";
                break;
            }
            case 52: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domProfileFunction";
                break;
            }
            case 53: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDomFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenProjects";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParentProjects";
                break;
            }
            case 18: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "searchDependencyUsages";
                break;
            }
            case 24: 
            case 25: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "searchManagedPluginUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenProjects";
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 28: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectChildrenProjects";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectParentProjects";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processParentProjects";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findParent";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "searchProperty";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findProperty";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectProperties";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "searchDependencyUsages";
                break;
            }
            case 23: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "searchManagedPluginUsages";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processChildrenRecursively";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "searchManagingDependency";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "searchManagingPlugin";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processDependencyRecurrently";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processDependenciesInDependencyManagement";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processDependencies";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processProperties";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processSettingsXml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class SearchProcessor<R, T>
    implements Processor<T> {
        private R myResult;

        public final boolean process(T t) {
            R res = this.find(t);
            if (res != null) {
                this.myResult = res;
                return true;
            }
            return false;
        }

        @Nullable
        protected abstract R find(T var1);

        public R getResult() {
            return this.myResult;
        }
    }

    public static abstract class DomParentProjectFileProcessor<T>
    extends MavenParentProjectFileProcessor<T> {
        private final MavenProjectsManager myManager;

        public DomParentProjectFileProcessor(MavenProjectsManager manager) {
            this.myManager = manager;
        }

        @Override
        protected VirtualFile findManagedFile(@NotNull MavenId id) {
            MavenProject project;
            if (id == null) {
                DomParentProjectFileProcessor.$$$reportNull$$$0(0);
            }
            return (project = this.myManager.findProject(id)) == null ? null : project.getFile();
        }

        @Nullable
        public T process(@NotNull MavenDomProjectModel projectDom) {
            VirtualFile projectFile;
            if (projectDom == null) {
                DomParentProjectFileProcessor.$$$reportNull$$$0(1);
            }
            MavenDomParent parent = projectDom.getMavenParent();
            MavenParentDesc parentDesc = null;
            if (DomUtil.hasXml((DomElement)parent)) {
                String parentGroupId = parent.getGroupId().getStringValue();
                String parentArtifactId = parent.getArtifactId().getStringValue();
                String parentVersion = parent.getVersion().getStringValue();
                String parentRelativePath = parent.getRelativePath().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)parentRelativePath)) {
                    parentRelativePath = "../pom.xml";
                }
                MavenId parentId = new MavenId(parentGroupId, parentArtifactId, parentVersion);
                parentDesc = new MavenParentDesc(parentId, parentRelativePath);
            }
            return (projectFile = MavenDomUtil.getVirtualFile(projectDom)) == null ? null : (T)this.process(this.myManager.getGeneralSettings(), projectFile, parentDesc);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectDom";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils$DomParentProjectFileProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findManagedFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

