/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.generate;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementAction;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.generate.GenerateManagedDependencyAction;
import org.jetbrains.idea.maven.dom.generate.MavenGenerateProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchDialog;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.model.MavenId;

public class GenerateDependencyAction
extends GenerateDomElementAction {
    public GenerateDependencyAction() {
        super((GenerateDomElementProvider)new MavenGenerateProvider<MavenDomDependency>(MavenDomBundle.message("generate.dependency.title", new Object[0]), MavenDomDependency.class){

            @Override
            @Nullable
            protected MavenDomDependency doGenerate(@NotNull MavenDomProjectModel mavenModel, Editor editor) {
                Map<DependencyConflictId, MavenDomDependency> managedDependencies;
                Project project;
                List<MavenId> ids;
                if (mavenModel == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((ids = MavenArtifactSearchDialog.searchForArtifact(project = mavenModel.getManager().getProject(), (managedDependencies = GenerateManagedDependencyAction.collectManagingDependencies(mavenModel)).values())).isEmpty()) {
                    return null;
                }
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                XmlFile psiFile = DomUtil.getFile((DomElement)mavenModel);
                return GenerateDependencyAction.createDependencyInWriteAction(mavenModel, editor, managedDependencies, ids, psiFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenModel", "org/jetbrains/idea/maven/dom/generate/GenerateDependencyAction$1", "doGenerate"));
            }
        }, AllIcons.Nodes.PpLib);
    }

    public static MavenDomDependency createDependencyInWriteAction(@NotNull MavenDomProjectModel mavenModel, @NotNull Editor editor, @NotNull Map<DependencyConflictId, MavenDomDependency> managedDependencies, @NotNull List<? extends MavenCoordinate> ids, @NotNull XmlFile psiFile) {
        if (mavenModel == null) {
            GenerateDependencyAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GenerateDependencyAction.$$$reportNull$$$0(1);
        }
        if (managedDependencies == null) {
            GenerateDependencyAction.$$$reportNull$$$0(2);
        }
        if (ids == null) {
            GenerateDependencyAction.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            GenerateDependencyAction.$$$reportNull$$$0(4);
        }
        return (MavenDomDependency)WriteCommandAction.writeCommandAction((Project)psiFile.getProject(), (PsiFile[])new PsiFile[]{psiFile}).withName(MavenDomBundle.message("generate.dependency", new Object[0])).compute(() -> GenerateDependencyAction.createDependency(mavenModel, editor, managedDependencies, ids));
    }

    @Nullable
    public static MavenDomDependency createDependency(@NotNull MavenDomProjectModel mavenModel, @NotNull Editor editor, @NotNull Map<DependencyConflictId, MavenDomDependency> managedDependencies, @NotNull List<? extends MavenCoordinate> ids) {
        MavenDomDependencyManagement dependencyManagement;
        XmlElement managedDependencyXml;
        if (mavenModel == null) {
            GenerateDependencyAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            GenerateDependencyAction.$$$reportNull$$$0(6);
        }
        if (managedDependencies == null) {
            GenerateDependencyAction.$$$reportNull$$$0(7);
        }
        if (ids == null) {
            GenerateDependencyAction.$$$reportNull$$$0(8);
        }
        boolean isInsideManagedDependencies = (managedDependencyXml = (dependencyManagement = mavenModel.getDependencyManagement()).getXmlElement()) != null && managedDependencyXml.getTextRange().contains(editor.getCaretModel().getOffset());
        Iterator<? extends MavenCoordinate> iterator = ids.iterator();
        if (iterator.hasNext()) {
            MavenDomDependency res;
            MavenCoordinate each = iterator.next();
            if (isInsideManagedDependencies) {
                res = MavenDomUtil.createDomDependency(dependencyManagement.getDependencies(), editor, each);
            } else {
                DependencyConflictId conflictId = new DependencyConflictId(each.getGroupId(), each.getArtifactId(), null, null);
                MavenDomDependency managedDependenciesDom = managedDependencies.get(conflictId);
                if (managedDependenciesDom != null && Comparing.equal((String)each.getVersion(), (String)managedDependenciesDom.getVersion().getStringValue())) {
                    res = MavenDomUtil.createDomDependency(mavenModel.getDependencies(), editor);
                    res.getGroupId().setStringValue(conflictId.getGroupId());
                    res.getArtifactId().setStringValue(conflictId.getArtifactId());
                } else {
                    res = MavenDomUtil.createDomDependency(mavenModel.getDependencies(), editor, each);
                }
            }
            return res;
        }
        return null;
    }

    protected boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenModel";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managedDependencies";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/dom/generate/GenerateDependencyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDependencyInWriteAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

