/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.completion.MavenAbstractPluginExtensionCompletionContributor;
import org.jetbrains.idea.maven.dom.model.completion.MavenCoordinateCompletionContributor;
import org.jetbrains.idea.maven.dom.model.completion.MavenVersionNegatingWeigher;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;
import org.jetbrains.idea.reposearch.SearchParameters;

public class MavenVersionCompletionContributor
extends MavenCoordinateCompletionContributor {
    public MavenVersionCompletionContributor() {
        super("version");
    }

    @Override
    protected Promise<Integer> find(@NotNull DependencySearchService service, @NotNull MavenDomShortArtifactCoordinates coordinates, @NotNull CompletionParameters parameters, @NotNull Consumer<RepositoryArtifactData> consumer) {
        if (service == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(0);
        }
        if (coordinates == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(3);
        }
        SearchParameters searchParameters = this.createSearchParameters(parameters);
        String groupId = MavenVersionCompletionContributor.trimDummy(coordinates.getGroupId().getStringValue());
        String artifactId = MavenVersionCompletionContributor.trimDummy(coordinates.getArtifactId().getStringValue());
        if (MavenAbstractPluginExtensionCompletionContributor.isPluginOrExtension(coordinates) && StringUtil.isEmpty((String)groupId)) {
            return MavenAbstractPluginExtensionCompletionContributor.findPluginByArtifactId(service, artifactId, searchParameters, new RepositoryArtifactDataConsumer(artifactId, groupId, consumer));
        }
        return service.suggestPrefix(groupId, artifactId, searchParameters, (Consumer)new RepositoryArtifactDataConsumer(artifactId, groupId, consumer));
    }

    @Override
    protected void fillAfter(CompletionResultSet result) {
        if (MavenServerManager.getInstance().isUseMaven2()) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)"RELEASE").withStrikeoutness(true));
            result.addElement((LookupElement)LookupElementBuilder.create((String)"LATEST").withStrikeoutness(true));
        }
    }

    @Override
    protected void fillResult(@NotNull MavenDomShortArtifactCoordinates coordinates, @NotNull CompletionResultSet result, @NotNull MavenRepositoryArtifactInfo item) {
        if (coordinates == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(4);
        }
        if (result == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(5);
        }
        if (item == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(6);
        }
        result.addAllElements((Iterable)ContainerUtil.map((Object[])item.getItems(), dci -> MavenDependencyCompletionUtil.lookupElement(dci, dci.getVersion())));
    }

    @Override
    protected boolean validate(String groupId, String artifactId) {
        return !StringUtil.isEmptyOrSpaces((String)artifactId);
    }

    @Override
    @NotNull
    protected CompletionResultSet amendResultSet(@NotNull CompletionResultSet result) {
        if (result == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(7);
        }
        CompletionResultSet completionResultSet = result.withRelevanceSorter(CompletionService.getCompletionService().emptySorter().weigh((LookupElementWeigher)new MavenVersionNegatingWeigher()));
        if (completionResultSet == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(8);
        }
        return completionResultSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinates";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/model/completion/MavenVersionCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/model/completion/MavenVersionCompletionContributor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "amendResultSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillResult";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "amendResultSet";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RepositoryArtifactDataConsumer
    implements Consumer<RepositoryArtifactData> {
        private final String myArtifactId;
        private final String myGroupId;
        @NotNull
        private final Consumer<RepositoryArtifactData> myConsumer;

        public RepositoryArtifactDataConsumer(String artifactId, String groupId, @NotNull Consumer<RepositoryArtifactData> consumer) {
            if (consumer == null) {
                RepositoryArtifactDataConsumer.$$$reportNull$$$0(0);
            }
            this.myArtifactId = artifactId;
            this.myGroupId = groupId;
            this.myConsumer = consumer;
        }

        @Override
        public void accept(RepositoryArtifactData rad) {
            MavenRepositoryArtifactInfo mrai;
            if (rad instanceof MavenRepositoryArtifactInfo && StringUtil.equals((CharSequence)(mrai = (MavenRepositoryArtifactInfo)rad).getArtifactId(), (CharSequence)this.myArtifactId) && (StringUtil.isEmpty((String)this.myGroupId) || StringUtil.equals((CharSequence)mrai.getGroupId(), (CharSequence)this.myGroupId))) {
                this.myConsumer.accept(mrai);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/idea/maven/dom/model/completion/MavenVersionCompletionContributor$RepositoryArtifactDataConsumer", "<init>"));
        }
    }
}

