/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion.insert;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.onlinecompletion.MavenScopeTable;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;

public class MavenDependencyInsertionHandler
implements InsertHandler<LookupElement> {
    public static final InsertHandler<LookupElement> INSTANCE = new MavenDependencyInsertionHandler();

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Object object;
        if (context == null) {
            MavenDependencyInsertionHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            MavenDependencyInsertionHandler.$$$reportNull$$$0(1);
        }
        if (!((object = item.getObject()) instanceof MavenRepositoryArtifactInfo)) {
            return;
        }
        MavenRepositoryArtifactInfo completionItem = (MavenRepositoryArtifactInfo)object;
        PsiFile contextFile = context.getFile();
        if (!(contextFile instanceof XmlFile)) {
            return;
        }
        XmlFile xmlFile = (XmlFile)contextFile;
        PsiElement element = xmlFile.findElementAt(context.getStartOffset());
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (tag == null) {
            return;
        }
        context.commitDocument();
        MavenDomShortArtifactCoordinates domCoordinates = MavenDependencyInsertionHandler.getDomCoordinatesFromCurrentTag(context, tag);
        if (domCoordinates == null) {
            return;
        }
        this.setDependency(context, completionItem, (XmlFile)contextFile, domCoordinates);
    }

    private static MavenDomShortArtifactCoordinates getDomCoordinatesFromCurrentTag(@NotNull InsertionContext context, @NotNull XmlTag tag) {
        DomElement element;
        if (context == null) {
            MavenDependencyInsertionHandler.$$$reportNull$$$0(2);
        }
        if (tag == null) {
            MavenDependencyInsertionHandler.$$$reportNull$$$0(3);
        }
        if ((element = DomManager.getDomManager((Project)context.getProject()).getDomElement(tag)) instanceof MavenDomShortArtifactCoordinates) {
            tag.getValue().setText("");
            return (MavenDomShortArtifactCoordinates)element;
        }
        element = DomManager.getDomManager((Project)context.getProject()).getDomElement(tag.getParentTag());
        if (element instanceof MavenDomShortArtifactCoordinates) {
            return (MavenDomShortArtifactCoordinates)element;
        }
        return null;
    }

    protected void setDependency(@NotNull InsertionContext context, MavenRepositoryArtifactInfo completionItem, XmlFile contextFile, MavenDomShortArtifactCoordinates domCoordinates) {
        MavenDomDependency declarationOfDependency;
        String scope;
        if (context == null) {
            MavenDependencyInsertionHandler.$$$reportNull$$$0(4);
        }
        if (completionItem.getGroupId() == null) {
            return;
        }
        domCoordinates.getGroupId().setStringValue(completionItem.getGroupId());
        if (completionItem.getArtifactId() == null) {
            domCoordinates.getArtifactId().setStringValue("");
            int position = domCoordinates.getArtifactId().getXmlTag().getValue().getTextRange().getStartOffset();
            context.getEditor().getCaretModel().moveToOffset(position);
            MavenDependencyCompletionUtil.invokeCompletion(context, CompletionType.BASIC);
            return;
        }
        domCoordinates.getArtifactId().setStringValue(completionItem.getArtifactId());
        if (domCoordinates instanceof MavenDomDependency && (scope = MavenScopeTable.getUsualScope(completionItem)) != null) {
            ((MavenDomDependency)domCoordinates).getScope().setStringValue(scope);
        }
        DomFileElement domModel = DomManager.getDomManager((Project)context.getProject()).getFileElement(contextFile, MavenDomProjectModel.class);
        if (!MavenDependencyCompletionUtil.isInsideManagedDependency(domCoordinates) && (declarationOfDependency = MavenDependencyCompletionUtil.findManagedDependency((MavenDomProjectModel)domModel.getRootElement(), context.getProject(), completionItem.getGroupId(), completionItem.getArtifactId())) != null) {
            if (domCoordinates instanceof MavenDomDependency) {
                if (declarationOfDependency.getType().getRawText() != null) {
                    ((MavenDomDependency)domCoordinates).getType().setStringValue(declarationOfDependency.getType().getRawText());
                }
                if (declarationOfDependency.getClassifier().getRawText() != null) {
                    ((MavenDomDependency)domCoordinates).getClassifier().setStringValue(declarationOfDependency.getClassifier().getRawText());
                }
            }
            return;
        }
        if (domCoordinates instanceof MavenDomArtifactCoordinates) {
            MavenDependencyInsertionHandler.insertVersion(context, completionItem, (MavenDomArtifactCoordinates)domCoordinates);
        }
    }

    private static void insertVersion(@NotNull InsertionContext context, MavenRepositoryArtifactInfo completionItem, MavenDomArtifactCoordinates domCoordinates) {
        if (context == null) {
            MavenDependencyInsertionHandler.$$$reportNull$$$0(5);
        }
        if (completionItem.getItems() != null && completionItem.getItems().length == 1 && completionItem.getVersion() != null) {
            domCoordinates.getVersion().setStringValue(completionItem.getVersion());
        } else {
            domCoordinates.getVersion().setStringValue("");
            int versionPosition = domCoordinates.getVersion().getXmlTag().getValue().getTextRange().getStartOffset();
            context.getEditor().getCaretModel().moveToOffset(versionPosition);
            MavenDependencyCompletionUtil.invokeCompletion(context, CompletionType.BASIC);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/dom/model/completion/insert/MavenDependencyInsertionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDomCoordinatesFromCurrentTag";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setDependency";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "insertVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

