/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReference;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

public class MavenFilteredPropertyPsiReferenceProvider
extends PsiReferenceProvider {
    private static final Key<Pattern> KEY = Key.create((String)"MavenFilteredPropertyPsiReferenceProvider:delimitersKey");
    public static final Pattern DEFAULT_DELIMITERS = MavenPropertyResolver.PATTERN;

    @NotNull
    public static Pattern getDelimitersPattern(MavenProject mavenProject) {
        Pattern res = mavenProject.getCachedValue(KEY);
        if (res == null) {
            Element cfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
            if (cfg == null) {
                res = DEFAULT_DELIMITERS;
            } else {
                List<String> delimiters = MavenJDOMUtil.findChildrenValuesByPath(cfg, "delimiters", "delimiter");
                if (delimiters.isEmpty() || delimiters.size() > 10) {
                    res = DEFAULT_DELIMITERS;
                } else {
                    StringBuilder patternBuilder = new StringBuilder();
                    for (String delimiter : delimiters) {
                        if ((delimiter = delimiter.trim()).isEmpty()) continue;
                        int ind = delimiter.indexOf(42);
                        if (ind >= 0) {
                            MavenFilteredPropertyPsiReferenceProvider.appendDelimiter(patternBuilder, delimiter.substring(0, ind), delimiter.substring(ind + 1));
                            continue;
                        }
                        MavenFilteredPropertyPsiReferenceProvider.appendDelimiter(patternBuilder, delimiter, delimiter);
                    }
                    boolean useDefaultDelimiters = true;
                    String useDefaultDelimitersText = cfg.getChildText("useDefaultDelimiters");
                    if (StringUtil.isNotEmpty((String)useDefaultDelimitersText)) {
                        useDefaultDelimiters = Boolean.parseBoolean(useDefaultDelimitersText);
                    }
                    if (useDefaultDelimiters) {
                        MavenFilteredPropertyPsiReferenceProvider.appendDelimiter(patternBuilder, "${", "}");
                        MavenFilteredPropertyPsiReferenceProvider.appendDelimiter(patternBuilder, "@", "@");
                    }
                    res = Pattern.compile(patternBuilder.toString());
                }
            }
            res = mavenProject.putCachedValue(KEY, res);
        }
        Pattern pattern = res;
        if (pattern == null) {
            MavenFilteredPropertyPsiReferenceProvider.$$$reportNull$$$0(0);
        }
        return pattern;
    }

    private static void appendDelimiter(StringBuilder pattern, String prefix, String suffix) {
        if (pattern.length() > 0) {
            pattern.append('|');
        }
        pattern.append(Pattern.quote(prefix)).append("(.+?)").append(Pattern.quote(suffix));
    }

    private static boolean shouldAddReference(@NotNull PsiElement element) {
        if (element == null) {
            MavenFilteredPropertyPsiReferenceProvider.$$$reportNull$$$0(1);
        }
        if (element.getFirstChild() == element.getLastChild()) {
            return true;
        }
        return element instanceof XmlAttribute;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            MavenFilteredPropertyPsiReferenceProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            MavenFilteredPropertyPsiReferenceProvider.$$$reportNull$$$0(3);
        }
        if (!MavenFilteredPropertyPsiReferenceProvider.shouldAddReference(element)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                MavenFilteredPropertyPsiReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (!MavenDomUtil.isFilteredResourceFile(element)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                MavenFilteredPropertyPsiReferenceProvider.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String text = element.getText();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                MavenFilteredPropertyPsiReferenceProvider.$$$reportNull$$$0(6);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        MavenProject mavenProject = MavenDomUtil.findContainingProject(element);
        if (mavenProject == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                MavenFilteredPropertyPsiReferenceProvider.$$$reportNull$$$0(7);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<MavenFilteredPropertyPsiReference> res = null;
        Pattern pattern = MavenFilteredPropertyPsiReferenceProvider.getDelimitersPattern(mavenProject);
        Matcher matcher = pattern.matcher(text);
        int groupCount = matcher.groupCount();
        while (matcher.find()) {
            String propertyName = null;
            int from = 0;
            for (int i = 0; i < groupCount; ++i) {
                propertyName = matcher.group(i + 1);
                if (propertyName == null) continue;
                from = matcher.start(i + 1);
                break;
            }
            assert (propertyName != null);
            if (res == null) {
                res = new ArrayList<MavenFilteredPropertyPsiReference>();
            }
            TextRange range = TextRange.from((int)from, (int)propertyName.length());
            res.add(new MavenFilteredPropertyPsiReference(mavenProject, element, propertyName, range));
        }
        PsiReference[] psiReferenceArray = res == null ? PsiReference.EMPTY_ARRAY : res.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            MavenFilteredPropertyPsiReferenceProvider.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/references/MavenFilteredPropertyPsiReferenceProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimitersPattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/references/MavenFilteredPropertyPsiReferenceProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

