/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.ide.actions.runAnything.RunAnythingContext;
import com.intellij.ide.actions.runAnything.RunAnythingContextUtils;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingCommandLineProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProviderBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import icons.OpenapiIcons;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenCommandLineOptions;
import org.jetbrains.idea.maven.execution.MavenRunAnythingProvider;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.RunAnythingMavenItem;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/maven/execution/MavenRunAnythingProvider;", "Lcom/intellij/ide/actions/runAnything/activity/RunAnythingCommandLineProvider;", "()V", "completeBasicPhases", "Lkotlin/sequences/Sequence;", "", "commandLine", "Lcom/intellij/ide/actions/runAnything/activity/RunAnythingCommandLineProvider$CommandLine;", "completeCustomGoals", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "completeOptions", "isLongOpt", "", "getCompletionGroupTitle", "getHelpCommand", "getHelpCommandPlaceholder", "getHelpGroupTitle", "getHelpIcon", "Ljavax/swing/Icon;", "getIcon", "value", "getMainListItem", "Lorg/jetbrains/idea/maven/execution/RunAnythingMavenItem;", "run", "suggestCompletionVariants", "getMavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "Lcom/intellij/ide/actions/runAnything/RunAnythingContext;", "projectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "Companion", "intellij.maven"})
public final class MavenRunAnythingProvider
extends RunAnythingCommandLineProvider {
    @NotNull
    public static final String HELP_COMMAND = "mvn";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getHelpCommand() {
        return HELP_COMMAND;
    }

    @Nullable
    public Icon getHelpIcon() {
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    @NotNull
    public String getHelpGroupTitle() {
        return "Maven";
    }

    @Nullable
    public Icon getIcon(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    @NotNull
    public String getCompletionGroupTitle() {
        return "Maven goals";
    }

    @NotNull
    public String getHelpCommandPlaceholder() {
        return "mvn <goals...> <options...>";
    }

    @NotNull
    public RunAnythingMavenItem getMainListItem(@NotNull DataContext dataContext, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return new RunAnythingMavenItem(this.getCommand(value), this.getIcon(value));
    }

    @NotNull
    protected Sequence<String> suggestCompletionVariants(@NotNull DataContext dataContext, @NotNull RunAnythingCommandLineProvider.CommandLine commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Sequence basicPhasesVariants = SequencesKt.sorted(this.completeBasicPhases(commandLine));
        Sequence customGoalsVariants = SequencesKt.sorted(this.completeCustomGoals(dataContext, commandLine));
        Sequence longOptionsVariants = SequencesKt.sorted(this.completeOptions(commandLine, true));
        Sequence shortOptionsVariants = SequencesKt.sorted(this.completeOptions(commandLine, false));
        return StringsKt.startsWith$default((String)commandLine.getToComplete(), (String)"--", (boolean)false, (int)2, null) ? SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)longOptionsVariants, (Sequence)shortOptionsVariants), (Sequence)basicPhasesVariants), (Sequence)customGoalsVariants) : (StringsKt.startsWith$default((String)commandLine.getToComplete(), (String)"-", (boolean)false, (int)2, null) ? SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)shortOptionsVariants, (Sequence)longOptionsVariants), (Sequence)basicPhasesVariants), (Sequence)customGoalsVariants) : SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)basicPhasesVariants, (Sequence)customGoalsVariants), (Sequence)longOptionsVariants), (Sequence)shortOptionsVariants));
    }

    protected boolean run(@NotNull DataContext dataContext, @NotNull RunAnythingCommandLineProvider.CommandLine commandLine) {
        MavenRunner mavenRunner;
        MavenProjectsManager projectsManager;
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"fetchProject(dataContext)");
        Project project2 = project;
        RunAnythingContext runAnythingContext = (RunAnythingContext)dataContext.getData(RunAnythingProviderBase.EXECUTING_CONTEXT);
        if (runAnythingContext == null) {
            runAnythingContext = (RunAnythingContext)new RunAnythingContext.ProjectContext(project2);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)runAnythingContext, (String)"dataContext.getData(EXEC\u2026: ProjectContext(project)");
        RunAnythingContext context = runAnythingContext;
        MavenProjectsManager mavenProjectsManager = projectsManager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenProjectsManager, (String)"projectsManager");
        MavenProject mavenProject = this.getMavenProject(context, mavenProjectsManager);
        Object object = mavenProject;
        if (object == null || (object = ((MavenProject)object).getDirectory()) == null) {
            object = RunAnythingContextUtils.getPath((RunAnythingContext)context);
        }
        if (object == null) {
            return false;
        }
        Object workingDirPath = object;
        Object object2 = mavenProject;
        if (object2 == null || (object2 = ((MavenProject)object2).getFile()) == null || (object2 = object2.getName()) == null) {
            object2 = "pom.xml";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"mavenProject?.file?.name ?: MavenConstants.POM_XML");
        Object pomFileName = object2;
        MavenExplicitProfiles mavenExplicitProfiles = projectsManager.getExplicitProfiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenExplicitProfiles, (String)"projectsManager.explicitProfiles");
        MavenExplicitProfiles explicitProfiles = mavenExplicitProfiles;
        Collection enabledProfiles = explicitProfiles.getEnabledProfiles();
        Collection disabledProfiles = explicitProfiles.getDisabledProfiles();
        List goals = commandLine.getParameters();
        MavenRunnerParameters params = new MavenRunnerParameters(true, (String)workingDirPath, (String)pomFileName, goals, enabledProfiles, disabledProfiles);
        MavenRunner mavenRunner2 = mavenRunner = MavenRunner.getInstance(project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenRunner2, (String)"mavenRunner");
        mavenRunner.run(params, mavenRunner2.getSettings(), null);
        return true;
    }

    private final MavenProject getMavenProject(@NotNull RunAnythingContext $this$getMavenProject, MavenProjectsManager projectsManager) {
        MavenProject mavenProject;
        RunAnythingContext runAnythingContext = $this$getMavenProject;
        if (runAnythingContext instanceof RunAnythingContext.ProjectContext) {
            List<MavenProject> list = projectsManager.getRootProjects();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"projectsManager.rootProjects");
            mavenProject = (MavenProject)CollectionsKt.firstOrNull(list);
        } else if (runAnythingContext instanceof RunAnythingContext.ModuleContext) {
            mavenProject = projectsManager.findProject(((RunAnythingContext.ModuleContext)$this$getMavenProject).getModule());
        } else if (runAnythingContext instanceof RunAnythingContext.RecentDirectoryContext) {
            mavenProject = null;
        } else if (runAnythingContext instanceof RunAnythingContext.BrowseRecentDirectoryContext) {
            mavenProject = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mavenProject;
    }

    private final Sequence<String> completeOptions(RunAnythingCommandLineProvider.CommandLine commandLine, boolean isLongOpt) {
        Collection<MavenCommandLineOptions.Option> collection = MavenCommandLineOptions.getAllOptions();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"MavenCommandLineOptions.getAllOptions()");
        return SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<MavenCommandLineOptions.Option, String>(isLongOpt){
            final /* synthetic */ boolean $isLongOpt;

            public final String invoke(MavenCommandLineOptions.Option it) {
                return it.getName(this.$isLongOpt);
            }
            {
                this.$isLongOpt = bl;
                super(1);
            }
        })), (Function1)((Function1)new Function1<String, Boolean>(commandLine){
            final /* synthetic */ RunAnythingCommandLineProvider.CommandLine $commandLine;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return !this.$commandLine.contains(it);
            }
            {
                this.$commandLine = commandLine;
                super(1);
            }
        }));
    }

    private final Sequence<String> completeBasicPhases(RunAnythingCommandLineProvider.CommandLine commandLine) {
        List list = MavenConstants.BASIC_PHASES;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"MavenConstants.BASIC_PHASES");
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<String, Boolean>(commandLine){
            final /* synthetic */ RunAnythingCommandLineProvider.CommandLine $commandLine;

            public final boolean invoke(String it) {
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                return !this.$commandLine.contains(string);
            }
            {
                this.$commandLine = commandLine;
                super(1);
            }
        }));
    }

    private final Sequence<String> completeCustomGoals(DataContext dataContext, RunAnythingCommandLineProvider.CommandLine commandLine) {
        MavenProjectsManager projectsManager;
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"fetchProject(dataContext)");
        Project project2 = project;
        RunAnythingContext runAnythingContext = (RunAnythingContext)dataContext.getData(RunAnythingProvider.EXECUTING_CONTEXT);
        if (runAnythingContext == null) {
            runAnythingContext = (RunAnythingContext)new RunAnythingContext.ProjectContext(project2);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)runAnythingContext, (String)"dataContext.getData(RunA\u2026: ProjectContext(project)");
        RunAnythingContext context = runAnythingContext;
        MavenProjectsManager mavenProjectsManager = projectsManager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenProjectsManager, (String)"projectsManager");
        if (!mavenProjectsManager.isMavenizedProject()) {
            return SequencesKt.emptySequence();
        }
        MavenProject mavenProject = this.getMavenProject(context, projectsManager);
        if (mavenProject == null) {
            return SequencesKt.emptySequence();
        }
        MavenProject mavenProject2 = mavenProject;
        File localRepository = projectsManager.getLocalRepository();
        List<MavenPlugin> list = mavenProject2.getDeclaredPlugins();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"mavenProject.declaredPlugins");
        return SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<MavenPlugin, MavenPluginInfo>(localRepository){
            final /* synthetic */ File $localRepository;

            @Nullable
            public final MavenPluginInfo invoke(MavenPlugin it) {
                MavenPlugin mavenPlugin = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenPlugin, (String)"it");
                return MavenArtifactUtil.readPluginInfo(this.$localRepository, mavenPlugin.getMavenId());
            }
            {
                this.$localRepository = file;
                super(1);
            }
        })), (Function1)completeCustomGoals.2.INSTANCE), (Function1)completeCustomGoals.3.INSTANCE), (Function1)((Function1)new Function1<String, Boolean>(commandLine){
            final /* synthetic */ RunAnythingCommandLineProvider.CommandLine $commandLine;

            public final boolean invoke(String it) {
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                return !this.$commandLine.contains(string);
            }
            {
                this.$commandLine = commandLine;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/execution/MavenRunAnythingProvider$Companion;", "", "()V", "HELP_COMMAND", "", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

