/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.parsers;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.MavenTaskFailedResultImpl;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenSpyOutputParser {
    public static final String PREFIX = "[IJ]-";
    private static final String SEPARATOR = "-[IJ]-";
    private static final String NEWLINE = "-[N]-";
    public static final String DOWNLOAD_DEPENDENCIES_NAME = "dependencies";
    private final Set<String> downloadingMap = new HashSet<String>();
    private final MavenParsingContext myContext;

    public static boolean isSpyLog(String s) {
        return s != null && s.startsWith(PREFIX);
    }

    public MavenSpyOutputParser(MavenParsingContext context) {
        this.myContext = context;
    }

    public void processLine(@NotNull String spyLine, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        if (spyLine == null) {
            MavenSpyOutputParser.$$$reportNull$$$0(0);
        }
        if (messageConsumer == null) {
            MavenSpyOutputParser.$$$reportNull$$$0(1);
        }
        String line = spyLine.substring(PREFIX.length());
        try {
            int threadId;
            int threadSeparatorIdx = line.indexOf(45);
            if (threadSeparatorIdx < 0) {
                return;
            }
            try {
                threadId = Integer.parseInt(line.substring(0, threadSeparatorIdx));
            }
            catch (NumberFormatException ignore) {
                return;
            }
            if (threadId < 0) {
                return;
            }
            int typeSeparatorIdx = line.indexOf(SEPARATOR, threadSeparatorIdx + 1);
            if (typeSeparatorIdx < 0) {
                return;
            }
            String type = line.substring(threadSeparatorIdx + 1, typeSeparatorIdx);
            List data = StringUtil.split((String)line.substring(typeSeparatorIdx + SEPARATOR.length()), (String)SEPARATOR);
            Map<String, String> parameters = data.stream().map(d -> d.split("=")).filter(d -> ((String[])d).length == 2).peek(d -> {
                d[1] = d[1].replace(NEWLINE, "\n");
            }).collect(Collectors.toMap(d -> d[0], d -> d[1]));
            this.parse(threadId, type, parameters, messageConsumer);
        }
        catch (Exception e) {
            MavenLog.LOG.error((Throwable)e);
        }
    }

    protected void parse(int threadId, String type, Map<String, String> parameters, Consumer<? super BuildEvent> messageConsumer) {
        switch (type) {
            case "SessionStarted": {
                List<String> projectsInReactor = MavenSpyOutputParser.getProjectsInReactor(parameters);
                this.myContext.setProjectsInReactor(projectsInReactor);
                return;
            }
            case "ProjectStarted": {
                MavenParsingContext.ProjectExecutionEntry execution = this.myContext.getProject(threadId, parameters, true);
                if (execution == null) {
                    MavenLog.LOG.debug("Not found for " + parameters);
                } else {
                    messageConsumer.accept((BuildEvent)new StartEventImpl(execution.getId(), execution.getParentId(), System.currentTimeMillis(), execution.getName()));
                }
                return;
            }
            case "MojoStarted": {
                MavenParsingContext.MojoExecutionEntry mojoExecution = this.myContext.getMojo(threadId, parameters, true);
                MavenSpyOutputParser.doStart(messageConsumer, mojoExecution);
                return;
            }
            case "MojoSucceeded": {
                this.stopFakeDownloadNode(threadId, parameters, messageConsumer);
                MavenParsingContext.MojoExecutionEntry mojoExecution = this.myContext.getMojo(threadId, parameters, false);
                MavenSpyOutputParser.doComplete(messageConsumer, mojoExecution);
                return;
            }
            case "MojoFailed": {
                this.stopFakeDownloadNode(threadId, parameters, messageConsumer);
                MavenParsingContext.MojoExecutionEntry mojoExecution = this.myContext.getMojo(threadId, parameters, false);
                if (mojoExecution == null) {
                    MavenLog.LOG.debug("Not found id for " + parameters);
                } else {
                    messageConsumer.accept((BuildEvent)new FinishEventImpl(mojoExecution.getId(), mojoExecution.getParentId(), System.currentTimeMillis(), mojoExecution.getName(), (EventResult)new MavenTaskFailedResultImpl(parameters.get("error"))));
                    mojoExecution.complete();
                }
                return;
            }
            case "MojoSkipped": {
                this.stopFakeDownloadNode(threadId, parameters, messageConsumer);
                MavenParsingContext.MojoExecutionEntry mojoExecution = this.myContext.getMojo(threadId, parameters, false);
                MavenSpyOutputParser.doSkip(messageConsumer, mojoExecution);
                return;
            }
            case "ProjectSucceeded": {
                this.stopFakeDownloadNode(threadId, parameters, messageConsumer);
                MavenParsingContext.ProjectExecutionEntry execution = this.myContext.getProject(threadId, parameters, false);
                MavenSpyOutputParser.doComplete(messageConsumer, execution);
                return;
            }
            case "ProjectSkipped": {
                MavenParsingContext.ProjectExecutionEntry execution = this.myContext.getProject(threadId, parameters, false);
                MavenSpyOutputParser.doSkip(messageConsumer, execution);
                return;
            }
            case "ProjectFailed": {
                this.stopFakeDownloadNode(threadId, parameters, messageConsumer);
                MavenParsingContext.ProjectExecutionEntry execution = this.myContext.getProject(threadId, parameters, false);
                MavenSpyOutputParser.doError(messageConsumer, execution, parameters.get("error"));
                return;
            }
            case "ARTIFACT_RESOLVED": {
                this.artifactResolved(threadId, parameters, messageConsumer);
                return;
            }
            case "ARTIFACT_DOWNLOADING": {
                this.artifactDownloading(threadId, parameters, messageConsumer);
            }
        }
    }

    private static List<String> getProjectsInReactor(Map<String, String> parameters) {
        String joined = parameters.get("projects");
        if (StringUtil.isEmptyOrSpaces((String)joined)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String project : joined.split("&&")) {
            if (StringUtil.isEmptyOrSpaces((String)project)) continue;
            result.add(project);
        }
        return result;
    }

    private void artifactDownloading(int threadId, Map<String, String> parameters, Consumer<? super BuildEvent> messageConsumer) {
        String artifactCoord = parameters.get("artifactCoord");
        if (artifactCoord == null || !this.downloadingMap.add(artifactCoord)) {
            return;
        }
        MavenParsingContext.MavenExecutionEntry parent = this.startFakeDownloadNodeIfNotStarted(threadId, parameters, messageConsumer);
        messageConsumer.accept((BuildEvent)new StartEventImpl((Object)MavenSpyOutputParser.getDownloadId(artifactCoord), parent.getId(), System.currentTimeMillis(), artifactCoord));
    }

    private void artifactResolved(int threadId, Map<String, String> parameters, Consumer<? super BuildEvent> messageConsumer) {
        String artifactCoord = parameters.get("artifactCoord");
        if (artifactCoord == null) {
            return;
        }
        String error = parameters.get("error");
        if (error != null || this.downloadingMap.contains(artifactCoord)) {
            MavenParsingContext.MavenExecutionEntry parent = this.startFakeDownloadNodeIfNotStarted(threadId, parameters, messageConsumer);
            if (error != null) {
                if (this.downloadingMap.remove(artifactCoord)) {
                    messageConsumer.accept((BuildEvent)new FinishEventImpl((Object)MavenSpyOutputParser.getDownloadId(artifactCoord), parent.getId(), System.currentTimeMillis(), artifactCoord, (EventResult)new FailureResultImpl(error, null)));
                } else {
                    Object eventId = new Object();
                    messageConsumer.accept((BuildEvent)new StartEventImpl(eventId, parent.getId(), System.currentTimeMillis(), error));
                    messageConsumer.accept((BuildEvent)new FinishEventImpl(eventId, parent.getId(), System.currentTimeMillis(), error, (EventResult)new FailureResultImpl()));
                }
            } else {
                messageConsumer.accept((BuildEvent)new FinishEventImpl((Object)MavenSpyOutputParser.getDownloadId(artifactCoord), parent.getId(), System.currentTimeMillis(), artifactCoord, (EventResult)new SuccessResultImpl(false)));
            }
        }
    }

    @NotNull
    private static String getDownloadId(String artifactCoord) {
        String string = "download" + artifactCoord;
        if (string == null) {
            MavenSpyOutputParser.$$$reportNull$$$0(2);
        }
        return string;
    }

    private MavenParsingContext.MavenExecutionEntry startFakeDownloadNodeIfNotStarted(int threadId, Map<String, String> parameters, Consumer<? super BuildEvent> messageConsumer) {
        MavenParsingContext.NodeExecutionEntry parentMojo = this.myContext.getNode(threadId, DOWNLOAD_DEPENDENCIES_NAME, false);
        if (parentMojo != null) {
            return parentMojo;
        }
        parentMojo = this.myContext.getNode(threadId, DOWNLOAD_DEPENDENCIES_NAME, true);
        MavenSpyOutputParser.doStart(messageConsumer, parentMojo);
        return parentMojo;
    }

    private void stopFakeDownloadNode(int threadId, Map<String, String> parameters, Consumer<? super BuildEvent> messageConsumer) {
        MavenParsingContext.NodeExecutionEntry parentMojo = this.myContext.getNode(threadId, DOWNLOAD_DEPENDENCIES_NAME, false);
        if (parentMojo != null) {
            MavenSpyOutputParser.doComplete(messageConsumer, parentMojo);
        }
    }

    private static void doSkip(Consumer<? super BuildEvent> messageConsumer, MavenParsingContext.MavenExecutionEntry execution) {
        if (execution == null) {
            MavenLog.LOG.warn("Error parsing maven log");
            return;
        }
        messageConsumer.accept((BuildEvent)new FinishEventImpl(execution.getId(), execution.getParentId(), System.currentTimeMillis(), execution.getName(), (EventResult)new SkippedResultImpl()));
        execution.complete();
    }

    private static void doStart(Consumer<? super BuildEvent> messageConsumer, MavenParsingContext.MavenExecutionEntry execution) {
        if (execution == null) {
            MavenLog.LOG.warn("Error parsing maven log");
            return;
        }
        messageConsumer.accept((BuildEvent)new StartEventImpl(execution.getId(), execution.getParentId(), System.currentTimeMillis(), execution.getName()));
    }

    private static void doError(Consumer<? super BuildEvent> messageConsumer, MavenParsingContext.MavenExecutionEntry execution, String errorMessage) {
        if (execution == null) {
            MavenLog.LOG.warn("Error parsing maven log");
            return;
        }
        messageConsumer.accept((BuildEvent)new FinishEventImpl(execution.getId(), execution.getParentId(), System.currentTimeMillis(), execution.getName(), (EventResult)new MavenTaskFailedResultImpl(errorMessage)));
        execution.complete();
    }

    private static void doComplete(Consumer<? super BuildEvent> messageConsumer, MavenParsingContext.MavenExecutionEntry execution) {
        if (execution == null) {
            MavenLog.LOG.warn("Error parsing maven log");
            return;
        }
        messageConsumer.accept((BuildEvent)new FinishEventImpl(execution.getId(), execution.getParentId(), System.currentTimeMillis(), execution.getName(), (EventResult)new SuccessResultImpl()));
        execution.complete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spyLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/MavenSpyOutputParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/MavenSpyOutputParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processLine";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

