/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001e\u0010\u0015\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010\u0018\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/maven/onlinecompletion/IndexBasedCompletionProvider;", "Lorg/jetbrains/idea/reposearch/DependencySearchProvider;", "myIndex", "Lorg/jetbrains/idea/maven/indices/MavenIndex;", "(Lorg/jetbrains/idea/maven/indices/MavenIndex;)V", "index", "Lorg/jetbrains/idea/maven/indices/MavenSearchIndex;", "getIndex", "()Lorg/jetbrains/idea/maven/indices/MavenSearchIndex;", "fulltextSearch", "", "searchString", "", "consumer", "Ljava/util/function/Consumer;", "Lorg/jetbrains/idea/reposearch/RepositoryArtifactData;", "isLocal", "", "nonExactMatches", "template", "real", "search", "mavenId", "Lorg/jetbrains/idea/maven/model/MavenId;", "suggestPrefix", "groupId", "artifactId", "intellij.maven"})
public final class IndexBasedCompletionProvider
implements DependencySearchProvider {
    private final MavenIndex myIndex;

    public void fulltextSearch(@NotNull String searchString, @NotNull Consumer<RepositoryArtifactData> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)searchString, (String)"searchString");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        MavenId mavenId = new MavenId(searchString);
        this.search(consumer, mavenId);
    }

    public void suggestPrefix(@Nullable String groupId, @Nullable String artifactId, @NotNull Consumer<RepositoryArtifactData> consumer) {
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        this.search(consumer, new MavenId(groupId, artifactId, null));
    }

    private final void search(Consumer<RepositoryArtifactData> consumer, MavenId mavenId) {
        for (String groupId : this.myIndex.getGroupIds()) {
            if (mavenId.getGroupId() != null) {
                String string = mavenId.getGroupId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mavenId.groupId!!");
                CharSequence charSequence = string;
                boolean bl = false;
                if (!(charSequence.length() == 0)) {
                    String string2 = groupId;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"groupId");
                    String string3 = mavenId.getGroupId();
                    if (string3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mavenId.groupId!!");
                    if (!this.nonExactMatches(string2, string3)) continue;
                }
            }
            for (String artifactId : this.myIndex.getArtifactIds(groupId)) {
                if (mavenId.getArtifactId() != null) {
                    String string = mavenId.getArtifactId();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mavenId.artifactId!!");
                    CharSequence charSequence = string;
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) {
                        String string4 = artifactId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"artifactId");
                        String string5 = mavenId.getArtifactId();
                        if (string5 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"mavenId.artifactId!!");
                        if (!this.nonExactMatches(string4, string5)) continue;
                    }
                }
                String string = groupId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"groupId");
                String string6 = artifactId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"artifactId");
                Set<String> set = this.myIndex.getVersions(groupId, artifactId);
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"myIndex.getVersions(groupId, artifactId)");
                MavenRepositoryArtifactInfo info = new MavenRepositoryArtifactInfo(string, string6, (Collection<String>)set);
                consumer.accept(info);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean nonExactMatches(String template, String real) {
        List splittedTemplate = StringsKt.split$default((CharSequence)template, (char[])new char[]{'-', '.'}, (boolean)false, (int)0, (int)6, null);
        List splittedReal = StringsKt.split$default((CharSequence)real, (char[])new char[]{'-', '.'}, (boolean)false, (int)0, (int)6, null);
        if (splittedTemplate.size() == 1 || splittedReal.size() == 1) {
            return StringUtil.startsWith((CharSequence)template, (CharSequence)real) || StringUtil.startsWith((CharSequence)real, (CharSequence)template);
        }
        int matches = 0;
        int n = 0;
        int n2 = Math.min(splittedReal.size(), splittedTemplate.size());
        while (n < n2) {
            void i;
            if (StringUtil.startsWith((CharSequence)((CharSequence)splittedTemplate.get((int)i)), (CharSequence)((CharSequence)splittedReal.get((int)i))) || StringUtil.startsWith((CharSequence)((CharSequence)splittedReal.get((int)i)), (CharSequence)((CharSequence)splittedTemplate.get((int)i)))) {
                ++matches;
            }
            if (matches >= 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    @NotNull
    public final MavenSearchIndex getIndex() {
        return this.myIndex;
    }

    public IndexBasedCompletionProvider(@NotNull MavenIndex myIndex) {
        Intrinsics.checkParameterIsNotNull((Object)myIndex, (String)"myIndex");
        this.myIndex = myIndex;
    }
}

