/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.MavenRepositoryProvider;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.onlinecompletion.IndexBasedCompletionProvider;
import org.jetbrains.idea.maven.onlinecompletion.ProjectModulesCompletionProvider;
import org.jetbrains.idea.maven.onlinecompletion.intellij.PackageSearchService;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.DependencySearchProvidersFactory;

public class MavenCompletionProviderFactory
implements DependencySearchProvidersFactory {
    public boolean isApplicable(Project project) {
        return MavenProjectsManager.getInstance(project).isMavenizedProject();
    }

    @NotNull
    public List<DependencySearchProvider> getProviders(Project project) {
        ArrayList<DependencySearchProvider> result = new ArrayList<DependencySearchProvider>();
        result.add(new ProjectModulesCompletionProvider(project));
        MavenCompletionProviderFactory.addLocalIndex(project, result);
        MavenCompletionProviderFactory.addRemoteIndices(project, result);
        if (Registry.is((String)"maven.packagesearch.enabled")) {
            MavenCompletionProviderFactory.addPackageSearchService(result);
        }
        ArrayList<DependencySearchProvider> arrayList = result;
        if (arrayList == null) {
            MavenCompletionProviderFactory.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static void addPackageSearchService(List<DependencySearchProvider> result) {
        result.add(new PackageSearchService());
    }

    private static void addRemoteIndices(Project project, List<DependencySearchProvider> result) {
        List<MavenIndex> privateIndices = MavenIndicesManager.getInstance().ensureIndicesExist(MavenCompletionProviderFactory.collectRemoteRepositoriesIdsAndUrls(project));
        for (MavenIndex index : privateIndices) {
            result.add(new IndexBasedCompletionProvider(index));
        }
    }

    private static void addLocalIndex(Project project, List<DependencySearchProvider> result) {
        File localRepository = (File)ReadAction.compute(() -> project.isDisposed() ? null : MavenProjectsManager.getInstance(project).getLocalRepository());
        MavenIndicesManager indicesManager = MavenIndicesManager.getInstance();
        MavenIndex localIndex = indicesManager.createIndexForLocalRepo(project, localRepository);
        if (localIndex != null) {
            result.add(new IndexBasedCompletionProvider(localIndex));
        }
    }

    private static Set<Pair<String, String>> collectRemoteRepositoriesIdsAndUrls(Project project) {
        THashSet result = new THashSet();
        HashSet<MavenRemoteRepository> remoteRepositories = new HashSet<MavenRemoteRepository>(MavenProjectsManager.getInstance(project).getRemoteRepositories());
        for (MavenRepositoryProvider repositoryProvider : (MavenRepositoryProvider[])MavenRepositoryProvider.EP_NAME.getExtensions()) {
            remoteRepositories.addAll(repositoryProvider.getRemoteRepositories(project));
        }
        for (MavenRemoteRepository each : remoteRepositories) {
            String id = each.getId();
            String url = each.getUrl();
            if ("central".equals(id) || url.contains("repo.maven.apache.org/maven2")) continue;
            result.add(Pair.create((Object)id, (Object)url));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/onlinecompletion/MavenCompletionProviderFactory", "getProviders"));
    }
}

