/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.project.MavenDisablePanelCheckbox;
import org.jetbrains.idea.maven.project.MavenGeneralPanel;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenGeneralSettingsEditor
extends SettingsEditor<MavenRunConfiguration> {
    private final MavenGeneralPanel myPanel;
    private JCheckBox myUseProjectSettings;
    private final Project myProject;

    public MavenGeneralSettingsEditor(@NotNull Project project) {
        if (project == null) {
            MavenGeneralSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myPanel = new MavenGeneralPanel();
    }

    protected void resetEditorFrom(@NotNull MavenRunConfiguration s) {
        if (s == null) {
            MavenGeneralSettingsEditor.$$$reportNull$$$0(1);
        }
        this.myUseProjectSettings.setSelected(s.getGeneralSettings() == null);
        if (s.getGeneralSettings() == null) {
            MavenGeneralSettings settings = MavenProjectsManager.getInstance(this.myProject).getGeneralSettings();
            this.myPanel.getData(settings);
        } else {
            this.myPanel.getData(s.getGeneralSettings());
        }
    }

    protected void applyEditorTo(@NotNull MavenRunConfiguration s) throws ConfigurationException {
        if (s == null) {
            MavenGeneralSettingsEditor.$$$reportNull$$$0(2);
        }
        if (this.myUseProjectSettings.isSelected()) {
            s.setGeneralSettings(null);
        } else {
            MavenGeneralSettings state = s.getGeneralSettings();
            if (state != null) {
                this.myPanel.setData(state);
            } else {
                MavenGeneralSettings settings = MavenProjectsManager.getInstance(this.myProject).getGeneralSettings().clone();
                this.myPanel.setData(settings);
                s.setGeneralSettings(settings);
            }
        }
    }

    @NotNull
    protected JComponent createEditor() {
        Pair<JPanel, JCheckBox> pair = MavenDisablePanelCheckbox.createPanel(this.myPanel.createComponent(), "Use project settings");
        this.myUseProjectSettings = (JCheckBox)pair.second;
        JComponent jComponent = (JComponent)pair.first;
        if (jComponent == null) {
            MavenGeneralSettingsEditor.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenGeneralSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenGeneralSettingsEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

